/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.keygen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.keygen.GetTCLAction;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCInformixCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private static final String NAME = "class-name";
    private static final String DEFAULT_CLASS = "com.informix.jdbc.IfxStatement";
    private static final String METHOD = "method";
    private static final String DEFAULT_METHOD = "getSerial";
    private String className;
    private String methodName;
    private Method method;
    private Method getUnderlyingStatement;

    @Override
    public void init(JDBCStoreManager manager) {
        super.init(manager);
        ClassLoader loader = GetTCLAction.getContextClassLoader();
        try {
            Class<?> psClass = loader.loadClass(this.className);
            this.method = psClass.getMethod(this.methodName, new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw CmpMessages.MESSAGES.failedToLoadDriverClass(this.className, e);
        }
        catch (NoSuchMethodException e) {
            throw CmpMessages.MESSAGES.driverDoesNotHaveMethod(this.className, this.methodName);
        }
        try {
            Class<?> wrapperClass = loader.loadClass("org.jboss.resource.adapter.jdbc.StatementAccess");
            this.getUnderlyingStatement = wrapperClass.getMethod("getUnderlyingStatement", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw CmpMessages.MESSAGES.couldNotLoadStatementAccess(e);
        }
        catch (NoSuchMethodException e) {
            throw CmpMessages.MESSAGES.getUnderlyingStatementNotFound(e);
        }
    }

    @Override
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        super.initEntityCommand(entityCommand);
        this.className = entityCommand.getAttribute(NAME);
        if (this.className == null) {
            this.className = DEFAULT_CLASS;
        }
        this.methodName = entityCommand.getAttribute(METHOD);
        if (this.methodName == null) {
            this.methodName = DEFAULT_METHOD;
        }
    }

    @Override
    protected int executeInsert(int paramIndex, PreparedStatement ps, CmpEntityBeanContext ctx) throws SQLException {
        int rows = ps.executeUpdate();
        Statement stmt = ps;
        do {
            try {
                Object[] args = new Object[]{};
                stmt = (Statement)this.getUnderlyingStatement.invoke((Object)stmt, args);
            }
            catch (IllegalAccessException e) {
                SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
                ex.initCause(e);
                throw ex;
            }
            catch (InvocationTargetException e) {
                SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
                ex.initCause(e);
                throw ex;
            }
        } while (stmt != null && !this.method.getDeclaringClass().isInstance(stmt));
        try {
            Number pk = (Number)this.method.invoke((Object)stmt, new Object[0]);
            this.pkField.setInstanceValue(ctx, pk);
            return rows;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorExtractingGeneratedKey(e);
        }
    }
}

