/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EntityBean;
import org.jboss.as.cmp.component.CmpProxy;
import org.jboss.invocation.proxy.MethodBodyCreator;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.invocation.proxy.ProxyConfiguration;
import org.jboss.invocation.proxy.ProxyFactory;

public class CmpProxyFactory
extends ProxyFactory<EntityBean> {
    private static final AtomicInteger PROXY_ID = new AtomicInteger(0);
    private final Class<?> beanClass;

    public static ProxyFactory<EntityBean> createProxyFactory(Class<EntityBean> beanClass, Class<?> ... viewClasses) {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        proxyConfiguration.setProxyName(beanClass.getName() + "$$$cmp" + PROXY_ID.incrementAndGet());
        proxyConfiguration.setClassLoader(beanClass.getClassLoader());
        proxyConfiguration.setProtectionDomain(beanClass.getProtectionDomain());
        proxyConfiguration.setSuperClass(beanClass);
        if (viewClasses != null) {
            for (Class<?> viewClass : viewClasses) {
                if (viewClass == null) continue;
                proxyConfiguration.addAdditionalInterface(viewClass);
            }
        }
        proxyConfiguration.addAdditionalInterface(CmpProxy.class);
        return new CmpProxyFactory(beanClass, (ProxyConfiguration<EntityBean>)proxyConfiguration);
    }

    public CmpProxyFactory(Class<?> beanClass, ProxyConfiguration<EntityBean> proxyConfiguration) {
        super(proxyConfiguration);
        this.beanClass = beanClass;
    }

    protected boolean overrideMethod(Method method, MethodIdentifier identifier, MethodBodyCreator creator) {
        boolean override = true;
        boolean found = false;
        for (Class<?> c = this.beanClass; c != null; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                if (!m.getName().equals(method.getName()) || !m.getReturnType().equals(method.getReturnType()) || !Arrays.equals(m.getParameterTypes(), method.getParameterTypes())) continue;
                override = Modifier.isAbstract(m.getModifiers());
                found = true;
                break;
            }
            if (found) break;
        }
        return override && super.overrideMethod(method, identifier, creator);
    }
}

