/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.security.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class SecuritySubsystemDescriptions {
    static final String RESOURCE_NAME = SecuritySubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIBE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSecurityDomain(locale);
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSecurityDomainAdd(locale);
        }
    };
    static final DescriptionProvider SECURITY_DOMAIN_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSecurityDomainRemove(locale);
        }
    };
    static final DescriptionProvider SECURITY_PROPERTIES_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getProperties(locale);
        }
    };
    static final DescriptionProvider SECURITY_PROPERTIES_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getPropertiesAdd(locale);
        }
    };
    static final DescriptionProvider SECURITY_PROPERTIES_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getPropertiesRemove(locale);
        }
    };
    static final DescriptionProvider LIST_CACHED_PRINCIPALS = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getListCachedPrincipals(locale);
        }
    };
    static final DescriptionProvider FLUSH_CACHE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getFlushCache(locale);
        }
    };

    SecuritySubsystemDescriptions() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle2.getString("security"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.CURRENT.getUriString());
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "description"}).set(bundle2.getString("authentication-manager"));
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "authentication-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "description"}).set(bundle2.getString("deep-copy-subject-mode"));
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "deep-copy-subject-mode", "default"}).set(false);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "description"}).set(bundle2.getString("default-callback-handler-class-name"));
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "default-callback-handler-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "description"}).set(bundle2.getString("subject-factory-class-name"));
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "subject-factory-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "description"}).set(bundle2.getString("authorization-manager-class-name"));
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "authorization-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "description"}).set(bundle2.getString("audit-manager-class-name"));
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "audit-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "description"}).set(bundle2.getString("identity-trust-manager-class-name"));
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "identity-trust-manager-class-name", "default"}).set("default");
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "description"}).set(bundle2.getString("mapping-manager-class-name"));
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "mapping-manager-class-name", "default"}).set("default");
            subsystem.get("security-properties").set(Descriptions.getProperties(locale));
            subsystem.get(new String[]{"children", "security-domain", "description"}).set(bundle2.getString("security-domain-children"));
            subsystem.get(new String[]{"children", "security-domain", "required"}).set(false);
            subsystem.get(new String[]{"children", "security-domain", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "security-domain", "max-occurs"}).set(Integer.MAX_VALUE);
            subsystem.get(new String[]{"children", "security-domain", "model-description"}).setEmptyObject();
            subsystem.get("vault").set(Descriptions.getVault(locale));
            subsystem.get(new String[]{"children", "vault-option", "description"}).set(bundle2.getString("vault.option"));
            subsystem.get(new String[]{"children", "vault-option", "required"}).set(false);
            subsystem.get(new String[]{"children", "vault-option", "min-occurs"}).set(0);
            subsystem.get(new String[]{"children", "vault-option", "max-occurs"}).set(Integer.MAX_VALUE);
            subsystem.get(new String[]{"children", "vault-option", "model-description"}).setEmptyObject();
            return subsystem;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle2.getString("security.add"));
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "description"}).set(bundle2.getString("authentication-manager"));
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "authentication-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "description"}).set(bundle2.getString("deep-copy-subject-mode"));
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "type"}).set(ModelType.BOOLEAN);
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "required"}).set(false);
            op.get(new String[]{"request-properties", "deep-copy-subject-mode", "default"}).set(false);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "description"}).set(bundle2.getString("default-callback-handler-class-name"));
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "default-callback-handler-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "subject-factory-class-name", "description"}).set(bundle2.getString("subject-factory-class-name"));
            op.get(new String[]{"request-properties", "subject-factory-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "subject-factory-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "subject-factory-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "description"}).set(bundle2.getString("authorization-manager-class-name"));
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "authorization-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "audit-manager-class-name", "description"}).set(bundle2.getString("audit-manager-class-name"));
            op.get(new String[]{"request-properties", "audit-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "audit-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "audit-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "description"}).set(bundle2.getString("identity-trust-manager-class-name"));
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "identity-trust-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "description"}).set(bundle2.getString("mapping-manager-class-name"));
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "required"}).set(false);
            op.get(new String[]{"request-properties", "mapping-manager-class-name", "default"}).set("default");
            op.get(new String[]{"request-properties", "security-properties", "description"}).set(bundle2.getString("security-properties"));
            op.get(new String[]{"request-properties", "security-properties", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "security-properties", "required"}).set(false);
            op.get("security-properties").set(Descriptions.getPropertiesAdd(locale));
            op.get(new String[]{"request-properties", "vault", "description"}).set(bundle2.getString("vault"));
            op.get(new String[]{"request-properties", "vault", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "vault", "required"}).set(false);
            op.get("reply-properties").setEmptyObject();
            return op;
        }

        static ModelNode getSecurityDomain(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle2.getString("security-domain"));
            op.get("head-comment-allowed").set(true);
            op.get("tail-comment-allowed").set(true);
            op.get(new String[]{"attributes", "extends", "description"}).set(bundle2.getString("extends"));
            op.get(new String[]{"attributes", "extends", "type"}).set(ModelType.STRING);
            op.get(new String[]{"attributes", "extends", "required"}).set(false);
            op.get(new String[]{"attributes", "cache-type", "description"}).set(bundle2.getString("cache-type"));
            op.get(new String[]{"attributes", "cache-type", "type"}).set(ModelType.STRING);
            op.get(new String[]{"attributes", "cache-type", "required"}).set(false);
            op.get(new String[]{"children", "authentication"}).set(Descriptions.getAuthentication(locale));
            op.get(new String[]{"children", "authentication-jaspi"}).set(Descriptions.getAuthenticationJaspi(locale));
            op.get(new String[]{"children", "authorization"}).set(Descriptions.getAuthorization(locale));
            op.get(new String[]{"children", "acl"}).set(Descriptions.getAcl(locale));
            op.get(new String[]{"children", "audit"}).set(Descriptions.getAudit(locale));
            op.get(new String[]{"children", "identity-trust"}).set(Descriptions.getIdentityTrust(locale));
            op.get(new String[]{"children", "mapping"}).set(Descriptions.getMapping(locale));
            op.get(new String[]{"children", "jsse"}).set(Descriptions.getJSSE(locale));
            return op;
        }

        static ModelNode getSecurityDomainAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle2.getString("security-domain.add"));
            op.get(new String[]{"request-properties", "extends", "description"}).set(bundle2.getString("extends"));
            op.get(new String[]{"request-properties", "extends", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "extends", "required"}).set(false);
            op.get(new String[]{"request-properties", "cache-type", "description"}).set(bundle2.getString("cache-type"));
            op.get(new String[]{"request-properties", "cache-type", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "cache-type", "required"}).set(false);
            op.get(new String[]{"request-properties", "authentication", "description"}).set(bundle2.getString("authentication"));
            op.get(new String[]{"request-properties", "authentication", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "authentication", "required"}).set(false);
            op.get(new String[]{"request-properties", "authentication-jaspi", "description"}).set(bundle2.getString("authentication-jaspi"));
            op.get(new String[]{"request-properties", "authentication-jaspi", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "authentication-jaspi", "required"}).set(false);
            op.get(new String[]{"request-properties", "authorization", "description"}).set(bundle2.getString("authorization"));
            op.get(new String[]{"request-properties", "authorization", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "authorization", "required"}).set(false);
            op.get(new String[]{"request-properties", "acl", "description"}).set(bundle2.getString("acl"));
            op.get(new String[]{"request-properties", "acl", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "acl", "required"}).set(false);
            op.get(new String[]{"request-properties", "audit", "description"}).set(bundle2.getString("audit"));
            op.get(new String[]{"request-properties", "audit", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "audit", "required"}).set(false);
            op.get(new String[]{"request-properties", "identity-trust", "description"}).set(bundle2.getString("identity-trust"));
            op.get(new String[]{"request-properties", "identity-trust", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "identity-trust", "required"}).set(false);
            op.get(new String[]{"request-properties", "mapping", "description"}).set(bundle2.getString("mapping"));
            op.get(new String[]{"request-properties", "mapping", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "mapping", "required"}).set(false);
            op.get(new String[]{"request-properties", "jsse", "description"}).set(bundle2.getString("jsse"));
            op.get(new String[]{"request-properties", "jsse", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "jsse", "required"}).set(false);
            return op;
        }

        static ModelNode getSecurityDomainRemove(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove");
            op.get("description").set(bundle2.getString("security-domain.remove"));
            return op;
        }

        static ModelNode getModuleOptions(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("module-options"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "name", "description"}).set(bundle2.getString("module-options.name"));
            node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "name", "required"}).set(true);
            node.get(new String[]{"attributes", "value", "description"}).set(bundle2.getString("module-options.value"));
            node.get(new String[]{"attributes", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "value", "required"}).set(true);
            return node;
        }

        static ModelNode getModuleOptionsAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("module-options"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("module-options.name"));
            node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "name", "required"}).set(true);
            node.get(new String[]{"request-properties", "value", "description"}).set(bundle2.getString("module-options.value"));
            node.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "value", "required"}).set(true);
            return node;
        }

        static ModelNode getProperties(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("security-properties"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "name", "description"}).set(bundle2.getString("security-properties.name"));
            node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "name", "required"}).set(true);
            node.get(new String[]{"attributes", "value", "description"}).set(bundle2.getString("security-properties.value"));
            node.get(new String[]{"attributes", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "value", "required"}).set(true);
            return node;
        }

        static ModelNode getPropertiesAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("security-properties"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("security-properties.name"));
            node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "name", "required"}).set(true);
            node.get(new String[]{"request-properties", "value", "description"}).set(bundle2.getString("security-properties.value"));
            node.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "value", "required"}).set(true);
            return node;
        }

        static ModelNode getPropertiesRemove(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove");
            op.get("description").set(bundle2.getString("security-properties.remove"));
            return op;
        }

        static ModelNode getVault(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("vault"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("vault.code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "name", "required"}).set(false);
            return node;
        }

        static ModelNode getAuthentication(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("authentication"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "code", "required"}).set(true);
            node.get(new String[]{"attributes", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"attributes", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAuthenticationAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("authentication"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"request-properties", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "code", "required"}).set(true);
            node.get(new String[]{"request-properties", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"request-properties", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAuthenticationJaspi(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("authentication-jaspi"));
            node.get("required").set(false);
            node.get("login-module-stack").set(Descriptions.getLoginModuleStack(locale));
            node.get("auth-module").set(Descriptions.getAuthModule(locale));
            return node;
        }

        static ModelNode getAuthenticationJaspiAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("authentication-jaspi"));
            node.get("required").set(false);
            node.get("login-module-stack").set(Descriptions.getLoginModuleStackAdd(locale));
            node.get("auth-module").set(Descriptions.getAuthModuleAdd(locale));
            return node;
        }

        static ModelNode getLoginModuleStack(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle2.getString("authentication-jaspi.login-module-stack"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "name", "description"}).set(bundle2.getString("authentication-jaspi.login-module-stack.name"));
            node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "name", "required"}).set(true);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "code", "required"}).set(true);
            node.get(new String[]{"attributes", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"attributes", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getLoginModuleStackAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle2.getString("authentication-jaspi.login-module-stack"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("authentication-jaspi.login-module-stack.name"));
            node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "name", "required"}).set(true);
            node.get(new String[]{"request-properties", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"request-properties", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "code", "required"}).set(true);
            node.get(new String[]{"request-properties", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"request-properties", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAuthModule(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle2.getString("authentication-jaspi.auth-module"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "code", "required"}).set(true);
            node.get(new String[]{"attributes", "login-module-stack-ref", "description"}).set(bundle2.getString("login-module-stack-ref"));
            node.get(new String[]{"attributes", "login-module-stack-ref", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "login-module-stack-ref", "required"}).set(false);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAuthModuleAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle2.getString("authentication-jaspi.auth-module"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"request-properties", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "code", "required"}).set(true);
            node.get(new String[]{"request-properties", "login-module-stack-ref", "description"}).set(bundle2.getString("login-module-stack-ref"));
            node.get(new String[]{"request-properties", "login-module-stack-ref", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "login-module-stack-ref", "required"}).set(false);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAuthorization(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("authorization"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "code", "required"}).set(true);
            node.get(new String[]{"attributes", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"attributes", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAuthorizationAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("authorization"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"request-properties", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "code", "required"}).set(true);
            node.get(new String[]{"request-properties", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"request-properties", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAcl(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("acl"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "code", "required"}).set(true);
            node.get(new String[]{"attributes", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"attributes", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAclAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("acl"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"request-properties", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "code", "required"}).set(true);
            node.get(new String[]{"request-properties", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"request-properties", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getAudit(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("audit"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "code", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getAuditAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("audit"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"request-properties", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "code", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getIdentityTrust(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("identity-trust"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "code", "required"}).set(true);
            node.get(new String[]{"attributes", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"attributes", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getIdentityTrustAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("identity-trust"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"request-properties", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "code", "required"}).set(true);
            node.get(new String[]{"request-properties", "flag", "description"}).set(bundle2.getString("flag"));
            node.get(new String[]{"request-properties", "flag", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "flag", "required"}).set(true);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getMapping(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("mapping"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"attributes", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "code", "required"}).set(true);
            node.get(new String[]{"attributes", "type", "description"}).set(bundle2.getString("type"));
            node.get(new String[]{"attributes", "type", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "type", "required"}).set(false);
            node.get("module-options").set(Descriptions.getModuleOptions(locale));
            return node;
        }

        static ModelNode getMappingAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle2.getString("mapping"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "code", "description"}).set(bundle2.getString("code"));
            node.get(new String[]{"request-properties", "code", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "code", "required"}).set(true);
            node.get(new String[]{"request-properties", "type", "description"}).set(bundle2.getString("type"));
            node.get(new String[]{"request-properties", "type", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "type", "required"}).set(false);
            node.get("module-options").set(Descriptions.getModuleOptionsAdd(locale));
            return node;
        }

        static ModelNode getJSSE(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle2.getString("jsse"));
            node.get("required").set(false);
            node.get(new String[]{"attributes", "keystore-password", "description"}).set(bundle2.getString("keystore-password"));
            node.get(new String[]{"attributes", "keystore-password", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "keystore-password", "required"}).set(false);
            node.get(new String[]{"attributes", "keystore-type", "description"}).set(bundle2.getString("keystore-type"));
            node.get(new String[]{"attributes", "keystore-type", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "keystore-type", "required"}).set(false);
            node.get(new String[]{"attributes", "keystore-url", "description"}).set(bundle2.getString("keystore-url"));
            node.get(new String[]{"attributes", "keystore-url", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "keystore-url", "required"}).set(false);
            node.get(new String[]{"attributes", "keystore-provider", "description"}).set(bundle2.getString("keystore-provider"));
            node.get(new String[]{"attributes", "keystore-provider", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "keystore-provider", "required"}).set(false);
            node.get(new String[]{"attributes", "keystore-provider-argument", "description"}).set(bundle2.getString("keystore-provider-argument"));
            node.get(new String[]{"attributes", "keystore-provider-argument", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "keystore-provider-argument", "required"}).set(false);
            node.get(new String[]{"attributes", "key-manager-factory-provider", "description"}).set(bundle2.getString("key-manager-factory-provider"));
            node.get(new String[]{"attributes", "key-manager-factory-provider", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "key-manager-factory-provider", "required"}).set(false);
            node.get(new String[]{"attributes", "key-manager-factory-algorithm", "description"}).set(bundle2.getString("key-manager-factory-algorithm"));
            node.get(new String[]{"attributes", "key-manager-factory-algorithm", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "key-manager-factory-algorithm", "required"}).set(false);
            node.get(new String[]{"attributes", "truststore-password", "description"}).set(bundle2.getString("truststore-password"));
            node.get(new String[]{"attributes", "truststore-password", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "truststore-password", "required"}).set(false);
            node.get(new String[]{"attributes", "truststore-type", "description"}).set(bundle2.getString("truststore-type"));
            node.get(new String[]{"attributes", "truststore-type", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "truststore-type", "required"}).set(false);
            node.get(new String[]{"attributes", "truststore-url", "description"}).set(bundle2.getString("truststore-url"));
            node.get(new String[]{"attributes", "truststore-url", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "truststore-url", "required"}).set(false);
            node.get(new String[]{"attributes", "truststore-provider", "description"}).set(bundle2.getString("truststore-provider"));
            node.get(new String[]{"attributes", "truststore-provider", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "truststore-provider", "required"}).set(false);
            node.get(new String[]{"attributes", "truststore-provider-argument", "description"}).set(bundle2.getString("truststore-provider-argument"));
            node.get(new String[]{"attributes", "truststore-provider-argument", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "truststore-provider-argument", "required"}).set(false);
            node.get(new String[]{"attributes", "trust-manager-factory-provider", "description"}).set(bundle2.getString("trust-manager-factory-provider"));
            node.get(new String[]{"attributes", "trust-manager-factory-provider", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "trust-manager-factory-provider", "required"}).set(false);
            node.get(new String[]{"attributes", "trust-manager-factory-algorithm", "description"}).set(bundle2.getString("trust-manager-factory-algorithm"));
            node.get(new String[]{"attributes", "trust-manager-factory-algorithm", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "trust-manager-factory-algorithm", "required"}).set(false);
            node.get(new String[]{"attributes", "client-alias", "description"}).set(bundle2.getString("client-alias"));
            node.get(new String[]{"attributes", "client-alias", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "client-alias", "required"}).set(false);
            node.get(new String[]{"attributes", "server-alias", "description"}).set(bundle2.getString("server-alias"));
            node.get(new String[]{"attributes", "server-alias", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "server-alias", "required"}).set(false);
            node.get(new String[]{"attributes", "client-auth", "description"}).set(bundle2.getString("client-auth"));
            node.get(new String[]{"attributes", "client-auth", "type"}).set(ModelType.BOOLEAN);
            node.get(new String[]{"attributes", "client-auth", "required"}).set(false);
            node.get(new String[]{"attributes", "service-auth-token", "description"}).set(bundle2.getString("service-auth-token"));
            node.get(new String[]{"attributes", "service-auth-token", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "service-auth-token", "required"}).set(false);
            node.get(new String[]{"attributes", "cipher-suites", "description"}).set(bundle2.getString("cipher-suites"));
            node.get(new String[]{"attributes", "cipher-suites", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "cipher-suites", "required"}).set(false);
            node.get(new String[]{"attributes", "protocols", "description"}).set(bundle2.getString("protocols"));
            node.get(new String[]{"attributes", "protocols", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "protocols", "required"}).set(false);
            node.get(new String[]{"attributes", "additional-properties", "description"}).set(bundle2.getString("additional-properties"));
            node.get(new String[]{"attributes", "additional-properties", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "additional-properties", "required"}).set(false);
            return node;
        }

        static ModelNode getJSSEAdd(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle2.getString("jsse"));
            node.get("required").set(false);
            node.get(new String[]{"request-properties", "keystore-password", "description"}).set(bundle2.getString("keystore-password"));
            node.get(new String[]{"request-properties", "keystore-password", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "keystore-password", "required"}).set(false);
            node.get(new String[]{"request-properties", "keystore-type", "description"}).set(bundle2.getString("keystore-type"));
            node.get(new String[]{"request-properties", "keystore-type", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "keystore-type", "required"}).set(false);
            node.get(new String[]{"request-properties", "keystore-url", "description"}).set(bundle2.getString("keystore-url"));
            node.get(new String[]{"request-properties", "keystore-url", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "keystore-url", "required"}).set(false);
            node.get(new String[]{"request-properties", "keystore-provider", "description"}).set(bundle2.getString("keystore-provider"));
            node.get(new String[]{"request-properties", "keystore-provider", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "keystore-provider", "required"}).set(false);
            node.get(new String[]{"request-properties", "keystore-provider-argument", "description"}).set(bundle2.getString("keystore-provider-argument"));
            node.get(new String[]{"request-properties", "keystore-provider-argument", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "keystore-provider-argument", "required"}).set(false);
            node.get(new String[]{"request-properties", "key-manager-factory-provider", "description"}).set(bundle2.getString("key-manager-factory-provider"));
            node.get(new String[]{"request-properties", "key-manager-factory-provider", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "key-manager-factory-provider", "required"}).set(false);
            node.get(new String[]{"request-properties", "key-manager-factory-algorithm", "description"}).set(bundle2.getString("key-manager-factory-algorithm"));
            node.get(new String[]{"request-properties", "key-manager-factory-algorithm", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "key-manager-factory-algorithm", "required"}).set(false);
            node.get(new String[]{"request-properties", "truststore-password", "description"}).set(bundle2.getString("truststore-password"));
            node.get(new String[]{"request-properties", "truststore-password", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "truststore-password", "required"}).set(false);
            node.get(new String[]{"request-properties", "truststore-type", "description"}).set(bundle2.getString("truststore-type"));
            node.get(new String[]{"request-properties", "truststore-type", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "truststore-type", "required"}).set(false);
            node.get(new String[]{"request-properties", "truststore-url", "description"}).set(bundle2.getString("truststore-url"));
            node.get(new String[]{"request-properties", "truststore-url", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "truststore-url", "required"}).set(false);
            node.get(new String[]{"request-properties", "truststore-provider", "description"}).set(bundle2.getString("truststore-provider"));
            node.get(new String[]{"request-properties", "truststore-provider", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "truststore-provider", "required"}).set(false);
            node.get(new String[]{"request-properties", "truststore-provider-argument", "description"}).set(bundle2.getString("truststore-provider-argument"));
            node.get(new String[]{"request-properties", "truststore-provider-argument", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "truststore-provider-argument", "required"}).set(false);
            node.get(new String[]{"request-properties", "trust-manager-factory-provider", "description"}).set(bundle2.getString("trust-manager-factory-provider"));
            node.get(new String[]{"request-properties", "trust-manager-factory-provider", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "trust-manager-factory-provider", "required"}).set(false);
            node.get(new String[]{"request-properties", "trust-manager-factory-algorithm", "description"}).set(bundle2.getString("trust-manager-factory-algorithm"));
            node.get(new String[]{"request-properties", "trust-manager-factory-algorithm", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "trust-manager-factory-algorithm", "required"}).set(false);
            node.get(new String[]{"request-properties", "client-alias", "description"}).set(bundle2.getString("client-alias"));
            node.get(new String[]{"request-properties", "client-alias", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "client-alias", "required"}).set(false);
            node.get(new String[]{"request-properties", "server-alias", "description"}).set(bundle2.getString("server-alias"));
            node.get(new String[]{"request-properties", "server-alias", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "server-alias", "required"}).set(false);
            node.get(new String[]{"request-properties", "client-auth", "description"}).set(bundle2.getString("client-auth"));
            node.get(new String[]{"request-properties", "client-auth", "type"}).set(ModelType.BOOLEAN);
            node.get(new String[]{"request-properties", "client-auth", "required"}).set(false);
            node.get(new String[]{"request-properties", "service-auth-token", "description"}).set(bundle2.getString("service-auth-token"));
            node.get(new String[]{"request-properties", "service-auth-token", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "service-auth-token", "required"}).set(false);
            node.get(new String[]{"request-properties", "cipher-suites", "description"}).set(bundle2.getString("cipher-suites"));
            node.get(new String[]{"request-properties", "cipher-suites", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "cipher-suites", "required"}).set(false);
            node.get(new String[]{"request-properties", "protocols", "description"}).set(bundle2.getString("protocols"));
            node.get(new String[]{"request-properties", "protocols", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "protocols", "required"}).set(false);
            node.get(new String[]{"request-properties", "additional-properties", "description"}).set(bundle2.getString("additional-properties"));
            node.get(new String[]{"request-properties", "additional-properties", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "additional-properties", "required"}).set(false);
            return node;
        }

        static ModelNode getListCachedPrincipals(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("list-cached-principals");
            op.get("description").set(bundle2.getString("list-cached-principals"));
            return op;
        }

        static ModelNode getFlushCache(Locale locale) {
            ResourceBundle bundle2 = SecuritySubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("flush-cache");
            op.get("description").set(bundle2.getString("flush-cache"));
            return op;
        }
    }
}

