/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.dmr.ModelNode;

public abstract class AbstractLogHandlerAssignmentHandler
extends AbstractModelUpdateHandler {
    protected void updateHandlersForAssign(AttributeDefinition handlerAttribute, ModelNode operation, ModelNode model) throws OperationFailedException {
        String handlerName = this.getHandlerName(operation);
        if (this.handlerExists(handlerName, handlerAttribute, model)) {
            throw AbstractLogHandlerAssignmentHandler.createFailureMessage(LoggingMessages.MESSAGES.handlerAlreadyDefined(handlerName));
        }
        model.get(handlerAttribute.getName()).add(handlerName);
    }

    protected void updateHandlersForUnassign(AttributeDefinition handlerAttribute, ModelNode operation, ModelNode model) throws OperationFailedException {
        ArrayList<ModelNode> newSubhandlers;
        String handlerName = this.getHandlerName(operation);
        if (this.handlerExists(handlerName, handlerAttribute, model)) {
            ModelNode currentSubhandlers = model.get(handlerAttribute.getName());
            newSubhandlers = new ArrayList<ModelNode>();
            for (ModelNode node : currentSubhandlers.asList()) {
                if (node.asString().equals(handlerName)) continue;
                newSubhandlers.add(node);
            }
        } else {
            throw AbstractLogHandlerAssignmentHandler.createFailureMessage(LoggingMessages.MESSAGES.cannotUnassignHandler(handlerName));
        }
        model.get(handlerAttribute.getName()).set(newSubhandlers);
    }

    protected static OperationFailedException createFailureMessage(String description) {
        ModelNode failure = new ModelNode().set(description);
        return new OperationFailedException(failure);
    }

    protected boolean handlerExists(String handlerName, AttributeDefinition handlerAttribute, ModelNode model) throws OperationFailedException {
        ModelNode assignedHandlers = model.get(handlerAttribute.getName());
        if (assignedHandlers.isDefined()) {
            List handlers = assignedHandlers.asList();
            for (ModelNode handler : handlers) {
                if (!handler.asString().equals(handlerName)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract String getHandlerName(ModelNode var1) throws OperationFailedException;
}

