/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HandlerFileService
implements Service<String> {
    private static final char SEPARATOR = '/';
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private String path;
    private volatile String fileName;

    public HandlerFileService(String path) {
        this.path = path;
    }

    public synchronized void start(StartContext context) throws StartException {
        String value = (String)this.relativeTo.getOptionalValue();
        this.fileName = value != null && !AbstractPathService.isAbsoluteUnixOrWindowsPath((String)this.path) ? value + '/' + this.path : this.path;
    }

    public synchronized void stop(StopContext context) {
        this.fileName = null;
    }

    public synchronized void setPath(String path) {
        this.path = path;
        String value = (String)this.relativeTo.getOptionalValue();
        this.fileName = value != null && !AbstractPathService.isAbsoluteUnixOrWindowsPath((String)path) ? value + '/' + path : path;
    }

    public String getValue() throws IllegalStateException, IllegalArgumentException {
        return this.fileName;
    }

    public Injector<String> getRelativeToInjector() {
        return this.relativeTo;
    }
}

