/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.component.messagedriven.DefaultResourceAdapterService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EJBComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.ViewInterfaces;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.ejb3.JBossGenericBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class MessageDrivenComponentDescriptionFactory
extends EJBComponentDescriptionFactory {
    private static final Logger logger = Logger.getLogger(MessageDrivenComponentDescriptionFactory.class);
    private static final DotName MESSAGE_DRIVEN_ANNOTATION_NAME = DotName.createSimple((String)MessageDriven.class.getName());

    public MessageDrivenComponentDescriptionFactory(boolean appclient) {
        super(appclient);
    }

    @Override
    protected void processAnnotations(DeploymentUnit deploymentUnit, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        this.processMessageBeans(deploymentUnit, compositeIndex.getAnnotations(MESSAGE_DRIVEN_ANNOTATION_NAME), compositeIndex);
    }

    @Override
    protected void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData enterpriseBeanMetaData) throws DeploymentUnitProcessingException {
        if (enterpriseBeanMetaData.isMessageDriven()) {
            assert (enterpriseBeanMetaData instanceof MessageDrivenBeanMetaData) : enterpriseBeanMetaData + " is not a MessageDrivenBeanMetaData";
            this.processMessageDrivenBeanMetaData(deploymentUnit, (MessageDrivenBeanMetaData)enterpriseBeanMetaData);
        }
    }

    private void processMessageBeans(DeploymentUnit deploymentUnit, Collection<AnnotationInstance> messageBeanAnnotations, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        if (messageBeanAnnotations.isEmpty()) {
            return;
        }
        EjbJarDescription ejbJarDescription = AbstractDeploymentUnitProcessor.getEjbJarDescription(deploymentUnit);
        ServiceName deploymentUnitServiceName = deploymentUnit.getServiceName();
        DeploymentDescriptorEnvironment deploymentDescriptorEnvironment = null;
        for (AnnotationInstance messageBeanAnnotation : messageBeanAnnotations) {
            String messageListenerInterfaceName;
            String beanClassName;
            AnnotationTarget target = messageBeanAnnotation.target();
            ClassInfo beanClassInfo = (ClassInfo)target;
            if (!this.assertMDBClassValidity(beanClassInfo)) continue;
            String ejbName = beanClassInfo.name().local();
            AnnotationValue nameValue = messageBeanAnnotation.value("name");
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? ejbName : nameValue.asString();
            MessageDrivenBeanMetaData beanMetaData = MessageDrivenComponentDescriptionFactory.getEnterpriseBeanMetaData(deploymentUnit, beanName, MessageDrivenBeanMetaData.class);
            Properties activationConfigProperties = this.getActivationConfigProperties(messageBeanAnnotation);
            if (beanMetaData != null) {
                ActivationConfigPropertiesMetaData propertiesMetaData;
                ActivationConfigMetaData activationConfigMetaData;
                String messagingType;
                MessageDrivenBeanMetaData mdb;
                beanClassName = MessageDrivenComponentDescriptionFactory.override(beanClassInfo.name().toString(), beanMetaData.getEjbClass());
                deploymentDescriptorEnvironment = new DeploymentDescriptorEnvironment("java:comp/env/", (RemoteEnvironment)beanMetaData);
                if (beanMetaData instanceof MessageDrivenBeanMetaData) {
                    mdb = beanMetaData;
                    messagingType = mdb.getMessagingType();
                    activationConfigMetaData = mdb.getActivationConfig();
                    if (activationConfigMetaData != null && (propertiesMetaData = activationConfigMetaData.getActivationConfigProperties()) != null) {
                        for (ActivationConfigPropertyMetaData propertyMetaData : propertiesMetaData) {
                            activationConfigProperties.put(propertyMetaData.getKey(), propertyMetaData.getValue());
                        }
                    }
                } else if (beanMetaData instanceof JBossGenericBeanMetaData) {
                    mdb = (JBossGenericBeanMetaData)beanMetaData;
                    messagingType = mdb.getMessagingType();
                    activationConfigMetaData = mdb.getActivationConfig();
                    if (activationConfigMetaData != null && (propertiesMetaData = activationConfigMetaData.getActivationConfigProperties()) != null) {
                        for (ActivationConfigPropertyMetaData propertyMetaData : propertiesMetaData) {
                            activationConfigProperties.put(propertyMetaData.getKey(), propertyMetaData.getValue());
                        }
                    }
                } else {
                    messagingType = null;
                }
                messageListenerInterfaceName = messagingType != null ? messagingType : this.getMessageListenerInterface(compositeIndex, messageBeanAnnotation);
            } else {
                beanClassName = beanClassInfo.name().toString();
                messageListenerInterfaceName = this.getMessageListenerInterface(compositeIndex, messageBeanAnnotation);
            }
            String defaultResourceAdapterName = this.getDefaultResourceAdapterName(deploymentUnit.getServiceRegistry());
            MessageDrivenComponentDescription beanDescription = new MessageDrivenComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName, messageListenerInterfaceName, activationConfigProperties, defaultResourceAdapterName, beanMetaData);
            beanDescription.setDeploymentDescriptorEnvironment(deploymentDescriptorEnvironment);
            this.addComponent(deploymentUnit, beanDescription);
        }
        EjbDeploymentMarker.mark(deploymentUnit);
    }

    private String getMessageListenerInterface(CompositeIndex compositeIndex, AnnotationInstance messageBeanAnnotation) throws DeploymentUnitProcessingException {
        ClassInfo superClass;
        AnnotationValue value = messageBeanAnnotation.value("messageListenerInterface");
        if (value != null) {
            return value.asClass().name().toString();
        }
        ClassInfo beanClass = (ClassInfo)messageBeanAnnotation.target();
        HashSet<DotName> interfaces = new HashSet<DotName>(ViewInterfaces.getPotentialViewInterfaces(beanClass));
        DotName superClassDotName = beanClass.superName();
        while (interfaces.isEmpty() && superClassDotName != null && !superClassDotName.toString().equals(Object.class.getName()) && (superClass = compositeIndex.getClassByName(superClassDotName)) != null) {
            interfaces.addAll(ViewInterfaces.getPotentialViewInterfaces(superClass));
            superClassDotName = superClass.superName();
        }
        if (interfaces.size() != 1) {
            throw new DeploymentUnitProcessingException("EJB 3.1 FR 5.4.2 MessageDrivenBean " + beanClass + " does not implement 1 interface nor specifies message listener interface");
        }
        return ((DotName)interfaces.iterator().next()).toString();
    }

    private boolean assertMDBClassValidity(ClassInfo mdbClass) {
        short flags = mdbClass.flags();
        String className = mdbClass.name().toString();
        if (Modifier.isInterface(flags)) {
            logger.warn((Object)("[EJB3.1 spec, section 5.6.2] Message driven bean implementation class MUST NOT be a interface - " + className + " is an interface, hence won't be considered as a message driven bean"));
            return false;
        }
        if (!Modifier.isPublic(flags) || Modifier.isAbstract(flags) || Modifier.isFinal(flags)) {
            logger.warn((Object)("[EJB3.1 spec, section 5.6.2] Message driven bean implementation class MUST be public, not abstract and not final - " + className + " won't be considered as a message driven bean, since it doesn't meet that requirement"));
            return false;
        }
        return true;
    }

    private Properties getActivationConfigProperties(ActivationConfigMetaData activationConfig) {
        Properties activationConfigProps = new Properties();
        if (activationConfig == null || activationConfig.getActivationConfigProperties() == null) {
            return activationConfigProps;
        }
        ActivationConfigPropertiesMetaData activationConfigPropertiesMetaData = activationConfig.getActivationConfigProperties();
        for (ActivationConfigPropertyMetaData activationConfigProp : activationConfigPropertiesMetaData) {
            if (activationConfigProp == null) continue;
            String propName = activationConfigProp.getActivationConfigPropertyName();
            String propValue = activationConfigProp.getValue();
            if (propName == null) continue;
            activationConfigProps.put(propName, propValue);
        }
        return activationConfigProps;
    }

    private void processMessageDrivenBeanMetaData(DeploymentUnit deploymentUnit, MessageDrivenBeanMetaData mdb) throws DeploymentUnitProcessingException {
        EjbJarDescription ejbJarDescription = AbstractDeploymentUnitProcessor.getEjbJarDescription(deploymentUnit);
        String beanName = mdb.getName();
        String beanClassName = mdb.getEjbClass();
        String messageListenerInterface = mdb.getMessagingType();
        if (messageListenerInterface == null || messageListenerInterface.trim().isEmpty()) {
            messageListenerInterface = MessageListener.class.getName();
        }
        Properties activationConfigProps = this.getActivationConfigProperties(mdb.getActivationConfig());
        String defaultResourceAdapterName = this.getDefaultResourceAdapterName(deploymentUnit.getServiceRegistry());
        MessageDrivenComponentDescription mdbComponentDescription = new MessageDrivenComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName(), messageListenerInterface, activationConfigProps, defaultResourceAdapterName, mdb);
        mdbComponentDescription.setDeploymentDescriptorEnvironment(new DeploymentDescriptorEnvironment("java:comp/env/", (RemoteEnvironment)mdb));
        this.addComponent(deploymentUnit, mdbComponentDescription);
    }

    private Properties getActivationConfigProperties(AnnotationInstance messageBeanAnnotation) {
        Properties props = new Properties();
        AnnotationValue activationConfig = messageBeanAnnotation.value("activationConfig");
        if (activationConfig == null) {
            return props;
        }
        for (AnnotationInstance propAnnotation : activationConfig.asNestedArray()) {
            props.put(propAnnotation.value("propertyName").asString(), propAnnotation.value("propertyValue").asString());
        }
        return props;
    }

    private String getDefaultResourceAdapterName(ServiceRegistry serviceRegistry) {
        if (this.appclient) {
            return "n/a";
        }
        ServiceController serviceController = serviceRegistry.getRequiredService(DefaultResourceAdapterService.DEFAULT_RA_NAME_SERVICE_NAME);
        return ((DefaultResourceAdapterService)serviceController.getValue()).getDefaultResourceAdapterName();
    }
}

