/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.RemoveException;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class StatefulComponentInstanceInterceptor
extends AbstractEJBInterceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new StatefulComponentInstanceInterceptor());

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = StatefulComponentInstanceInterceptor.getComponent(context, StatefulSessionComponent.class);
        SessionID sessionId = (SessionID)context.getPrivateData(SessionID.class);
        if (sessionId == null) {
            throw EjbMessages.MESSAGES.statefulSessionIdIsNull(component.getComponentName());
        }
        EjbLogger.ROOT_LOGGER.debug("Looking for stateful component instance with session id: " + sessionId);
        StatefulSessionComponentInstance instance = component.getCache().get(sessionId);
        if (instance == null) {
            throw new NoSuchEJBException("Could not find SFSB " + component.getComponentName() + " with " + sessionId);
        }
        try {
            context.putPrivateData(ComponentInstance.class, (Object)instance);
            return context.proceed();
        }
        catch (Exception ex) {
            if (component.getApplicationException(ex.getClass(), context.getMethod()) != null) {
                throw ex;
            }
            if (ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
                throw ex;
            }
            if (!(ex instanceof RemoveException) && (ex instanceof RuntimeException || ex instanceof RemoteException)) {
                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EjbLogger.ROOT_LOGGER.trace("Removing bean " + sessionId + " because of exception", ex);
                }
                instance.discard();
            }
            throw ex;
        }
        catch (Error e) {
            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Removing bean " + sessionId + " because of error", e);
            }
            instance.discard();
            throw e;
        }
        catch (Throwable t) {
            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Removing bean " + sessionId + " because of Throwable", t);
            }
            instance.discard();
            throw new RuntimeException(t);
        }
    }

    static StatefulSessionComponentInstance getComponentInstance(InterceptorContext context) {
        return (StatefulSessionComponentInstance)context.getPrivateData(ComponentInstance.class);
    }
}

