/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.factory;

import java.io.Serializable;
import java.util.Set;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheFactoryService;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.impl.factory.GroupAwareCacheFactory;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreSource;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreSourceService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class GroupAwareCacheFactoryService<K extends Serializable, V extends Cacheable<K>>
extends CacheFactoryService<K, V> {
    private final InjectedValue<BackingCacheEntryStoreSource> storeSource = new InjectedValue();

    public GroupAwareCacheFactoryService(String name, Set<String> aliases) {
        super(name, aliases);
    }

    public ServiceBuilder<CacheFactory<K, V>> build(ServiceTarget target, String backingCache) {
        return super.build(target).addDependency(BackingCacheEntryStoreSourceService.getServiceName(backingCache), BackingCacheEntryStoreSource.class, this.storeSource);
    }

    @Override
    protected CacheFactory<K, V> createCacheFactory() {
        BackingCacheEntryStoreSource source = (BackingCacheEntryStoreSource)this.storeSource.getValue();
        return new GroupAwareCacheFactory(source);
    }
}

