/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.ejb.NoSuchEJBException;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryFactory;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.spi.BackingCacheLifecycleListener;
import org.jboss.as.ejb3.cache.spi.GroupCompatibilityChecker;
import org.jboss.as.ejb3.cache.spi.PassivatingBackingCache;
import org.jboss.as.ejb3.cache.spi.ReplicationPassivationManager;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCache;
import org.jboss.as.ejb3.cache.spi.impl.PassivateTask;
import org.jboss.as.ejb3.cache.spi.impl.RemoveTask;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.ejb.client.Affinity;
import org.jboss.logging.Logger;

public class PassivatingBackingCacheImpl<K extends Serializable, V extends Cacheable<K>, E extends BackingCacheEntry<K, V>>
extends AbstractBackingCache<K, V, E>
implements PassivatingBackingCache<K, V, E> {
    protected final Logger log = Logger.getLogger((String)this.getClass().getName());
    private final StatefulObjectFactory<V> factory;
    private final BackingCacheEntryFactory<K, V, E> entryFactory;
    private final ReplicationPassivationManager<K, E> passivationManager;
    private final BackingCacheEntryStore<K, V, E> store;
    private final ThreadFactory threadFactory;
    private volatile ScheduledExecutorService executor;
    private final Map<K, Future<?>> expirationFutures = new ConcurrentHashMap();
    private final Map<K, Future<?>> passivationFutures = new ConcurrentHashMap();
    private TaskFactory<K> removeTaskFactory = new TaskFactory<K>(){

        @Override
        public Runnable createTask(K id) {
            return new RemoveTask(PassivatingBackingCacheImpl.this, id);
        }
    };
    private TaskFactory<K> passivateTaskFactory = new TaskFactory<K>(){

        @Override
        public Runnable createTask(K id) {
            return new PassivateTask(PassivatingBackingCacheImpl.this, id);
        }
    };

    public PassivatingBackingCacheImpl(StatefulObjectFactory<V> factory, BackingCacheEntryFactory<K, V, E> entryFactory, ReplicationPassivationManager<K, E> passivationManager, BackingCacheEntryStore<K, V, E> store) {
        this(factory, entryFactory, passivationManager, store, null, null);
    }

    public PassivatingBackingCacheImpl(StatefulObjectFactory<V> factory, BackingCacheEntryFactory<K, V, E> entryFactory, ReplicationPassivationManager<K, E> passivationManager, BackingCacheEntryStore<K, V, E> store, ThreadFactory threadFactory) {
        this(factory, entryFactory, passivationManager, store, threadFactory, null);
    }

    public PassivatingBackingCacheImpl(StatefulObjectFactory<V> factory, BackingCacheEntryFactory<K, V, E> entryFactory, ReplicationPassivationManager<K, E> passivationManager, BackingCacheEntryStore<K, V, E> store, ScheduledExecutorService executor) {
        this(factory, entryFactory, passivationManager, store, null, executor);
    }

    private PassivatingBackingCacheImpl(StatefulObjectFactory<V> factory, BackingCacheEntryFactory<K, V, E> entryFactory, ReplicationPassivationManager<K, E> passivationManager, BackingCacheEntryStore<K, V, E> store, ThreadFactory threadFactory, ScheduledExecutorService executor) {
        this.factory = factory;
        this.entryFactory = entryFactory;
        this.passivationManager = passivationManager;
        this.store = store;
        this.threadFactory = threadFactory;
        this.executor = executor;
    }

    @Override
    public boolean isClustered() {
        return this.store.isClustered();
    }

    @Override
    public Affinity getStrictAffinity() {
        return this.store.getStrictAffinity();
    }

    @Override
    public Affinity getWeakAffinity(K key) {
        return this.store.getWeakAffinity(key);
    }

    @Override
    public boolean hasAffinity(K key) {
        return this.store.hasAffinity(key);
    }

    @Override
    public E create() {
        E obj = this.entryFactory.createEntry((Cacheable)this.factory.createInstance());
        Set<K> toPassivate = this.store.insert(obj);
        for (Serializable i : toPassivate) {
            try {
                this.passivate((K)i);
            }
            catch (Exception e) {
                EjbLogger.EJB3_LOGGER.debug("passivation failed", e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(K key) throws NoSuchEJBException {
        this.trace("get(%s)", key);
        boolean valid = false;
        boolean lock = true;
        while (!valid) {
            E entry = this.store.get(key, lock);
            lock = false;
            if (entry == null) {
                return null;
            }
            entry.lock();
            try {
                valid = entry.isValid();
                if (!valid) continue;
                if (this.isClustered()) {
                    this.passivationManager.postReplicate(entry);
                }
                this.passivationManager.postActivate(entry);
                entry.setPrePassivated(false);
                entry.setInUse(true);
                this.cancelExpirationPassivation(key);
                E e = entry;
                return e;
            }
            finally {
                entry.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passivate(K key) {
        this.trace("passivate(%s)", key);
        E entry = this.store.get(key, false);
        if (entry == null) {
            EjbLogger.ROOT_LOGGER.cacheEntryNotFound(key);
            return;
        }
        if (!entry.tryLock()) {
            throw EjbMessages.MESSAGES.cacheEntryInUse(entry);
        }
        try {
            if (entry.isInUse()) {
                throw EjbMessages.MESSAGES.cacheEntryInUse(entry);
            }
            this.passivationManager.prePassivate(entry);
            entry.setPrePassivated(true);
            entry.invalidate();
            this.store.passivate(entry);
        }
        finally {
            entry.unlock();
        }
    }

    @Override
    public E peek(K key) throws NoSuchEJBException {
        this.trace("peek(%s)", key);
        return this.store.get(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E release(K key) {
        this.trace("release(%s)", key);
        E entry = this.store.get(key, false);
        if (entry == null) {
            EjbLogger.ROOT_LOGGER.cacheEntryNotFound(key);
            return null;
        }
        entry.lock();
        try {
            entry.setInUse(false);
            boolean modified = entry.isModified();
            if (modified && this.isClustered()) {
                this.passivationManager.preReplicate(entry);
            }
            this.store.update(entry, modified);
            this.scheduleExpirationPassivation(key);
            E e = entry;
            return e;
        }
        finally {
            entry.unlock();
        }
    }

    @Override
    public void discard(K key) {
        this.store.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        this.trace("remove(%s)", key);
        this.cancelExpirationPassivation(key);
        E entry = this.store.remove(key);
        if (entry == null) {
            throw new NoSuchEJBException(String.valueOf(key));
        }
        entry.lock();
        try {
            if (entry.isInUse()) {
                entry.setInUse(false);
            }
            this.entryFactory.destroyEntry(entry);
            this.factory.destroyInstance(entry.getUnderlyingItem());
        }
        finally {
            entry.unlock();
        }
    }

    private void cancelExpirationPassivation(K id) {
        if (this.executor != null) {
            if (this.store.getTimeout() != null) {
                this.cancel(this.expirationFutures, id);
            }
            this.cancel(this.passivationFutures, id);
        }
    }

    private void cancel(Map<K, Future<?>> futures, K id) {
        Future<?> future = futures.remove(id);
        if (future != null) {
            future.cancel(false);
        }
    }

    private void scheduleExpirationPassivation(K id) {
        if (this.executor != null) {
            StatefulTimeoutInfo timeout = this.store.getTimeout();
            if (timeout != null && timeout.getValue() != -1L) {
                this.schedule(this.expirationFutures, id, this.removeTaskFactory, timeout.getValue(), timeout.getTimeUnit());
            }
            BackingCacheEntryStoreConfig config = this.store.getConfig();
            this.schedule(this.passivationFutures, id, this.passivateTaskFactory, config.getIdleTimeout(), config.getIdleTimeoutUnit());
        }
    }

    private void schedule(Map<K, Future<?>> futures, K id, TaskFactory<K> factory, long time, TimeUnit unit) {
        Future future = futures.put(id, this.executor.schedule(factory.createTask(id), time, unit));
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public void start() {
        this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.STARTING);
        try {
            this.store.start();
            if (this.threadFactory != null) {
                this.executor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
            }
            this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.STARTED);
        }
        catch (RuntimeException e) {
            this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.FAILED);
            throw e;
        }
    }

    @Override
    public void stop() {
        this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.STOPPING);
        try {
            this.store.stop();
            if (this.threadFactory != null) {
                this.executor.shutdownNow();
            }
            this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.STOPPED);
        }
        catch (RuntimeException e) {
            this.notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState.FAILED);
            throw e;
        }
    }

    @Override
    public GroupCompatibilityChecker getCompatibilityChecker() {
        return this.store;
    }

    private void trace(String pattern, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.tracef(pattern, args);
        }
    }

    static interface TaskFactory<K> {
        public Runnable createTask(K var1);
    }
}

