/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class ModifiableAdminObject
implements CommonAdminObject {
    private static final long serialVersionUID = 8137442556861441967L;
    private final HashMap<String, String> configProperties;
    private final String className;
    private final String jndiName;
    private final String poolName;
    private final Boolean enabled;
    private final Boolean useJavaContext;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public ModifiableAdminObject(Map<String, String> configProperties, String className, String jndiName, String poolName, Boolean enabled, Boolean useJavaContext) throws ValidateException {
        if (configProperties != null) {
            this.configProperties = new HashMap(configProperties.size());
            this.configProperties.putAll(configProperties);
        } else {
            this.configProperties = new HashMap(0);
        }
        this.className = className;
        this.jndiName = jndiName;
        this.poolName = poolName;
        this.enabled = enabled;
        this.useJavaContext = useJavaContext;
    }

    public final Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    public String addConfigProperty(String key, String value) {
        return this.configProperties.put(key, value);
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getJndiName() {
        return this.jndiName;
    }

    public final Boolean isEnabled() {
        return this.enabled;
    }

    public final Boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.poolName == null ? 0 : this.poolName.hashCode());
        result = 31 * result + (this.useJavaContext == null ? 0 : this.useJavaContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifiableAdminObject)) {
            return false;
        }
        ModifiableAdminObject other = (ModifiableAdminObject)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        if (this.poolName == null ? other.poolName != null : !this.poolName.equals(other.poolName)) {
            return false;
        }
        return !(this.useJavaContext == null ? other.useJavaContext != null : !this.useJavaContext.equals(other.useJavaContext));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<admin-object");
        if (this.className != null) {
            sb.append(" ").append(CommonAdminObject.Attribute.CLASS_NAME).append("=\"").append(this.className).append("\"");
        }
        if (this.jndiName != null) {
            sb.append(" ").append(CommonAdminObject.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append(CommonAdminObject.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append(CommonAdminObject.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append(CommonAdminObject.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        sb.append(">");
        if (this.configProperties != null && this.configProperties.size() > 0) {
            for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
                sb.append("<").append(CommonAdminObject.Tag.CONFIG_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append(CommonAdminObject.Tag.CONFIG_PROPERTY).append(">");
            }
        }
        sb.append("</admin-object>");
        return sb.toString();
    }

    public final String getPoolName() {
        return this.poolName;
    }
}

