/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jboss.as.appclient.deployment.ActiveApplicationClientProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientDependencyProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientDescriptorMethodProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientManifestProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientParsingDeploymentProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientStartProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientStructureProcessor;
import org.jboss.as.appclient.service.ApplicationClientDeploymentService;
import org.jboss.as.appclient.subsystem.AppClientSubsystemDescriptions;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;

class AppClientSubsystemAdd
extends AbstractBoottimeAddStepHandler
implements DescriptionProvider {
    static final AppClientSubsystemAdd INSTANCE = new AppClientSubsystemAdd();
    private final String[] EMPTY_STRING = new String[0];

    private AppClientSubsystemAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        return AppClientSubsystemDescriptions.getSubystemAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("file").set(operation.get("file"));
        model.get("deployment").set(operation.get("deployment"));
        model.get("parameters").set(operation.get("parameters"));
        if (operation.hasDefined("host-url")) {
            model.get("host-url").set(operation.get("host-url"));
        }
        if (operation.hasDefined("connection-properties-url")) {
            model.get("connection-properties-url").set(operation.get("connection-properties-url"));
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        final String deployment = model.get("deployment").asString();
        File file = new File(model.get("file").asString());
        final String hostUrl = model.hasDefined("host-url") ? model.get("host-url").asString() : null;
        final String connectionPropertiesUrl = model.hasDefined("connection-properties-url") ? model.get("connection-properties-url").asString() : null;
        final ArrayList<String> parameters = new ArrayList<String>();
        for (ModelNode param : model.get("parameters").asList()) {
            parameters.add(param.asString());
        }
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                if (deployment != null && !deployment.isEmpty()) {
                    processorTarget.addDeploymentProcessor(Phase.STRUCTURE, 3840, (DeploymentUnitProcessor)new ApplicationClientStructureProcessor(deployment));
                }
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4353, (DeploymentUnitProcessor)new ApplicationClientParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 7936, (DeploymentUnitProcessor)new ApplicationClientManifestProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 8192, (DeploymentUnitProcessor)new ActiveApplicationClientProcessor(deployment));
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 8224, (DeploymentUnitProcessor)new ApplicationClientDescriptorMethodProcessor());
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 8192, (DeploymentUnitProcessor)new ApplicationClientDependencyProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 8192, (DeploymentUnitProcessor)new ApplicationClientStartProcessor(hostUrl, connectionPropertiesUrl, parameters.toArray(AppClientSubsystemAdd.this.EMPTY_STRING)));
            }
        }, OperationContext.Stage.RUNTIME);
        ApplicationClientDeploymentService service = new ApplicationClientDeploymentService(file);
        newControllers.add(context.getServiceTarget().addService(ApplicationClientDeploymentService.SERVICE_NAME, (Service)service).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.getControllerValue()).install());
    }
}

