/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.impl.CoreGroupCommunicationService;
import org.jboss.as.clustering.infinispan.atomic.AtomicMapCache;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.lock.impl.SharedLocalYieldingClusterLockManagerService;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryService;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.ClusteringNotSupportedException;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionAttributeMarshallerFactory;
import org.jboss.as.clustering.web.impl.SessionAttributeMarshallerFactoryImpl;
import org.jboss.as.clustering.web.impl.TransactionBatchingManager;
import org.jboss.as.clustering.web.infinispan.DistributedCacheManager;
import org.jboss.as.clustering.web.infinispan.InfinispanWebMessages;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactory;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactoryImpl;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class DistributedCacheManagerFactory
implements org.jboss.as.clustering.web.DistributedCacheManagerFactory {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    public static final Short SCOPE_ID = 222;
    private final JvmRouteRegistryEntryProvider registryEntryProvider = new JvmRouteRegistryEntryProvider();
    private SessionAttributeStorageFactory storageFactory = new SessionAttributeStorageFactoryImpl();
    private CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});
    private SessionAttributeMarshallerFactory marshallerFactory = new SessionAttributeMarshallerFactoryImpl();
    private final InjectedValue<Registry> registry = new InjectedValue();
    private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
    private final InjectedValue<Configuration> config = new InjectedValue();
    private final InjectedValue<SharedLocalYieldingClusterLockManager> lockManager = new InjectedValue();

    public <T extends OutgoingDistributableSessionData> org.jboss.as.clustering.web.DistributedCacheManager<T> getDistributedCacheManager(LocalDistributableSessionManager manager) throws ClusteringNotSupportedException {
        this.registryEntryProvider.setManager(manager);
        EmbeddedCacheManager container = (EmbeddedCacheManager)this.container.getValue();
        Registry jvmRouteRegistry = (Registry)this.registry.getValue();
        Configuration config = (Configuration)this.config.getValue();
        if (!config.invocationBatching().enabled()) {
            ServiceName cacheServiceName = this.getCacheServiceName(manager.getReplicationConfig());
            throw new ClusteringNotSupportedException(InfinispanWebMessages.MESSAGES.failedToConfigureWebApp(cacheServiceName.getParent().getSimpleName(), cacheServiceName.getSimpleName()));
        }
        String name = manager.getName();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(config);
        builder.storeAsBinary().enable().storeKeysAsBinary(false).storeValuesAsBinary(true);
        container.defineConfiguration(name, builder.build());
        AdvancedCache sessionCache = container.getCache(name).getAdvancedCache().with(this.getClass().getClassLoader());
        TransactionBatchingManager batchingManager = new TransactionBatchingManager(sessionCache.getTransactionManager());
        SessionAttributeStorage storage = this.storageFactory.createStorage(manager.getReplicationConfig().getReplicationGranularity(), this.marshallerFactory.createMarshaller(manager));
        return new DistributedCacheManager(manager, (Cache<String, Map<Object, Object>>)new AtomicMapCache(sessionCache), (Registry<String, Void>)jvmRouteRegistry, (SharedLocalYieldingClusterLockManager)this.lockManager.getOptionalValue(), storage, (BatchingManager)batchingManager, this.invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDependencies(ServiceRegistry registry, ServiceTarget target, ServiceBuilder<?> builder, JBossWebMetaData metaData) {
        ServiceName cacheServiceName = this.getCacheServiceName(metaData.getReplicationConfig());
        if (registry.getService(cacheServiceName) == null) {
            return false;
        }
        ServiceName containerServiceName = cacheServiceName.getParent();
        String container = containerServiceName.getSimpleName();
        ServiceName lockManagerServiceName = SharedLocalYieldingClusterLockManagerService.getServiceName((String)container);
        ServiceName registryServiceName = cacheServiceName.append(new String[]{"registry"});
        DistributedCacheManagerFactory distributedCacheManagerFactory = this;
        synchronized (distributedCacheManagerFactory) {
            if (registry.getService(lockManagerServiceName) == null) {
                new CoreGroupCommunicationService(SCOPE_ID.shortValue()).build(target, container).addDependency(cacheServiceName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                new SharedLocalYieldingClusterLockManagerService(container).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            }
            if (registry.getService(registryServiceName) == null) {
                new RegistryService((Registry.RegistryEntryProvider)this.registryEntryProvider).build(target, registryServiceName, cacheServiceName).install();
            }
        }
        builder.addDependency(containerServiceName, EmbeddedCacheManager.class, this.container);
        builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)cacheServiceName.getSimpleName()), Configuration.class, this.config);
        builder.addDependency(registryServiceName, Registry.class, this.registry);
        builder.addDependency(SharedLocalYieldingClusterLockManagerService.getServiceName((String)container), SharedLocalYieldingClusterLockManager.class, this.lockManager);
        return true;
    }

    private ServiceName getCacheServiceName(ReplicationConfig config) {
        String cacheName;
        ServiceName serviceName;
        ServiceName baseServiceName = EmbeddedCacheManagerService.getServiceName(null);
        if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)((cacheName = config != null ? config.getCacheName() : null) != null ? cacheName : DEFAULT_CACHE_CONTAINER)))) {
            serviceName = baseServiceName.append(serviceName);
        }
        return serviceName.length() < 4 ? serviceName.append(new String[]{"___defaultcache"}) : serviceName;
    }

    public Injector<EmbeddedCacheManager> getCacheContainerInjector() {
        return this.container;
    }

    public Injector<Configuration> getCacheConfigurationInjector() {
        return this.config;
    }

    public Injector<Registry> getRegistryInjector() {
        return this.registry;
    }

    public Injector<SharedLocalYieldingClusterLockManager> getLockManagerInjector() {
        return this.lockManager;
    }

    public void setSessionAttributeMarshallerFactory(SessionAttributeMarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    public void setSessionAttributeStorageFactory(SessionAttributeStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    public void setCacheInvoker(CacheInvoker invoker) {
        this.invoker = invoker;
    }

    class JvmRouteRegistryEntryProvider
    implements Registry.RegistryEntryProvider<String, Void> {
        private volatile LocalDistributableSessionManager manager;

        JvmRouteRegistryEntryProvider() {
        }

        void setManager(LocalDistributableSessionManager manager) {
            this.manager = manager;
        }

        public String getKey() {
            return this.manager != null ? this.manager.getJvmRoute() : null;
        }

        public Void getValue() {
            return null;
        }
    }
}

