/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.invoker;

import org.infinispan.Cache;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.TimeoutException;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;

public class RetryingCacheInvoker
implements CacheInvoker {
    private final int[] backOffIntervals;

    public RetryingCacheInvoker(int ... backOffIntervals) {
        this.backOffIntervals = backOffIntervals;
    }

    @Override
    public <K, V, R> R invoke(Cache<K, V> cache, CacheInvoker.Operation<K, V, R> operation) {
        Throwable exception = null;
        for (int i = 0; i <= this.backOffIntervals.length; ++i) {
            try {
                return operation.invoke(cache);
            }
            catch (TimeoutException e) {
                exception = e;
            }
            catch (SuspectException e) {
                exception = e;
            }
            if (i >= this.backOffIntervals.length) continue;
            int delay = this.backOffIntervals[i];
            try {
                if (InfinispanLogger.ROOT_LOGGER.isTraceEnabled()) {
                    InfinispanLogger.ROOT_LOGGER.tracef(exception, "Cache operation failed.  Retrying in %d ms", delay);
                }
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw InfinispanMessages.MESSAGES.abortingCacheOperation(exception, this.backOffIntervals.length + 1);
    }
}

