/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem.validators;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jboss.as.clustering.jgroups.subsystem.Protocol;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ProtocolTypeValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final EnumSet<Protocol> allowedValues = EnumSet.allOf(Protocol.class);
    private final List<ModelNode> nodeValues = new ArrayList<ModelNode>(this.allowedValues.size());

    public ProtocolTypeValidator(boolean nullable) {
        super(ModelType.STRING, nullable, false);
        for (Protocol protocol : this.allowedValues) {
            this.nodeValues.add(new ModelNode().set(protocol.toString()));
        }
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        Protocol protocol;
        System.out.println("parameter name = " + parameterName + ", value = " + value);
        super.validateParameter(parameterName, value);
        if (value.isDefined() && ((protocol = Protocol.valueOf(value.asString())) == null || !this.allowedValues.contains((Object)protocol))) {
            throw new OperationFailedException(new ModelNode().set("invalid value for " + (Object)((Object)protocol)));
        }
    }

    public List<ModelNode> getAllowedValues() {
        return this.nodeValues;
    }
}

