/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process.protocol;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.net.ConnectException;
import java.net.URI;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;

@MessageBundle(projectCode="JBAS")
public interface ProtocolMessages {
    public static final ProtocolMessages MESSAGES = (ProtocolMessages)Messages.getBundle(ProtocolMessages.class);

    @Message(value="Already connected")
    public IllegalStateException alreadyConnected();

    @Message(value="Channel and receiver already started")
    public IllegalStateException alreadyStarted();

    @Message(value="Can't use both a connect timeout and a connect timeout property")
    public IllegalArgumentException cannotSpecifyMultipleTimeouts();

    @Message(value="Can't set uriScheme with specified endpoint")
    public IllegalArgumentException cannotSetUriScheme();

    @Message(value="Could not connect to %s in %sms. Make sure the server is running and/or consider setting a longer timeout by setting -D%s=<timeout in ms>.")
    public ConnectException couldNotConnect(URI var1, long var2, String var4);

    @Message(value="Could not connect to remote server at %1$s within %1$sms")
    public ConnectException couldNotConnect(long var1);

    @Message(value="Need an executor when endpoint is not specified")
    public IllegalArgumentException executorNeeded();

    @Message(value="Don't need an executor when specified endpoint")
    public IllegalArgumentException executorUnneeded();

    @Message(value="Failed to create server thread")
    public IOException failedToCreateServerThread();

    @Message(value="Failed to read object")
    public IOException failedToReadObject(@Cause Throwable var1);

    @Message(value="Failed to write management response headers")
    public IOException failedToWriteManagementResponseHeaders(@Cause Throwable var1);

    @Message(value="Invalid byte")
    public UTFDataFormatException invalidByte();

    @Message(value="Invalid byte:%s(%d)")
    public UTFDataFormatException invalidByte(char var1, int var2);

    @Message(value="Invalid byte token.  Expecting '%s' received '%s'")
    public IOException invalidByteToken(int var1, byte var2);

    @Message(value="Invalid command byte read: %s")
    public IOException invalidCommandByte(int var1);

    @Message(value="Invalid signature [%s]")
    public IOException invalidSignature(String var1);

    @Message(value="Invalid start chunk start [%s]")
    public IOException invalidStartChunk(int var1);

    @Message(value="Invalid type: %s")
    public IOException invalidType(String var1);

    @Message(value="Type is neither %s or %s: %s")
    public IllegalArgumentException invalidType(String var1, String var2, byte var3);

    @Message(value="Only '%s' is a valid url")
    public IllegalArgumentException invalidUrl(String var1);

    @Message(value="No operation handler set")
    public IOException operationHandlerNotSet();

    @Message(value="Not connected")
    public IllegalStateException notConnected();

    @Message(value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(value="%s and %s are null")
    public IllegalArgumentException nullParameters(String var1, String var2);

    @Message(value="Read %d bytes.")
    public EOFException readBytes(int var1);

    @Message(value="Response handler already registered for request")
    public IOException responseHandlerAlreadyRegistered();

    @Message(value="No response handler for request %s")
    public IOException responseHandlerNotFound(int var1);

    @Message(value="A problem happened executing on the server: %s")
    public IOException serverError(String var1);

    @Message(value="Stream closed")
    public IOException streamClosed();

    @Message(value="Thread creation was refused")
    public IllegalStateException threadCreationRefused();

    @Message(value="Unexpected end of stream")
    public EOFException unexpectedEndOfStream();

    @Message(value="Scheme %s does not match uri %s")
    public IllegalArgumentException unmatchedScheme(String var1, URI var2);

    @Message(value="Write channel closed")
    public IOException writeChannelClosed();

    @Message(value="Writes are already shut down")
    public IOException writesAlreadyShutdown();
}

