/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.util.concurrent.TimeUnit;
import org.jboss.as.process.ManagedProcess;
import org.jboss.as.process.ProcessLogger;

interface RespawnPolicy {
    public static final RespawnPolicy NONE = new RespawnPolicy(){

        @Override
        public void respawn(int count, ManagedProcess process) {
            ProcessLogger.SERVER_LOGGER.tracef("not trying to respawn process %s.", process.getProcessName());
        }
    };
    public static final RespawnPolicy RESPAWN = new RespawnPolicy(){
        private static final int MAX_WAIT = 60;
        private static final int MAX_RESTARTS = 10;

        @Override
        public void respawn(int count, ManagedProcess process) {
            if (count <= 10) {
                try {
                    int waitPeriod = Math.min(count * count, 60);
                    ProcessLogger.SERVER_LOGGER.waitingToRestart(waitPeriod, process.getProcessName());
                    TimeUnit.SECONDS.sleep(waitPeriod);
                }
                catch (InterruptedException e) {
                    return;
                }
                process.respawn();
            }
        }
    };

    public void respawn(int var1, ManagedProcess var2);
}

