/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class OperationValidator {
    private final ImmutableManagementResourceRegistration root;
    private final boolean validateDescriptions;
    private final boolean includeOperationInError;

    public OperationValidator(ImmutableManagementResourceRegistration root) {
        this(root, true, true);
    }

    public OperationValidator(ImmutableManagementResourceRegistration root, boolean validateDescriptions, boolean includeOperationInError) {
        this.root = root;
        this.validateDescriptions = validateDescriptions;
        this.includeOperationInError = includeOperationInError;
    }

    public void validateOperations(List<ModelNode> operations) {
        if (operations == null) {
            return;
        }
        for (ModelNode operation : operations) {
            this.validateOperation(operation);
        }
    }

    public void validateOperation(ModelNode operation) {
        if (operation == null) {
            return;
        }
        DescriptionProvider provider = this.getDescriptionProvider(operation);
        ModelNode description = provider.getModelDescription(null);
        Map<String, ModelNode> describedProperties = this.getDescribedRequestProperties(operation, description);
        Map<String, ModelNode> actualParams = this.getActualRequestProperties(operation);
        this.checkActualOperationParamsAreDescribed(description, operation, describedProperties, actualParams);
        this.checkAllRequiredPropertiesArePresent(description, operation, describedProperties, actualParams);
        this.checkParameterTypes(description, operation, describedProperties, actualParams);
    }

    private Map<String, ModelNode> getDescribedRequestProperties(ModelNode operation, ModelNode description) {
        HashMap<String, ModelNode> requestProperties = new HashMap<String, ModelNode>();
        if (description.hasDefined("request-properties")) {
            for (String key : description.get("request-properties").keys()) {
                ModelNode desc = description.get(new String[]{"request-properties", key});
                if (!desc.isDefined()) {
                    this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionUndefinedRequestProperty(key, this.getPathAddress(operation), desc));
                }
                requestProperties.put(key, desc);
            }
        }
        return requestProperties;
    }

    private Map<String, ModelNode> getActualRequestProperties(ModelNode operation) {
        HashMap<String, ModelNode> requestProperties = new HashMap<String, ModelNode>();
        for (String key : operation.keys()) {
            if (key.equals("operation") || key.equals("address") || key.equals("operation-headers")) continue;
            requestProperties.put(key, operation.get(key));
        }
        return requestProperties;
    }

    private void checkActualOperationParamsAreDescribed(ModelNode description, ModelNode operation, Map<String, ModelNode> describedProperties, Map<String, ModelNode> actualParams) {
        for (String paramName : actualParams.keySet()) {
            ModelNode param = actualParams.get(paramName);
            if (!param.isDefined()) continue;
            if (param.getType() == ModelType.OBJECT && param.keys().isEmpty()) {
                return;
            }
            if (describedProperties.containsKey(paramName)) continue;
            throw ControllerMessages.MESSAGES.validationFailedActualParameterNotDescribed(paramName, describedProperties.keySet(), this.formatOperationForMessage(operation));
        }
    }

    private void checkAllRequiredPropertiesArePresent(ModelNode description, ModelNode operation, Map<String, ModelNode> describedProperties, Map<String, ModelNode> actualParams) {
        for (String paramName : describedProperties.keySet()) {
            boolean required;
            ModelNode described = describedProperties.get(paramName);
            if (described.hasDefined("required")) {
                if (ModelType.BOOLEAN != described.get("required").getType()) {
                    this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionRequiredFlagIsNotABoolean(paramName, this.getPathAddress(operation), description));
                    required = false;
                } else {
                    required = described.get("required").asBoolean();
                }
            } else {
                required = true;
            }
            List alternatives = null;
            if (described.hasDefined("alternatives")) {
                alternatives = described.get("alternatives").asList();
            }
            boolean exist = actualParams.containsKey(paramName);
            String alternative = this.hasAlternative(actualParams.keySet(), alternatives);
            if (required && !exist && alternative == null) {
                throw ControllerMessages.MESSAGES.validationFailedRequiredParameterNotPresent(paramName, this.formatOperationForMessage(operation));
            }
            if (!exist || alternative == null) continue;
            throw ControllerMessages.MESSAGES.validationFailedRequiredParameterPresentAsWellAsAlternative(alternative, paramName, this.formatOperationForMessage(operation));
        }
    }

    private void checkParameterTypes(ModelNode description, ModelNode operation, Map<String, ModelNode> describedProperties, Map<String, ModelNode> actualParams) {
        for (String paramName : actualParams.keySet()) {
            ModelType modelType;
            ModelNode value = actualParams.get(paramName);
            if (!value.isDefined()) continue;
            if (value.getType() == ModelType.OBJECT && value.keys().isEmpty()) {
                return;
            }
            ModelNode typeNode = describedProperties.get(paramName).get("type");
            if (!typeNode.isDefined()) {
                this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionNoParamTypeInDescription(paramName, this.getPathAddress(operation), description));
                return;
            }
            try {
                modelType = Enum.valueOf(ModelType.class, typeNode.asString());
            }
            catch (Exception e) {
                this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionInvalidParamTypeInDescription(paramName, this.getPathAddress(operation), description));
                return;
            }
            try {
                this.checkType(modelType, value);
            }
            catch (IllegalArgumentException e) {
                throw ControllerMessages.MESSAGES.validationFailedCouldNotConvertParamToType(paramName, modelType, this.formatOperationForMessage(operation));
            }
            this.checkRange(operation, description, paramName, modelType, describedProperties.get(paramName), value);
            this.checkList(operation, paramName, modelType, describedProperties.get(paramName), value);
        }
    }

    private void checkRange(ModelNode operation, ModelNode description, String paramName, ModelType modelType, ModelNode describedProperty, ModelNode value) {
        if (!value.isDefined()) {
            return;
        }
        if (describedProperty.hasDefined("min")) {
            switch (modelType) {
                case BIG_DECIMAL: {
                    BigDecimal min;
                    try {
                        min = describedProperty.get("min").asBigDecimal();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("min", paramName, ModelType.BIG_DECIMAL, this.getPathAddress(operation), description));
                        return;
                    }
                    if (value.asBigDecimal().compareTo(min) != -1) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsSmallerThanMin(value.asBigDecimal(), paramName, min, this.formatOperationForMessage(operation));
                }
                case BIG_INTEGER: {
                    BigInteger min;
                    try {
                        min = describedProperty.get("min").asBigInteger();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("min", paramName, ModelType.BIG_INTEGER, this.getPathAddress(operation), description));
                        return;
                    }
                    if (value.asBigInteger().compareTo(min) != -1) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsSmallerThanMin(value.asBigInteger(), paramName, min, this.formatOperationForMessage(operation));
                }
                case DOUBLE: {
                    double min;
                    try {
                        min = describedProperty.get("min").asDouble();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("min", paramName, ModelType.DOUBLE, this.getPathAddress(operation), description));
                        return;
                    }
                    if (!(value.asDouble() < min)) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsSmallerThanMin(value.asDouble(), paramName, min, this.formatOperationForMessage(operation));
                }
                case INT: {
                    int min;
                    try {
                        min = describedProperty.get("min").asInt();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("min", paramName, ModelType.INT, this.getPathAddress(operation), description));
                        return;
                    }
                    if (value.asInt() >= min) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsSmallerThanMin(value.asInt(), paramName, min, this.formatOperationForMessage(operation));
                }
                case LONG: {
                    long min;
                    try {
                        min = describedProperty.get("min").asLong();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("min", paramName, ModelType.LONG, this.getPathAddress(operation), description));
                        return;
                    }
                    if (value.asLong() >= describedProperty.get("min").asLong()) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsSmallerThanMin(value.asLong(), paramName, min, this.formatOperationForMessage(operation));
                }
            }
        }
        if (describedProperty.hasDefined("max")) {
            switch (modelType) {
                case BIG_DECIMAL: {
                    BigDecimal max;
                    try {
                        max = describedProperty.get("max").asBigDecimal();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("max", paramName, ModelType.BIG_DECIMAL, this.getPathAddress(operation), description));
                        return;
                    }
                    if (value.asBigDecimal().compareTo(max) != 1) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsGreaterThanMax(value.asBigDecimal(), paramName, max, this.formatOperationForMessage(operation));
                }
                case BIG_INTEGER: {
                    BigInteger max;
                    try {
                        max = describedProperty.get("max").asBigInteger();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("max", paramName, ModelType.BIG_INTEGER, this.getPathAddress(operation), description));
                        return;
                    }
                    if (value.asBigInteger().compareTo(max) != 1) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsGreaterThanMax(value.asBigInteger(), paramName, max, this.formatOperationForMessage(operation));
                }
                case DOUBLE: {
                    double max;
                    try {
                        max = describedProperty.get("max").asDouble();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("max", paramName, ModelType.DOUBLE, this.getPathAddress(operation), description));
                        return;
                    }
                    if (!(value.asDouble() > max)) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsGreaterThanMax(value.asDouble(), paramName, max, this.formatOperationForMessage(operation));
                }
                case INT: {
                    int max;
                    try {
                        max = describedProperty.get("max").asInt();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("max", paramName, ModelType.INT, this.getPathAddress(operation), description));
                        return;
                    }
                    if (value.asInt() <= max) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsGreaterThanMax(value.asInt(), paramName, max, this.formatOperationForMessage(operation));
                }
                case LONG: {
                    Long max;
                    try {
                        max = describedProperty.get("max").asLong();
                    }
                    catch (IllegalArgumentException e) {
                        this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxForParameterHasWrongType("max", paramName, ModelType.LONG, this.getPathAddress(operation), description));
                        return;
                    }
                    if (value.asLong() <= describedProperty.get("max").asLong()) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsGreaterThanMax(value.asLong(), paramName, max, this.formatOperationForMessage(operation));
                }
            }
        }
        if (describedProperty.hasDefined("min-length")) {
            int minLength;
            try {
                minLength = describedProperty.get("min-length").asInt();
            }
            catch (IllegalArgumentException e) {
                this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxLengthForParameterHasWrongType("min-length", paramName, this.getPathAddress(operation), description));
                return;
            }
            switch (modelType) {
                case LIST: {
                    if (value.asList().size() >= minLength) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsShorterThanMinLength(value.asList().size(), paramName, minLength, this.formatOperationForMessage(operation));
                }
                case BYTES: {
                    if (value.asBytes().length >= minLength) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsShorterThanMinLength(value.asBytes().length, paramName, minLength, this.formatOperationForMessage(operation));
                }
                case STRING: {
                    if (value.asString().length() >= minLength) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsShorterThanMinLength(value.asString().length(), paramName, minLength, this.formatOperationForMessage(operation));
                }
            }
        }
        if (describedProperty.hasDefined("max-length")) {
            int maxLength;
            try {
                maxLength = describedProperty.get("max-length").asInt();
            }
            catch (IllegalArgumentException e) {
                this.throwOrWarnAboutDescriptorProblem(ControllerMessages.MESSAGES.invalidDescriptionMinMaxLengthForParameterHasWrongType("max-length", paramName, this.getPathAddress(operation), description));
                return;
            }
            switch (modelType) {
                case LIST: {
                    if (value.asList().size() <= maxLength) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsLongerThanMaxLength(value.asList().size(), paramName, maxLength, this.formatOperationForMessage(operation));
                }
                case BYTES: {
                    if (value.asBytes().length <= maxLength) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsLongerThanMaxLength(value.asBytes().length, paramName, maxLength, this.formatOperationForMessage(operation));
                }
                case STRING: {
                    if (value.asString().length() <= maxLength) break;
                    throw ControllerMessages.MESSAGES.validationFailedValueIsLongerThanMaxLength(value.asString().length(), paramName, maxLength, this.formatOperationForMessage(operation));
                }
            }
        }
    }

    private void checkType(ModelType modelType, ModelNode value) {
        switch (modelType) {
            case BIG_DECIMAL: {
                value.asBigDecimal();
                break;
            }
            case BIG_INTEGER: {
                value.asBigInteger();
                break;
            }
            case BOOLEAN: {
                value.asBoolean();
                break;
            }
            case BYTES: {
                value.asBytes();
                break;
            }
            case DOUBLE: {
                value.asDouble();
                break;
            }
            case EXPRESSION: {
                value.asString();
                break;
            }
            case INT: {
                value.asInt();
                break;
            }
            case LIST: {
                value.asList();
                break;
            }
            case LONG: {
                value.asLong();
                break;
            }
            case OBJECT: {
                value.asObject();
                break;
            }
            case PROPERTY: {
                value.asProperty();
                break;
            }
            case STRING: {
                value.asString();
                break;
            }
            case TYPE: {
                value.asType();
            }
        }
    }

    private void checkList(ModelNode operation, String paramName, ModelType modelType, ModelNode describedProperty, ModelNode value) {
        if (describedProperty.get("type").asType() == ModelType.LIST && describedProperty.hasDefined("value-type") && describedProperty.get("value-type").getType() == ModelType.TYPE) {
            ModelType elementType = describedProperty.get("value-type").asType();
            for (ModelNode element : value.asList()) {
                try {
                    this.checkType(elementType, element);
                }
                catch (IllegalArgumentException e) {
                    throw ControllerMessages.MESSAGES.validationFailedInvalidElementType(paramName, elementType, this.formatOperationForMessage(operation));
                }
            }
        }
    }

    private DescriptionProvider getDescriptionProvider(ModelNode operation) {
        if (!operation.hasDefined("operation")) {
            throw ControllerMessages.MESSAGES.validationFailedOperationHasNoField("operation", this.formatOperationForMessage(operation));
        }
        if (!operation.hasDefined("address")) {
            throw ControllerMessages.MESSAGES.validationFailedOperationHasNoField("address", this.formatOperationForMessage(operation));
        }
        String name = operation.get("operation").asString();
        if (name == null || name.trim().length() == 0) {
            throw ControllerMessages.MESSAGES.validationFailedOperationHasANullOrEmptyName(this.formatOperationForMessage(operation));
        }
        PathAddress addr = this.getPathAddress(operation);
        DescriptionProvider provider = this.root.getOperationDescription(addr, name);
        if (provider == null) {
            throw ControllerMessages.MESSAGES.validationFailedNoOperationFound(name, addr, this.formatOperationForMessage(operation));
        }
        return provider;
    }

    private String hasAlternative(Set<String> keys, Collection<ModelNode> alternatives) {
        if (alternatives == null || alternatives.isEmpty()) {
            return null;
        }
        for (ModelNode alternative : alternatives) {
            if (!keys.contains(alternative.asString())) continue;
            return alternative.asString();
        }
        return null;
    }

    private PathAddress getPathAddress(ModelNode operation) {
        return PathAddress.pathAddress(operation.get("address"));
    }

    private void throwOrWarnAboutDescriptorProblem(String message) {
        if (this.validateDescriptions) {
            throw new IllegalArgumentException(message);
        }
        ControllerLogger.ROOT_LOGGER.warn(message);
    }

    private String formatOperationForMessage(ModelNode operation) {
        if (this.includeOperationInError) {
            return operation.asString();
        }
        return "";
    }
}

