/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class ValidateOperationHandler
implements OperationStepHandler,
DescriptionProvider {
    public static ValidateOperationHandler INSTANCE = new ValidateOperationHandler(false);
    public static ValidateOperationHandler SLAVE_HC_INSTANCE = new ValidateOperationHandler(true);
    public static String OPERATION_NAME = "validate-operation";
    private final boolean slave;

    private ValidateOperationHandler(boolean slave) {
        this.slave = slave;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode op = operation.require("value");
        PathAddress addr = PathAddress.pathAddress(op.get("address"));
        if (this.slave) {
            op = op.clone();
            if (addr.size() > 0 && addr.getElement(0).getKey().equals("host")) {
                addr = addr.subAddress(1);
                op.get("address").set(addr.toModelNode());
            }
        }
        ProxyOperationAddressTranslator translator = null;
        ImmutableManagementResourceRegistration proxyReg = null;
        PathAddress proxyAddr = PathAddress.EMPTY_ADDRESS;
        for (PathElement element : addr) {
            proxyAddr = proxyAddr.append(element);
            ImmutableManagementResourceRegistration reg = context.getResourceRegistration().getSubModel(proxyAddr);
            if (!reg.isRemote()) continue;
            translator = element.getKey().equals("server") ? ProxyOperationAddressTranslator.SERVER : ProxyOperationAddressTranslator.HOST;
            proxyReg = reg;
            break;
        }
        if (proxyReg != null) {
            ModelNode proxyOp = operation.clone();
            proxyOp.get("address").set(proxyAddr.toModelNode());
            proxyOp.get(new String[]{"value", "address"}).set(translator.translateAddress(addr).toModelNode());
            ModelNode result = new ModelNode();
            context.addStep(result, proxyOp, proxyReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, "validate-operation"), OperationContext.Stage.IMMEDIATE);
            if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                context.getFailureDescription().set(result.get("failure-description"));
            }
        } else {
            try {
                new OperationValidator(context.getResourceRegistration(), false, false).validateOperation(op);
            }
            catch (IllegalArgumentException e) {
                context.getFailureDescription().set(e.getMessage());
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getValidateOperationDescription(locale);
    }
}

