/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import java.util.NoSuchElementException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ValidateAddressOperationHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "validate-address";
    public static final ValidateAddressOperationHandler INSTANCE = new ValidateAddressOperationHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode address = operation.require("value");
        PathAddress pathAddr = PathAddress.pathAddress(address);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        try {
            resource.navigate(pathAddr);
            context.getResult().get("valid").set(true);
        }
        catch (NoSuchElementException e) {
            context.getResult().get("valid").set(false);
            context.getResult().get("problem").set(e.getMessage());
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getValidateAddressOperation(locale);
    }
}

