/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.dmr.ModelNode;

public class InetAddressMatchInterfaceCriteria
implements InterfaceCriteria {
    private static final long serialVersionUID = 149404752878332750L;
    private ModelNode address;
    private String addressString;
    private InetAddress resolved;
    private boolean unknownHostLogged;
    private boolean anyLocalLogged;

    public InetAddressMatchInterfaceCriteria(ModelNode address) {
        if (address == null) {
            throw ControllerMessages.MESSAGES.nullVar("address");
        }
        this.address = address;
    }

    public InetAddressMatchInterfaceCriteria(String address) {
        if (address == null || address.isEmpty() || address.trim().isEmpty()) {
            throw ControllerMessages.MESSAGES.nullVar("address");
        }
        this.addressString = address;
    }

    public synchronized InetAddress getAddress() throws UnknownHostException {
        if (this.resolved == null) {
            this.resolved = this.address != null ? InetAddress.getByName(this.address.resolve().asString()) : InetAddress.getByName(this.addressString);
        }
        return this.resolved;
    }

    @Override
    public InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        try {
            InetAddress toMatch = this.getAddress();
            if (!this.anyLocalLogged && toMatch.isAnyLocalAddress()) {
                ControllerLogger.SERVER_LOGGER.invalidWildcardAddress(this.address, "inet-address", "any-address", "any-ipv4-address", "any-ipv6-address");
                this.anyLocalLogged = true;
            }
            if (toMatch.equals(address)) {
                if (toMatch instanceof Inet6Address) {
                    return InetAddressMatchInterfaceCriteria.matchIPv6((Inet6Address)toMatch, (Inet6Address)address);
                }
                return toMatch;
            }
        }
        catch (UnknownHostException e) {
            if (!this.unknownHostLogged) {
                ControllerLogger.SERVER_LOGGER.cannotResolveAddress(this.address);
                this.unknownHostLogged = true;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InetAddressMatchInterfaceCriteria(");
        sb.append("address=");
        sb.append(this.address);
        sb.append(",resolved=");
        sb.append(this.resolved);
        sb.append(')');
        return sb.toString();
    }

    private static InetAddress matchIPv6(Inet6Address toMatch, Inet6Address address) {
        return toMatch.getScopeId() == 0 || toMatch.getScopeId() == address.getScopeId() ? address : null;
    }
}

