/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import org.jboss.as.service.AbstractService;
import org.jboss.as.service.SarLogger;
import org.jboss.as.service.SarMessages;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class CreateDestroyService
extends AbstractService {
    private final Method createMethod;
    private final Method destroyMethod;

    CreateDestroyService(Object mBeanInstance, Method createMethod, Method destroyMethod) {
        super(mBeanInstance);
        this.createMethod = createMethod;
        this.destroyMethod = destroyMethod;
    }

    public void start(StartContext context) throws StartException {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Creating Service: %s", context.getController().getName());
        }
        try {
            this.invokeLifecycleMethod(this.createMethod);
        }
        catch (Exception e) {
            throw SarMessages.MESSAGES.failedExecutingLegacyMethod(e, "create()");
        }
    }

    public void stop(StopContext context) {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Destroying Service: %s", context.getController().getName());
        }
        try {
            this.invokeLifecycleMethod(this.destroyMethod);
        }
        catch (Exception e) {
            SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod(e, "create()");
        }
    }
}

