/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;

public class StateParser {
    private final DefaultParsingState initialState = new DefaultParsingState("INITIAL");

    public void addState(char ch, ParsingState state) {
        this.initialState.enterState(ch, state);
    }

    public void parse(String str, ParsingStateCallbackHandler callbackHandler) throws CommandFormatException {
        StateParser.parse(str, callbackHandler, this.initialState);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState) throws CommandFormatException {
        if (str == null || str.isEmpty()) {
            return;
        }
        int i = 0;
        ParsingContextImpl ctx = new ParsingContextImpl();
        ctx.initialState = initialState;
        ctx.callbackHandler = callbackHandler;
        ctx.input = str;
        ctx.ch = str.charAt(i);
        ctx.location = i;
        initialState.getEnterHandler().handle(ctx);
        while (i < str.length()) {
            char ch;
            ctx.ch = ch = str.charAt(i);
            ctx.location = i++;
            CharacterHandler handler = ctx.getState().getHandler(ch);
            handler.handle(ctx);
        }
        ctx.location = i;
        ctx.endOfContent = true;
        ParsingState state = ctx.getState();
        while (state != ctx.initialState) {
            state.getEndContentHandler().handle(ctx);
            ctx.leaveState();
            state = ctx.getState();
        }
        initialState.getEndContentHandler().handle(ctx);
        initialState.getLeaveHandler().handle(ctx);
    }

    static class ParsingContextImpl
    implements ParsingContext {
        private final Deque<ParsingState> stack = new ArrayDeque<ParsingState>();
        String input;
        int location;
        char ch;
        ParsingStateCallbackHandler callbackHandler;
        ParsingState initialState;
        boolean endOfContent;

        ParsingContextImpl() {
        }

        @Override
        public ParsingState getState() {
            return this.stack.isEmpty() ? this.initialState : this.stack.peek();
        }

        @Override
        public void enterState(ParsingState state) throws CommandFormatException {
            this.stack.push(state);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public ParsingState leaveState() throws CommandFormatException {
            this.callbackHandler.leavingState(this);
            this.stack.peek().getLeaveHandler().handle(this);
            ParsingState pop = this.stack.pop();
            if (!this.stack.isEmpty()) {
                this.stack.peek().getReturnHandler().handle(this);
            } else {
                this.initialState.getReturnHandler().handle(this);
            }
            return pop;
        }

        @Override
        public ParsingStateCallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public char getCharacter() {
            return this.ch;
        }

        @Override
        public int getLocation() {
            return this.location;
        }

        @Override
        public void reenterState() throws CommandFormatException {
            this.callbackHandler.leavingState(this);
            ParsingState state = this.stack.peek();
            state.getLeaveHandler().handle(this);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public boolean isEndOfContent() {
            return this.endOfContent;
        }

        @Override
        public String getInput() {
            return this.input;
        }
    }
}

