/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.Collection;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParserUtil;
import org.jboss.as.cli.parsing.operation.HeaderListState;
import org.jboss.dmr.ModelNode;

public final class HeadersArgumentValueConverter
extends ArgumentValueConverter.DMRWithFallbackConverter {
    private final DefaultCallbackHandler callback = new DefaultCallbackHandler();
    private final DefaultParsingState initialState = new DefaultParsingState("INITIAL_STATE");
    private final CommandContext ctx;

    public HeadersArgumentValueConverter(CommandContext ctx) {
        this.initialState.enterState('{', HeaderListState.INSTANCE);
        if (ctx == null) {
            throw new IllegalArgumentException("The command context can't be null.");
        }
        this.ctx = ctx;
    }

    @Override
    protected ModelNode fromNonDMRString(String value) throws CommandFormatException {
        this.callback.reset();
        ParserUtil.parse(value, this.callback, this.initialState);
        Collection<ParsedOperationRequestHeader> headers = this.callback.getHeaders();
        if (headers.isEmpty()) {
            throw new CommandFormatException("'" + value + "' doesn't follow format {[rollout server_group_list [rollback-across-groups];] (<header_name>=<header_value>;)*}");
        }
        ModelNode node = new ModelNode();
        for (ParsedOperationRequestHeader header : headers) {
            header.addTo(this.ctx, node);
        }
        return node;
    }
}

