/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.cli.impl.CommandContextImpl;
import org.jboss.as.protocol.StreamUtils;

public class CliLauncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int exitCode = 0;
        CommandContext cmdCtx = null;
        boolean gui = false;
        try {
            String argError = null;
            String[] commands = null;
            File file = null;
            boolean connect = false;
            String defaultControllerHost = null;
            int defaultControllerPort = -1;
            boolean version = false;
            String username = null;
            char[] password = null;
            for (String arg : args) {
                String value;
                if (arg.startsWith("--controller=") || arg.startsWith("controller=")) {
                    value = arg.startsWith("--") ? arg.substring(13) : arg.substring(11);
                    String portStr = null;
                    int colonIndex = value.lastIndexOf(58);
                    if (colonIndex < 0) {
                        defaultControllerHost = value;
                    } else if (colonIndex == 0) {
                        portStr = value.substring(1);
                    } else {
                        int closeBracket = value.lastIndexOf(93);
                        boolean hasPort = closeBracket != -1 ? closeBracket <= colonIndex : true;
                        if (hasPort) {
                            defaultControllerHost = value.substring(0, colonIndex).trim();
                            portStr = value.substring(colonIndex + 1).trim();
                        } else {
                            defaultControllerHost = value;
                        }
                    }
                    if (portStr == null) continue;
                    int port = -1;
                    try {
                        port = Integer.parseInt(portStr);
                        if (port < 0) {
                            argError = "The port must be a valid non-negative integer: '" + args + "'";
                            continue;
                        }
                        defaultControllerPort = port;
                    }
                    catch (NumberFormatException e) {
                        argError = "The port must be a valid non-negative integer: '" + arg + "'";
                    }
                    continue;
                }
                if ("--connect".equals(arg) || "-c".equals(arg)) {
                    connect = true;
                    continue;
                }
                if ("--version".equals(arg)) {
                    version = true;
                    continue;
                }
                if ("--gui".equals(arg)) {
                    gui = true;
                    continue;
                }
                if (arg.startsWith("--file=") || arg.startsWith("file=")) {
                    String fileName;
                    if (file != null) {
                        argError = "Duplicate argument '--file'.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    String string = fileName = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    if (!fileName.isEmpty()) {
                        file = new File(fileName);
                        if (file.exists()) continue;
                        argError = "File " + file.getAbsolutePath() + " doesn't exist.";
                        break;
                    }
                    argError = "Argument '--file' is missing value.";
                    break;
                }
                if (arg.startsWith("--commands=") || arg.startsWith("commands=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(11) : arg.substring(9);
                    commands = value.split(",+");
                    continue;
                }
                if (arg.startsWith("--command=") || arg.startsWith("command=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(10) : arg.substring(8);
                    commands = new String[]{value};
                    continue;
                }
                if (arg.startsWith("--user=")) {
                    username = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    continue;
                }
                if (arg.startsWith("--password=")) {
                    password = (arg.startsWith("--") ? arg.substring(11) : arg.substring(9)).toCharArray();
                    continue;
                }
                if (arg.equals("--help") || arg.equals("-h")) {
                    commands = new String[]{"help"};
                    continue;
                }
                if (file != null) {
                    argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                    break;
                }
                if (commands != null) {
                    argError = "Duplicate argument '--command'/'--commands'.";
                    break;
                }
                commands = arg.split(",+");
            }
            if (argError != null) {
                System.err.println(argError);
                exitCode = 1;
                return;
            }
            if (version) {
                cmdCtx = new CommandContextImpl();
                VersionHandler.INSTANCE.handle(cmdCtx);
                return;
            }
            if (file != null) {
                cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, false, connect);
                CliLauncher.processFile(file, cmdCtx);
                return;
            }
            if (commands != null) {
                cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, false, connect);
                CliLauncher.processCommands(commands, cmdCtx);
                return;
            }
            if (gui) {
                cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, false, true);
                CliLauncher.processGui(cmdCtx);
                return;
            }
            cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, true, connect);
            cmdCtx.interact();
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitCode = 1;
        }
        finally {
            if (cmdCtx != null && cmdCtx.getExitCode() != 0) {
                exitCode = cmdCtx.getExitCode();
            }
            if (!gui) {
                System.exit(exitCode);
            }
        }
        System.exit(exitCode);
    }

    private static CommandContext initCommandContext(String defaultHost, int defaultPort, String username, char[] password, boolean initConsole, boolean connect) throws CliInitializationException {
        CommandContext cmdCtx = CommandContextFactory.getInstance().newCommandContext(defaultHost, defaultPort, username, password, initConsole);
        if (connect) {
            try {
                cmdCtx.connectController();
            }
            catch (CommandLineException e) {
                throw new CliInitializationException("Failed to connect to the controller", e);
            }
        }
        return cmdCtx;
    }

    private static void processGui(CommandContext cmdCtx) {
        try {
            GuiMain.start(cmdCtx);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommands(String[] commands, CommandContext cmdCtx) {
        try {
            for (int i = 0; cmdCtx.getExitCode() == 0 && i < commands.length && !cmdCtx.isTerminated(); ++i) {
                cmdCtx.handleSafe(commands[i]);
            }
        }
        finally {
            cmdCtx.terminateSession();
        }
    }

    private static void processFile(File file, CommandContext cmdCtx) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (cmdCtx.getExitCode() == 0 && !cmdCtx.isTerminated() && line != null) {
                cmdCtx.handleSafe(line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            try {
                throw new IllegalStateException("Failed to process file '" + file.getAbsolutePath() + "'", e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                cmdCtx.terminateSession();
                throw throwable;
            }
        }
        StreamUtils.safeClose((Closeable)reader);
        cmdCtx.terminateSession();
    }
}

