/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class OperationDialog
extends JDialog {
    private ManagementModelNode node;
    private String opName;
    private SortedSet<RequestProp> props;

    public OperationDialog(ManagementModelNode node, String opName, String strDescription, ModelNode requestProperties) {
        super(GuiMain.getFrame(), opName, true);
        this.node = node;
        this.opName = opName;
        this.setProps(requestProperties);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(10, 10));
        JLabel opNameLabel = new JLabel("Params for " + opName + ":");
        opNameLabel.setToolTipText(strDescription);
        contentPane.add((Component)opNameLabel, "North");
        contentPane.add((Component)this.makeInputPanel(), "Center");
        contentPane.add((Component)this.makeButtonPanel(), "South");
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.node.isLeaf()) {
            for (RequestProp prop : this.props) {
                if (!prop.getName().equals("value")) continue;
                prop.getValueComponent().requestFocus();
            }
        }
        super.setVisible(isVisible);
    }

    private void setProps(ModelNode requestProperties) {
        this.props = new TreeSet<RequestProp>();
        if (this.opName.equals("add")) {
            ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)this.node.getUserObject();
            this.props.add(new RequestProp("/" + usrObj.getName() + "=<name>/", "Resource name for the new " + usrObj.getName(), true));
        }
        for (Property prop : requestProperties.asPropertyList()) {
            this.props.add(new RequestProp(prop.getName(), prop.getValue()));
        }
    }

    private JPanel makeInputPanel() {
        boolean hasRequiredFields = false;
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.anchor = 17;
        gbConst.insets = new Insets(5, 5, 5, 5);
        for (RequestProp prop : this.props) {
            JLabel label = prop.getLabel();
            gbConst.gridwidth = 1;
            inputPanel.add((Component)label, gbConst);
            inputPanel.add(Box.createHorizontalStrut(5));
            JComponent comp = prop.getValueComponent();
            gbConst.gridwidth = 0;
            inputPanel.add((Component)comp, gbConst);
            if (!prop.isRequired) continue;
            hasRequiredFields = true;
        }
        if (hasRequiredFields) {
            inputPanel.add(new JLabel(" * = Required Field"));
        }
        return inputPanel;
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new SetOperationActionListener());
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                OperationDialog.this.dispose();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    private class RequestProp
    implements Comparable {
        private final String name;
        private ModelNode props;
        private ModelType type;
        private String description;
        private boolean isRequired = false;
        private boolean nillable = false;
        private ModelNode defaultValue = null;
        private JLabel label;
        private JComponent valueComponent;
        private boolean isResourceName = false;

        public RequestProp(String name, String description, boolean required) {
            this.name = name;
            this.props = new ModelNode();
            this.description = description;
            this.type = ModelType.STRING;
            this.isRequired = required;
            this.isResourceName = true;
            this.setInputComponent();
        }

        public RequestProp(String name, ModelNode props) {
            this.name = name;
            this.props = props;
            this.type = props.get("type").asType();
            if (props.get("description").isDefined()) {
                this.description = props.get("description").asString();
            }
            if (props.get("required").isDefined()) {
                this.isRequired = props.get("required").asBoolean();
            }
            if (props.get("nillable").isDefined()) {
                this.nillable = props.get("nillable").asBoolean();
            }
            if (props.get("default").isDefined()) {
                this.defaultValue = props.get("default");
            }
            this.setInputComponent();
            this.setWriteAttributeValues();
        }

        public String getName() {
            return this.name;
        }

        public JComponent getValueComponent() {
            return this.valueComponent;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public String getValueAsString() {
            if (this.valueComponent instanceof JTextComponent) {
                return ((JTextComponent)this.valueComponent).getText();
            }
            if (this.valueComponent instanceof AbstractButton) {
                return Boolean.toString(((AbstractButton)this.valueComponent).isSelected());
            }
            if (this.valueComponent instanceof JComboBox) {
                return ((JComboBox)this.valueComponent).getSelectedItem().toString();
            }
            return null;
        }

        private void setInputComponent() {
            if (this.type == ModelType.BOOLEAN) {
                this.valueComponent = this.defaultValue == null ? new JCheckBox(this.makeLabelString(false)) : new JCheckBox(this.makeLabelString(false), this.defaultValue.asBoolean());
                this.valueComponent.setToolTipText(this.description);
                this.label = new JLabel();
            } else if (this.props.get("allowed").isDefined()) {
                JComboBox comboBox = this.makeJComboBox(this.props.get("allowed").asList());
                if (this.defaultValue != null) {
                    comboBox.setSelectedItem(this.defaultValue.asString());
                }
                this.valueComponent = comboBox;
                this.label = this.makeLabel();
            } else {
                JTextField textField = new JTextField(30);
                if (this.defaultValue != null) {
                    textField.setText(this.defaultValue.asString());
                }
                this.valueComponent = textField;
                this.label = this.makeLabel();
            }
        }

        private String makeLabelString(boolean addColon) {
            String labelString = this.name;
            if (addColon) {
                labelString = labelString + ":";
            }
            if (this.isRequired) {
                labelString = labelString + " *";
            }
            return labelString;
        }

        private JLabel makeLabel() {
            JLabel label = new JLabel(this.makeLabelString(true));
            label.setToolTipText(this.description);
            return label;
        }

        private JComboBox makeJComboBox(List<ModelNode> values) {
            Vector<String> valueVector = new Vector<String>(values.size());
            if (!this.isRequired) {
                valueVector.add("");
            }
            for (ModelNode node : values) {
                valueVector.add(node.asString());
            }
            return new JComboBox(valueVector);
        }

        private void setWriteAttributeValues() {
            if (!OperationDialog.this.node.isLeaf()) {
                return;
            }
            if (!OperationDialog.this.opName.equals("write-attribute")) {
                return;
            }
            ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)OperationDialog.this.node.getUserObject();
            if (this.name.equals("name")) {
                ((JTextField)this.valueComponent).setText(usrObj.getName());
                return;
            }
            if (usrObj.getValue().equals("undefined")) {
                return;
            }
            if (this.name.equals("value")) {
                ((JTextField)this.valueComponent).setText(usrObj.getValue());
            }
        }

        public int compareTo(Object t) {
            if (this.equals(t)) {
                return 0;
            }
            if (this.isResourceName) {
                return -1;
            }
            RequestProp compareTo = (RequestProp)t;
            if (this.isRequired && compareTo.isRequired) {
                return 1;
            }
            if (this.isRequired) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RequestProp)) {
                return false;
            }
            RequestProp compareTo = (RequestProp)obj;
            return this.name.equals(compareTo.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private class SetOperationActionListener
    implements ActionListener {
        private SetOperationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String addressPath = OperationDialog.this.node.addressPath();
            if (OperationDialog.this.opName.equals("add")) {
                ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)OperationDialog.this.node.getUserObject();
                ManagementModelNode parent = (ManagementModelNode)OperationDialog.this.node.getParent();
                RequestProp resourceProp = (RequestProp)OperationDialog.this.props.first();
                String value = resourceProp.getValueAsString();
                value = ManagementModelNode.escapeAddressElement(value);
                addressPath = parent.addressPath() + usrObj.getName() + "=" + value + "/";
                OperationDialog.this.props.remove(resourceProp);
            }
            StringBuilder command = new StringBuilder();
            command.append(addressPath);
            command.append(":");
            command.append(OperationDialog.this.opName);
            this.addRequestProps(command, OperationDialog.this.props);
            GuiMain.getCommandText().setText(command.toString());
            OperationDialog.this.dispose();
            GuiMain.getCommandText().requestFocus();
        }

        private void addRequestProps(StringBuilder command, SortedSet<RequestProp> reqProps) {
            boolean addedProps = false;
            command.append("(");
            for (RequestProp prop : reqProps) {
                String value = prop.getValueAsString();
                if (value == null || value.equals("")) continue;
                addedProps = true;
                command.append(prop.getName());
                command.append("=");
                command.append(value);
                command.append(",");
            }
            if (addedProps) {
                command.replace(command.length() - 1, command.length(), ")");
            } else {
                command.deleteCharAt(command.length() - 1);
            }
        }
    }
}

