/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xml.serialize.SecuritySupport;

final class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;

    ObjectFactory() {
    }

    static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        try {
            return Class.forName(fallbackClassName).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationError(e.getMessage(), e);
        }
    }

    private static void debugPrintln(String msg) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        return ObjectFactory.class.getClassLoader();
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class providerClass = ObjectFactory.findProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Class findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        return Class.forName(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        ClassLoader current;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ObjectFactory.findClassLoader();
        is = SecuritySupport.getResourceAsStream(cl, serviceId);
        if (is == null && cl != (current = ObjectFactory.class.getClassLoader())) {
            cl = current;
            is = SecuritySupport.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is), 80);
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
        }
        catch (IOException x) {
            Object var7_9 = null;
            return var7_9;
        }
        finally {
            try {
                rd.close();
            }
            catch (IOException exc) {}
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            return ObjectFactory.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    static final class ConfigurationError
    extends Error {
        static final long serialVersionUID = 937647395548533254L;
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

