/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDefinition;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class DeploymentScannerAdd
extends AbstractAddStepHandler {
    static final DeploymentScannerAdd INSTANCE = new DeploymentScannerAdd();

    private DeploymentScannerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition atr : DeploymentScannerDefinition.ALL_ATTRIBUTES) {
            atr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String path = DeploymentScannerDefinition.PATH.resolveModelAttribute(context, operation).asString();
        Boolean enabled = DeploymentScannerDefinition.SCAN_ENABLED.resolveModelAttribute(context, operation).asBoolean();
        Integer interval = DeploymentScannerDefinition.SCAN_INTERVAL.resolveModelAttribute(context, operation).asInt();
        String relativeTo = operation.hasDefined("relative-to") ? DeploymentScannerDefinition.RELATIVE_TO.resolveModelAttribute(context, operation).asString() : null;
        Boolean autoDeployZip = DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED.resolveModelAttribute(context, operation).asBoolean();
        Boolean autoDeployExp = DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED.resolveModelAttribute(context, operation).asBoolean();
        Boolean autoDeployXml = DeploymentScannerDefinition.AUTO_DEPLOY_XML.resolveModelAttribute(context, operation).asBoolean();
        Long deploymentTimeout = DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT.resolveModelAttribute(context, operation).asLong();
        ServiceTarget serviceTarget = context.getServiceTarget();
        DeploymentScannerService.addService(serviceTarget, name, relativeTo, path, interval, TimeUnit.MILLISECONDS, autoDeployZip, autoDeployExp, autoDeployXml, enabled, deploymentTimeout, newControllers, new ServiceListener[]{verificationHandler});
    }
}

