/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.jms.AbstractJMSRuntimeHandler;
import org.jboss.dmr.ModelNode;

public class JMSQueueConfigurationRuntimeHandler
extends AbstractJMSRuntimeHandler<ModelNode> {
    public static final JMSQueueConfigurationRuntimeHandler INSTANCE = new JMSQueueConfigurationRuntimeHandler();

    private JMSQueueConfigurationRuntimeHandler() {
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : CommonAttributes.JMS_QUEUE_ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr.getName(), (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
    }

    @Override
    protected void executeReadAttribute(String attributeName, OperationContext context, ModelNode destination, PathAddress address, boolean includeDefault) {
        if (destination.hasDefined(attributeName)) {
            context.getResult().set(destination.get(attributeName));
        } else if (includeDefault) {
            for (AttributeDefinition attr : CommonAttributes.JMS_QUEUE_ATTRIBUTES) {
                if (!attr.getName().equals(attributeName)) continue;
                context.getResult().set(attr.getDefaultValue());
            }
        }
    }
}

