/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class ConnectionFactoryService
implements Service<Void> {
    private final String name;
    private final ConnectionFactoryConfiguration configuration;
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();

    public ConnectionFactoryService(ConnectionFactoryConfiguration configuration) {
        this.name = configuration.getName();
        if (this.name == null) {
            throw MessagingMessages.MESSAGES.nullVar("cf name");
        }
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            WritableServiceBasedNamingStore.pushOwner((ServiceTarget)context.getChildTarget(), (ServiceName[])new ServiceName[0]);
            try {
                jmsManager.createConnectionFactory(false, this.configuration, this.configuration.getBindings());
            }
            finally {
                WritableServiceBasedNamingStore.popOwner();
            }
        }
        catch (Exception e) {
            throw new StartException(MessagingMessages.MESSAGES.failedToCreate("connection-factory"), (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.destroyConnectionFactory(this.name);
        }
        catch (Exception e) {
            MessagingLogger.MESSAGING_LOGGER.failedToDestroy("connection-factory", this.name);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }
}

