/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.saml.v2.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.saml.v2.metadata.ContactType;
import org.picketlink.identity.federation.saml.v2.metadata.ExtensionsType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.OrganizationType;
import org.picketlink.identity.federation.saml.v2.metadata.TypeWithOtherAttributes;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RoleDescriptorType
extends TypeWithOtherAttributes {
    protected Element signature;
    protected ExtensionsType extensions;
    protected List<KeyDescriptorType> keyDescriptor = new ArrayList<KeyDescriptorType>();
    protected OrganizationType organization;
    protected List<ContactType> contactPerson = new ArrayList<ContactType>();
    protected String id;
    protected XMLGregorianCalendar validUntil;
    protected Duration cacheDuration;
    protected List<String> protocolSupportEnumeration = new ArrayList<String>();
    protected String errorURL;

    public RoleDescriptorType(List<String> protocolSupport) {
        this.protocolSupportEnumeration.addAll(protocolSupport);
    }

    public void addKeyDescriptor(KeyDescriptorType keyD) {
        this.keyDescriptor.add(keyD);
    }

    public void addContactPerson(ContactType contact) {
        this.contactPerson.add(contact);
    }

    public void removeKeyDescriptor(KeyDescriptorType keyD) {
        this.keyDescriptor.remove(keyD);
    }

    public void removeContactPerson(ContactType contact) {
        this.contactPerson.remove(contact);
    }

    public Element getSignature() {
        return this.signature;
    }

    public void setSignature(Element value) {
        this.signature = value;
    }

    public ExtensionsType getExtensions() {
        return this.extensions;
    }

    public void setExtensions(ExtensionsType value) {
        this.extensions = value;
    }

    public List<KeyDescriptorType> getKeyDescriptor() {
        return Collections.unmodifiableList(this.keyDescriptor);
    }

    public OrganizationType getOrganization() {
        return this.organization;
    }

    public void setOrganization(OrganizationType value) {
        this.organization = value;
    }

    public List<ContactType> getContactPerson() {
        return Collections.unmodifiableList(this.contactPerson);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String value) {
        this.id = value;
    }

    public XMLGregorianCalendar getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(XMLGregorianCalendar value) {
        this.validUntil = value;
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Duration value) {
        this.cacheDuration = value;
    }

    public List<String> getProtocolSupportEnumeration() {
        return Collections.unmodifiableList(this.protocolSupportEnumeration);
    }

    public String getErrorURL() {
        return this.errorURL;
    }

    public void setErrorURL(String value) {
        this.errorURL = value;
    }
}

