/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.parsers.sts.STSConfigParser;
import org.picketlink.identity.federation.core.sts.STSCoreConfig;
import org.picketlink.identity.federation.core.sts.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;

public class PicketLinkCoreSTS {
    private static final Logger logger = Logger.getLogger(PicketLinkCoreSTS.class);
    public static final RuntimePermission rte = new RuntimePermission("org.picketlink.sts");
    protected STSCoreConfig configuration;
    private static PicketLinkCoreSTS _instance = null;
    private static final String SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("file.separator");
        }
    });
    private static final String STS_CONFIG_DIR = "picketlink-store" + SEPARATOR + "sts" + SEPARATOR;

    protected PicketLinkCoreSTS() {
    }

    public static PicketLinkCoreSTS instance() {
        if (_instance == null) {
            _instance = new PicketLinkCoreSTS();
        }
        return _instance;
    }

    public void initialize(STSCoreConfig config) {
        if (this.configuration != null) {
            this.configuration.copy(config);
        } else {
            this.configuration = config;
        }
    }

    public void installDefaultConfiguration(String ... configFileName) {
        String fileName = "core-sts.xml";
        if (configFileName != null && configFileName.length > 0) {
            fileName = configFileName[0];
        }
        if (this.configuration == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[InstallDefaultConfiguration] Configuration is null. Creating a new configuration");
            }
            this.configuration = new PicketLinkSTSConfiguration();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[InstallDefaultConfiguration] Configuration file name=" + fileName));
            }
            STSConfiguration config = this.getConfiguration(fileName);
            this.configuration.copy(config);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void issueToken(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rte);
        }
        if ((provider = this.getProvider(protocolContext)) == null) {
            throw new ProcessingException("PL00013: No Security Token Provider found in configuration:[" + this.configuration + "][ProtoCtx=" + protocolContext + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("issueToken::provider=" + provider));
        }
        provider.issueToken(protocolContext);
    }

    public void renewToken(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rte);
        }
        if ((provider = null) == null) {
            provider = this.getProviderBasedOnQName(protocolContext);
        }
        if (provider == null) {
            throw new ProcessingException("PL00013: No Security Token Provider found in configuration:[" + this.configuration + "[ProtoCtx=]" + protocolContext);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("renewToken::provider=" + provider));
        }
        provider.renewToken(protocolContext);
    }

    public void cancelToken(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rte);
        }
        if ((provider = null) == null) {
            provider = this.getProviderBasedOnQName(protocolContext);
        }
        if (provider == null) {
            throw new ProcessingException("PL00013: No Security Token Provider found in configuration:[" + protocolContext);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cancelToken::provider=" + provider));
        }
        provider.cancelToken(protocolContext);
    }

    public void validateToken(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rte);
        }
        if ((provider = null) == null) {
            provider = this.getProviderBasedOnQName(protocolContext);
        }
        if (provider == null) {
            throw new ProcessingException("PL00013: No Security Token Provider found in configuration:[" + this.configuration + "[ProtoCtx=]" + protocolContext);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("validateToken::provider=" + provider));
        }
        provider.validateToken(protocolContext);
    }

    private SecurityTokenProvider getProvider(ProtocolContext protocolContext) {
        String tokenType;
        if (this.configuration == null) {
            throw new RuntimeException("PL00014: Configuration is not set");
        }
        SecurityTokenProvider provider = null;
        String serviceName = protocolContext.serviceName();
        if (serviceName != null) {
            provider = this.configuration.getProviderForService(serviceName);
        }
        if (provider == null && (tokenType = protocolContext.tokenType()) != null) {
            provider = this.configuration.getProviderForTokenType(protocolContext.tokenType());
        }
        return provider;
    }

    private SecurityTokenProvider getProviderBasedOnQName(ProtocolContext protocolContext) throws ProcessingException {
        SecurityTokenProvider provider = null;
        QName qname = null;
        if (provider == null) {
            qname = protocolContext.getQName();
            if (qname == null) {
                throw new ProcessingException("PL00092: Null Value:QName of the token type");
            }
            provider = this.configuration.getProviderForTokenElementNS(protocolContext.family(), qname);
        }
        if (provider == null) {
            throw new ProcessingException("PL00013: No Security Token Provider found in configuration:[" + qname.getNamespaceURI() + ":" + qname.getLocalPart());
        }
        return provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected STSConfiguration getConfiguration(String fileName) throws ConfigurationException {
        URL configurationFileURL = null;
        try {
            String configurationFilePath = String.valueOf(System.getProperty("user.home")) + SEPARATOR + STS_CONFIG_DIR + fileName;
            File configurationFile = new File(configurationFilePath);
            configurationFileURL = configurationFile.exists() ? configurationFile.toURI().toURL() : SecurityActions.loadResource(this.getClass(), fileName);
            if (configurationFileURL == null) {
                logger.warn((Object)(String.valueOf(fileName) + " configuration file not found using TCCL"));
                ClassLoader clazzLoader = SecurityActions.getClassLoader(this.getClass());
                configurationFileURL = clazzLoader.getResource(fileName);
            }
            if (configurationFileURL == null) {
                logger.warn((Object)(String.valueOf(fileName) + " configuration file not found using classloader"));
                try {
                    try {
                        configurationFileURL = new URL(fileName);
                    }
                    catch (Exception e) {
                        PicketLinkSTSConfiguration picketLinkSTSConfiguration = new PicketLinkSTSConfiguration();
                        if (configurationFileURL == null) {
                            logger.warn((Object)(String.valueOf(fileName) + " configuration file not found using URL. Using default configuration values"));
                            return new PicketLinkSTSConfiguration();
                        }
                        return picketLinkSTSConfiguration;
                    }
                }
                finally {
                    if (configurationFileURL == null) {
                        logger.warn((Object)(String.valueOf(fileName) + " configuration file not found using URL. Using default configuration values"));
                        return new PicketLinkSTSConfiguration();
                    }
                }
            }
            InputStream stream = configurationFileURL.openStream();
            STSType stsConfig = (STSType)new STSConfigParser().parse(stream);
            PicketLinkSTSConfiguration configuration = new PicketLinkSTSConfiguration(stsConfig);
            if (logger.isInfoEnabled()) {
                logger.info((Object)(String.valueOf(fileName) + " configuration file loaded"));
            }
            return configuration;
        }
        catch (Exception e) {
            throw new ConfigurationException("PL00005: Error parsing the configuration file:", e);
        }
    }
}

