/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.SAMLRequestAbstractParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.protocol.ArtifactResolveType;

public class SAMLArtifactResolveParser
extends SAMLRequestAbstractParser
implements ParserNamespaceSupport {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ARTIFACT_RESOLVE.get());
        ArtifactResolveType artifactResolve = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext()) {
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            super.parseCommonElements(startElement, xmlEventReader, artifactResolve);
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.ARTIFACT.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                artifactResolve.setArtifact(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ISSUER.get().equals(elementName) || JBossSAMLConstants.SIGNATURE.get().equals(elementName)) continue;
            throw new RuntimeException("PL00064: Parser: Unknown Start Element: " + elementName + "::location=" + startElement.getLocation());
        }
        return artifactResolve;
    }

    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI());
    }

    private ArtifactResolveType parseBaseAttributes(StartElement startElement) throws ParsingException {
        super.parseRequiredAttributes(startElement);
        ArtifactResolveType authnRequest = new ArtifactResolveType(this.id, this.issueInstant);
        super.parseBaseAttributes(startElement, authnRequest);
        return authnRequest;
    }
}

