/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.auth.callback.AbstractCallbackHandler;
import org.jboss.security.auth.callback.DecodeAction;
import org.jboss.security.auth.callback.SecurityActions;
import org.jboss.security.auth.callback.VerifyPasswordCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapCallbackHandler
extends AbstractCallbackHandler
implements CallbackHandler {
    protected static Logger log = Logger.getLogger(LdapCallbackHandler.class);
    protected boolean trace = log.isTraceEnabled();
    private static final String PASSWORD_ATTRIBUTE_ID = "passwordAttributeID";
    private static final String BIND_DN = "bindDN";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String BASE_CTX_DN = "baseCtxDN";
    private static final String BASE_FILTER_OPT = "baseFilter";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
    private static final String DISTINGUISHED_NAME_ATTRIBUTE_OPT = "distinguishedNameAttribute";
    protected String bindDN;
    protected String bindCredential;
    protected String baseDN;
    protected String baseFilter;
    protected String passwordAttributeID = "userPassword";
    protected int recursion = 0;
    protected int searchTimeLimit = 10000;
    protected int searchScope = 2;
    protected String distinguishedNameAttribute;
    protected boolean parseUsername;
    protected String usernameBeginString;
    protected String usernameEndString;
    protected boolean isPasswordValidated = false;
    protected Map<String, String> options = new HashMap<String, String>();

    public void setConfiguration(Map<String, String> config) {
        if (config != null) {
            this.options.putAll(config);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.userName == null) {
            this.userName = this.getUserName(callbacks);
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            try {
                this.handleCallBack(callback);
                continue;
            }
            catch (NamingException e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCallBack(Callback c) throws UnsupportedCallbackException, NamingException {
        InitialLdapContext ctx;
        ClassLoader currentTCCL;
        PasswordCallback passwdCallback;
        block21: {
            if (c instanceof VerifyPasswordCallback) {
                this.verifyPassword((VerifyPasswordCallback)c);
                return;
            }
            if (!(c instanceof PasswordCallback)) {
                return;
            }
            passwdCallback = (PasswordCallback)c;
            String bindDN = this.getBindDN();
            String bindCredential = this.getBindCredential();
            String tmp = this.options.get(PASSWORD_ATTRIBUTE_ID);
            if (tmp != null && tmp.length() > 0) {
                this.passwordAttributeID = tmp;
            }
            currentTCCL = SecurityActions.getContextClassLoader();
            try {
                if (currentTCCL != null) {
                    SecurityActions.setContextClassLoader(null);
                }
                ctx = this.constructInitialLdapContext(bindDN, bindCredential);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            String timeLimit = this.options.get(SEARCH_TIME_LIMIT_OPT);
            if (timeLimit != null) {
                try {
                    this.searchTimeLimit = Integer.parseInt(timeLimit);
                }
                catch (NumberFormatException e) {
                    if (!this.trace) break block21;
                    log.trace((Object)("Failed to parse: " + timeLimit + ", using searchTimeLimit=" + this.searchTimeLimit), (Throwable)e);
                }
            }
        }
        if (this.searchTimeLimit == 0) {
            this.searchTimeLimit = 10000;
        }
        String baseDN = this.options.get(BASE_CTX_DN);
        String baseFilter = this.options.get(BASE_FILTER_OPT);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(this.searchTimeLimit);
        NamingEnumeration<SearchResult> results = null;
        Object[] filterArgs = new Object[]{this.userName};
        try {
            if (baseDN == null) {
                throw new NamingException("PB00015: Null Value:baseCtxDN is null");
            }
            results = ctx.search(baseDN, baseFilter, filterArgs, constraints);
            if (!results.hasMore()) {
                this.safeClose(results);
                throw new NamingException("PB00019: Processing Failed:Search of baseDN(" + baseDN + ") found no matches");
            }
            SearchResult sr = results.next();
            String name = sr.getName();
            String userDN = null;
            if (!sr.isRelative()) {
                throw new NamingException("PB00019: Processing Failed:Can't follow referal for authentication: " + name);
            }
            userDN = name + "," + baseDN;
            this.safeClose(results);
            filterArgs = new Object[]{this.userName, userDN};
            results = ctx.search(userDN, baseFilter, filterArgs, constraints);
            try {
                while (results.hasMore()) {
                    sr = results.next();
                    Attributes attributes = sr.getAttributes();
                    NamingEnumeration<? extends Attribute> ne = attributes.getAll();
                    while (ne != null && ne.hasMoreElements()) {
                        Attribute ldapAtt = ne.next();
                        if (!this.passwordAttributeID.equalsIgnoreCase(ldapAtt.getID())) continue;
                        Object thePass = ldapAtt.get();
                        this.setPasswordCallbackValue(thePass, passwdCallback);
                    }
                }
            }
            finally {
                this.safeClose(results);
                this.safeClose(ctx);
                if (currentTCCL != null) {
                    SecurityActions.setContextClassLoader(currentTCCL);
                }
            }
        }
        catch (NamingException ne) {
            log.error((Object)ne);
            return;
        }
        results = null;
    }

    protected void verifyPassword(VerifyPasswordCallback vpc) throws NamingException {
        String credential = vpc.getValue();
        ClassLoader currentTCCL = SecurityActions.getContextClassLoader();
        if (currentTCCL != null) {
            SecurityActions.setContextClassLoader(null);
        }
        String baseDN = this.options.get(BASE_CTX_DN);
        String baseFilter = this.options.get(BASE_FILTER_OPT);
        InitialLdapContext ctx = this.constructInitialLdapContext(this.bindDN, this.bindCredential);
        this.bindDNAuthentication(ctx, this.userName, credential, baseDN, baseFilter);
        vpc.setVerified(true);
    }

    protected String getBindDN() {
        String bindDN = this.options.get(BIND_DN);
        if ((bindDN == null || bindDN.length() == 0) && this.trace) {
            log.trace((Object)"bindDN is not found");
        }
        return bindDN;
    }

    protected String getBindCredential() {
        String securityDomain;
        String bindCredential = this.options.get(BIND_CREDENTIAL);
        if (bindCredential.startsWith("{EXT}")) {
            try {
                bindCredential = new String(Util.loadPassword(bindCredential));
            }
            catch (Exception e1) {
                log.error((Object)"Exception in decrypting bindCredential:", (Throwable)e1);
            }
        }
        if ((securityDomain = this.options.get(SECURITY_DOMAIN_OPT)) != null) {
            try {
                ObjectName serviceName = new ObjectName(securityDomain);
                char[] tmp = DecodeAction.decode(bindCredential, serviceName);
                bindCredential = new String(tmp);
            }
            catch (Exception e) {
                log.error((Object)"Exception in decrypting bindCredential:", (Throwable)e);
            }
        }
        return bindCredential;
    }

    protected void setPasswordCallbackValue(Object thePass, PasswordCallback passwdCallback) {
        String tmp = null;
        if (thePass instanceof String) {
            tmp = (String)thePass;
            passwdCallback.setPassword(tmp.toCharArray());
        } else if (thePass instanceof char[]) {
            passwdCallback.setPassword((char[])thePass);
        } else if (thePass instanceof byte[]) {
            byte[] theBytes = (byte[])thePass;
            passwdCallback.setPassword(new String(theBytes).toCharArray());
        } else {
            throw new RuntimeException("PB00016: Wrong Type:password type:" + thePass.getClass());
        }
    }

    private InitialLdapContext constructInitialLdapContext(String dn, Object credential) throws NamingException {
        String authType;
        Properties env = new Properties();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerURL);
        this.distinguishedNameAttribute = this.options.get(DISTINGUISHED_NAME_ATTRIBUTE_OPT);
        if (this.distinguishedNameAttribute == null) {
            this.distinguishedNameAttribute = "distinguishedName";
        }
        if (dn != null) {
            env.setProperty("java.naming.security.principal", dn);
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        this.traceLdapEnv(env);
        return new InitialLdapContext(env, null);
    }

    protected String bindDNAuthentication(InitialLdapContext ctx, String user, Object credential, String baseDN, String filter) throws NamingException {
        Attribute dn;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(this.searchTimeLimit);
        String[] attrList = new String[]{this.distinguishedNameAttribute};
        constraints.setReturningAttributes(attrList);
        NamingEnumeration<SearchResult> results = null;
        Object[] filterArgs = new Object[]{user};
        results = ctx.search(baseDN, filter, filterArgs, constraints);
        if (!results.hasMore()) {
            results.close();
            throw new NamingException("PB00019: Processing Failed:Search of baseDN(" + baseDN + ") found no matches");
        }
        SearchResult sr = results.next();
        String name = sr.getName();
        String userDN = null;
        Attributes attrs = sr.getAttributes();
        if (attrs != null && (dn = attrs.get(this.distinguishedNameAttribute)) != null) {
            userDN = (String)dn.get();
        }
        if (userDN == null) {
            if (sr.isRelative()) {
                userDN = name + ("".equals(baseDN) ? "" : "," + baseDN);
            } else {
                throw new NamingException("PB00019: Processing Failed:Can't follow referal for authentication: " + name);
            }
        }
        this.safeClose(results);
        results = null;
        InitialLdapContext userCtx = this.constructInitialLdapContext(userDN, credential);
        this.safeClose(userCtx);
        return userDN;
    }

    private void traceLdapEnv(Properties env) {
        if (this.trace) {
            Properties tmp = new Properties();
            tmp.putAll((Map<?, ?>)env);
            tmp.setProperty("java.naming.security.credentials", "***");
            log.trace((Object)("Logging into LDAP server, env=" + tmp.toString()));
        }
    }

    protected void safeClose(NamingEnumeration results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    protected void safeClose(InitialLdapContext ic) {
        if (ic != null) {
            try {
                ic.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }
}

