/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.workmanager.SecurityActions;
import org.jboss.jca.core.workmanager.WorkManagerImpl;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.JASPICallbackHandler;

public class WorkWrapper
implements Runnable {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkWrapper.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private Work work;
    private ExecutionContext executionContext;
    private Map<Class<? extends WorkContext>, WorkContext> workContexts;
    private WorkListener workListener;
    private WorkManagerImpl workManager;
    private long blockedTime;
    private WorkException exception;
    private CountDownLatch startedLatch;
    private CountDownLatch completedLatch;

    public WorkWrapper(WorkManagerImpl workManager, Work work, ExecutionContext executionContext, WorkListener workListener, CountDownLatch startedLatch, CountDownLatch completedLatch) {
        if (work == null) {
            throw new IllegalArgumentException("Null work");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("Null execution context");
        }
        this.workManager = workManager;
        this.work = work;
        this.executionContext = executionContext;
        this.workListener = workListener;
        this.startedLatch = startedLatch;
        this.completedLatch = completedLatch;
        this.workContexts = null;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public Work getWork() {
        return this.work;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public WorkException getWorkException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (trace) {
            log.trace("Starting work " + this);
        }
        ClassLoader oldCL = SecurityActions.getThreadContextClassLoader();
        SecurityActions.setThreadContextClassLoader(this.work.getClass().getClassLoader());
        org.jboss.security.SecurityContext oldSC = SecurityContextAssociation.getSecurityContext();
        try {
            this.start();
            this.workManager.addWorkWrapper(this);
            if (this.startedLatch != null) {
                this.startedLatch.countDown();
            }
            this.work.run();
            this.end();
        }
        catch (Exception e) {
            this.exception = new WorkCompletedException((Throwable)e);
            this.cancel();
        }
        finally {
            this.workManager.removeWorkWrapper(this);
            this.work.release();
            if (this.workListener != null) {
                WorkEvent event = new WorkEvent((Object)this.workManager, 4, this.work, this.exception);
                this.workListener.workCompleted(event);
            }
            SecurityContextAssociation.setSecurityContext((org.jboss.security.SecurityContext)oldSC);
            SecurityActions.setThreadContextClassLoader(oldCL);
            if (this.startedLatch != null) {
                while (this.startedLatch.getCount() != 0L) {
                    this.startedLatch.countDown();
                }
            }
            if (this.completedLatch != null) {
                this.completedLatch.countDown();
            }
            if (trace) {
                log.trace("Executed work " + this);
            }
        }
    }

    protected void start() throws WorkException {
        Xid xid;
        SecurityContext securityContext;
        Xid xid2;
        ExecutionContext ctx;
        if (trace) {
            log.trace("Starting work " + this);
        }
        if ((ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class)) == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid2 = ctx.getXid()) != null) {
            long timeout = ctx.getTransactionTimeout() * 1000L;
            this.workManager.getXATerminator().registerWork(this.work, xid2, timeout);
        }
        if ((securityContext = this.getWorkContext(SecurityContext.class)) != null && this.workManager.getCallbackSecurity() != null) {
            try {
                org.jboss.security.SecurityContext sc = SecurityContextFactory.createSecurityContext((String)this.workManager.getCallbackSecurity().getDomain());
                SecurityContextAssociation.setSecurityContext((org.jboss.security.SecurityContext)sc);
                JASPICallbackHandler cbh = new JASPICallbackHandler();
                ArrayList<Object> callbacks = new ArrayList<Object>();
                Set users = this.workManager.getCallbackSecurity().getUsers();
                if (users != null && users.size() > 0) {
                    for (String user : users) {
                        Subject subject = new Subject();
                        SimplePrincipal principal = new SimplePrincipal(user);
                        char[] cred = this.workManager.getCallbackSecurity().getCredential(user);
                        String[] roles = this.workManager.getCallbackSecurity().getRoles(user);
                        GroupPrincipalCallback gpc = new GroupPrincipalCallback(subject, roles);
                        CallerPrincipalCallback cpc = new CallerPrincipalCallback(subject, (Principal)principal);
                        PasswordValidationCallback pvc = new PasswordValidationCallback(subject, principal.getName(), cred);
                        callbacks.add(gpc);
                        callbacks.add(cpc);
                        callbacks.add(pvc);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("No users defined");
                }
                Callback[] cb = new Callback[callbacks.size()];
                cbh.handle(callbacks.toArray(cb));
                Subject executionSubject = new Subject();
                Subject serviceSubject = null;
                securityContext.setupSecurityContext((CallbackHandler)cbh, executionSubject, serviceSubject);
                sc.getSubjectInfo().setAuthenticatedSubject(executionSubject);
            }
            catch (Throwable t) {
                log.securityContextSetupFailed(t.getMessage(), t);
                this.fireWorkContextSetupFailed(ctx);
                throw new WorkException(bundle.securityContextSetupFailed(t.getMessage()), t);
            }
        } else if (securityContext != null && this.workManager.getCallbackSecurity() == null) {
            log.securityContextSetupFailedCallbackSecurityNull();
            this.fireWorkContextSetupFailed(ctx);
            throw new WorkException(bundle.securityContextSetupFailedSinceCallbackSecurityWasNull());
        }
        this.fireWorkContextSetupComplete(ctx);
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().startWork(this.work, xid);
        }
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 3, this.work, null);
            this.workListener.workStarted(event);
        }
        if (trace) {
            log.trace("Started work " + this);
        }
    }

    protected void end() {
        Xid xid;
        ExecutionContext ctx;
        if (trace) {
            log.trace("Ending work " + this);
        }
        if ((ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class)) == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().endWork(this.work, xid);
        }
        if (trace) {
            log.trace("Ended work " + this);
        }
    }

    protected void cancel() {
        Xid xid;
        ExecutionContext ctx;
        if (trace) {
            log.trace("Cancel work " + this);
        }
        if ((ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class)) == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().cancelWork(this.work, xid);
        }
        if (trace) {
            log.trace("Canceled work " + this);
        }
    }

    public <T> T getWorkContext(Class<T> workContextClass) {
        T instance = null;
        if (this.workContexts != null && this.workContexts.containsKey(workContextClass)) {
            instance = workContextClass.cast(this.workContexts.get(workContextClass));
        }
        return instance;
    }

    public void addWorkContext(Class<? extends WorkContext> workContextClass, WorkContext workContext) {
        if (workContextClass == null) {
            throw new IllegalArgumentException("Work context class is null");
        }
        if (workContext == null) {
            throw new IllegalArgumentException("Work context is null");
        }
        if (this.workContexts == null) {
            this.workContexts = new HashMap<Class<? extends WorkContext>, WorkContext>(1);
        }
        if (trace) {
            log.tracef("Adding work context %s for %s", workContextClass, this);
        }
        this.workContexts.put(workContextClass, workContext);
    }

    private void fireWorkContextSetupComplete(Object workContext) {
        if (workContext != null && workContext instanceof WorkContextLifecycleListener) {
            if (trace) {
                log.tracef("WorkContextSetupComplete(%s) for %s", workContext, this);
            }
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupComplete();
        }
    }

    private void fireWorkContextSetupFailed(Object workContext) {
        if (workContext != null && workContext instanceof WorkContextLifecycleListener) {
            if (trace) {
                log.tracef("WorkContextSetupFailed(%s) for %s", workContext, this);
            }
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupFailed("3");
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append("[workManger=").append(this.workManager);
        buffer.append(" work=").append(this.work);
        if (this.executionContext != null && this.executionContext.getXid() != null) {
            buffer.append(" xid=").append(this.executionContext.getXid());
            buffer.append(" txTimeout=").append(this.executionContext.getTransactionTimeout());
        }
        buffer.append(" workListener=").append(this.workListener);
        buffer.append(" workContexts=").append(this.workContexts);
        buffer.append(" exception=").append((Object)this.exception);
        buffer.append("]");
        return buffer.toString();
    }
}

