/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.ant;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.tools.WSTools;
import org.jboss.ws.tools.ant.SysProperty;

public class wstools
extends MatchingTask {
    private static final ResourceBundle bundle = BundleUtils.getBundle(wstools.class);
    protected Path compileClasspath;
    private boolean verbose;
    private String dest;
    private String config;

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void addConfiguredSysproperty(SysProperty prop) {
        System.setProperty(prop.getKey(), prop.getValue());
    }

    public void execute() throws BuildException {
        ClassLoader prevCL = wstools.getContextClassLoader();
        wstools.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            String[] args = new String[]{"-dest", this.dest, "-config", this.config};
            WSTools tools = new WSTools();
            tools.generate(args);
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_RUNNING_JBOSSWS", (Object[])new Object[0]), (Throwable)ex, this.getLocation());
        }
        finally {
            wstools.setContextClassLoader(prevCL);
        }
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static ClassLoader setContextClassLoader(final ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            return result;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    try {
                        ClassLoader result = Thread.currentThread().getContextClassLoader();
                        if (cl != null) {
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        return result;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_SETTING_CONTEXT_CLASSLOADER", (Object[])new Object[0]), e);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_RUNNING_PRIVILEGED_ACTION", (Object[])new Object[0]), e.getCause());
        }
    }
}

