/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.util.Calendar;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.jboss.ws.extensions.security.exception.FailedCheckException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.metadata.wsse.TimestampVerification;
import org.w3c.dom.Document;

public class TimestampVerificationOperation {
    private static final ResourceBundle bundle = BundleUtils.getBundle(TimestampVerificationOperation.class);
    private static final Logger log = Logger.getLogger(TimestampVerificationOperation.class);
    private TimestampVerification timestampVerification;
    private Calendar now = null;

    public TimestampVerificationOperation(TimestampVerification timestampVerification) {
        this.timestampVerification = timestampVerification;
    }

    public TimestampVerificationOperation(Calendar now) {
        this.now = now;
    }

    public void process(Document message, Timestamp timestamp) throws WSSecurityException {
        boolean rejectExpires;
        Calendar now;
        Calendar expires = timestamp.getExpires();
        Calendar created = timestamp.getCreated();
        boolean rejectCreated = created.after(now = this.now == null ? Calendar.getInstance() : this.now);
        if (rejectCreated && this.timestampVerification != null && this.timestampVerification.getCreatedTolerance() > 0L) {
            Calendar tolerantCreatedNow = (Calendar)now.clone();
            tolerantCreatedNow.add(13, (int)this.timestampVerification.getCreatedTolerance());
            rejectCreated = created.after(tolerantCreatedNow);
            if (!rejectCreated && this.timestampVerification.isWarnCreated()) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CREATED_WITHIN_CONFIGURED_TOLERANCE", (Object[])new Object[0]));
            }
        }
        if (rejectCreated) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_TIMESTAMP", (Object[])new Object[0]));
        }
        boolean bl = rejectExpires = expires != null && !now.before(expires);
        if (rejectExpires && this.timestampVerification != null && this.timestampVerification.getExpiresTolerance() > 0L) {
            Calendar tolerantExpiresNow = (Calendar)now.clone();
            tolerantExpiresNow.add(13, (int)this.timestampVerification.getExpiresTolerance() * -1);
            boolean bl2 = rejectExpires = !tolerantExpiresNow.before(expires);
            if (!rejectExpires && this.timestampVerification.isWarnExpires()) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"EXPIRES_CONFIGURED_TOLERANCE", (Object[])new Object[0]));
            }
        }
        if (rejectExpires) {
            throw new FailedCheckException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"EXPIRED_MESSAGE", (Object[])new Object[0]));
        }
    }
}

