/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.STRTransform;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.SignatureKeysAssociation;
import org.jboss.ws.extensions.security.WsuIdResolver;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.SecurityProcess;
import org.jboss.ws.extensions.security.element.Signature;
import org.jboss.ws.extensions.security.exception.FailedCheckException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.DecodingOperation;
import org.w3c.dom.Document;

public class SignatureVerificationOperation
implements DecodingOperation {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SignatureVerificationOperation.class);
    private SecurityHeader header;
    private SecurityStore store;

    public SignatureVerificationOperation(SecurityHeader header, SecurityStore store) throws WSSecurityException {
        this.header = header;
        this.store = store;
    }

    @Override
    public Collection<String> process(Document message, SecurityProcess process) throws WSSecurityException {
        Signature signature = (Signature)process;
        XMLSignature xmlSig = signature.getSignature();
        xmlSig.addResourceResolver((ResourceResolverSpi)new WsuIdResolver(message));
        STRTransform.setSecurityStore(this.store);
        try {
            if (!xmlSig.checkSignatureValue((Key)signature.getPublicKey())) {
                throw new FailedCheckException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SIGNATURE_IS_INVALID", (Object[])new Object[0]));
            }
            SignatureKeysAssociation.saveKey(signature.getPublicKey());
        }
        catch (XMLSignatureException e) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ERROR", (Object[])new Object[0]), e);
        }
        finally {
            STRTransform.setSecurityStore(null);
        }
        SignedInfo info = xmlSig.getSignedInfo();
        int length = info.getLength();
        ArrayList<String> processed = new ArrayList<String>(length);
        try {
            for (int i = 0; i < length; ++i) {
                String uri = info.item(i).getURI();
                if (uri == null || uri.length() <= 1 || uri.charAt(0) != '#') continue;
                processed.add(uri.substring(1));
            }
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_EXTRACT_REFERENCES", (Object[])new Object[0]), e);
        }
        return processed;
    }
}

