/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.utils.ThreadLocalAssociation;
import org.jboss.ws.extensions.security.KeyResolver;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.SecurityTokenReference;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class STRTransform
extends TransformSpi {
    private static final ResourceBundle bundle = BundleUtils.getBundle(STRTransform.class);
    public static final String STR_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";

    private String canonicalize(Element element, Element method) throws TransformationException, InvalidCanonicalizerException, CanonicalizationException {
        if (method == null || !method.getLocalName().equals("CanonicalizationMethod")) {
            throw new TransformationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANONICALIZATIONMETHOD_EXPECTED", (Object[])new Object[0]));
        }
        String algorithm = method.getAttribute("Algorithm");
        if (algorithm == null || algorithm.length() == 0) {
            throw new TransformationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANONICALIZATIONMETHOD_MISSING_ALGORITHM", (Object[])new Object[0]));
        }
        Canonicalizer canon = Canonicalizer.getInstance((String)algorithm);
        return new String(canon.canonicalizeSubtree((Node)element, "#default"));
    }

    protected String engineGetURI() {
        return STR_URI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, Transform transformObject) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException, ParserConfigurationException, SAXException {
        return this.enginePerformTransform(input, null, transformObject);
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream os, Transform transformObject) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException, ParserConfigurationException, SAXException {
        SecurityStore store = ThreadLocalAssociation.localStrTransformAssoc().get();
        if (store == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"THREAD_LOCAL_NOT_INITIALIZED", (Object[])new Object[0]));
        }
        try {
            int endTag;
            int startTag;
            if (!input.isElement()) {
                throw new NotImplementedException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONLY_ELEMENT_INPUT_IS_SUPPORTED", (Object[])new Object[0]));
            }
            Element element = (Element)input.getSubNode();
            SecurityTokenReference ref = new SecurityTokenReference(element);
            KeyResolver resolver = new KeyResolver(store);
            BinarySecurityToken token = resolver.resolve(ref);
            element = token.getSTRTransformElement();
            Element parameters = XMLUtils.selectNode((Node)transformObject.getElement().getFirstChild(), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"TransformationParameters", (int)0);
            if (parameters == null) {
                throw new TransformationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"TRANSFORMATIONPARAMETERS_EXPECTED", (Object[])new Object[0]));
            }
            Element method = Util.getFirstChildElement(parameters);
            String transformed = this.canonicalize(element, method);
            String within = transformed.substring((startTag = transformed.indexOf(60)) + 1, endTag = transformed.indexOf(62, startTag + 1));
            if (!within.contains("xmlns=")) {
                int insPos = within.indexOf(" ") + startTag + 1;
                transformed = new StringBuilder(transformed).insert(insPos, " xmlns=\"\"").toString();
            }
            XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(transformed.getBytes());
            return xMLSignatureInput;
        }
        catch (WSSecurityException e) {
            throw new TransformationException(e.getMessage(), (Exception)e);
        }
        finally {
            ThreadLocalAssociation.localStrTransformAssoc().set(null);
        }
    }

    public static void setSecurityStore(SecurityStore store) {
        ThreadLocalAssociation.localStrTransformAssoc().set(store);
    }

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return false;
    }

    public boolean returnsOctetStream() {
        return false;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    static {
        try {
            Transform.register((String)STR_URI, (String)STRTransform.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

