/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.soap.attachment.AttachmentPartImpl;
import org.jboss.ws.core.soap.attachment.BoundaryDelimitedInputStream;
import org.jboss.ws.core.soap.attachment.SwapableMemoryDataSource;

public class MultipartRelatedDecoder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(MultipartRelatedDecoder.class);
    private ContentType contentType;
    private String rootType;
    private AttachmentPartImpl rootPart;
    private LinkedList<AttachmentPart> relatedParts = new LinkedList();

    public MultipartRelatedDecoder(ContentType contentType) throws IOException, MessagingException {
        this.contentType = contentType;
        if (!"multipart/related".equalsIgnoreCase(contentType.getBaseType())) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NON_MULTIPART_RELATED_TYPE", (Object[])new Object[0]));
        }
        this.rootType = contentType.getParameter("type");
        if (this.rootType == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MISSING_THE_ROOT_TYPE_PARAMETER", (Object[])new Object[0]));
        }
    }

    private boolean isValidRootType(String type) throws ParseException {
        ContentType contentType = new ContentType(type);
        type = contentType.getBaseType();
        return this.rootType.equals(type);
    }

    public void decodeMultipartRelatedMessage(InputStream stream) throws IOException, MessagingException {
        byte[] crlf;
        byte[] boundary;
        String boundaryParameter = this.contentType.getParameter("boundary");
        String start = this.contentType.getParameter("start");
        if (boundaryParameter == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_CONTAIN_A_BOUNDARY", (Object[])new Object[0]));
        }
        try {
            boundary = start == null ? ("--" + boundaryParameter).getBytes("US-ASCII") : ("\r\n--" + boundaryParameter).getBytes("US-ASCII");
            crlf = "\r\n".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"US_ASCII_NOT_SUPPORTED", (Object[])new Object[0]));
        }
        PushbackInputStream pushBackStream = new PushbackInputStream(stream, 2);
        pushBackStream.unread(crlf);
        BoundaryDelimitedInputStream delimitedStream = new BoundaryDelimitedInputStream(pushBackStream, boundary);
        byte[] buffer = new byte[256];
        while (delimitedStream.read(buffer) != -1) {
        }
        while (!delimitedStream.isOuterStreamClosed()) {
            if (!this.advanceToHeaders(delimitedStream)) continue;
            InternetHeaders headers = new InternetHeaders((InputStream)delimitedStream);
            String[] typeHeader = headers.getHeader("Content-Type");
            if (typeHeader == null) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONTENT_TYPE_MISSING", (Object[])new Object[0]));
            }
            SwapableMemoryDataSource source = new SwapableMemoryDataSource(delimitedStream, typeHeader[0]);
            AttachmentPartImpl part = new AttachmentPartImpl(new DataHandler((DataSource)source));
            Enumeration enumeration = headers.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                part.addMimeHeader(header.getName(), header.getValue());
            }
            if (this.rootPart == null && (start == null || start.equals(part.getContentId()))) {
                if (!this.isValidRootType(part.getContentType())) {
                    throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OTHER_THAN_THE_ONE_FOUND", (Object[])new Object[0]));
                }
                this.rootPart = part;
                continue;
            }
            this.relatedParts.add(part);
        }
        if (this.rootPart == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NO_ROOT_PART_WAS_FOUND", (Object[])new Object[0]));
        }
    }

    private boolean advanceToHeaders(InputStream stream) throws IOException {
        boolean dash = false;
        boolean cr = false;
        block6: while (true) {
            int b = stream.read();
            switch (b) {
                case -1: {
                    return false;
                }
                case 13: {
                    cr = true;
                    dash = false;
                    continue block6;
                }
                case 45: {
                    if (dash) {
                        stream.close();
                        return false;
                    }
                    dash = true;
                    cr = false;
                    continue block6;
                }
                case 10: {
                    if (cr) {
                        return true;
                    }
                    dash = false;
                    continue block6;
                }
            }
            dash = false;
            cr = false;
        }
    }

    public AttachmentPart getRootPart() {
        return this.rootPart;
    }

    public Collection<AttachmentPart> getRelatedParts() {
        return this.relatedParts;
    }
}

