/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.ResourceBundle;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.EndpointReference;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.HTTPRemotingConnection;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.client.SOAPProtocolConnectionHTTP;
import org.jboss.ws.core.soap.SOAPMessageImpl;

public class SOAPConnectionImpl
extends SOAPConnection {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SOAPConnectionImpl.class);
    private RemoteConnection remotingConnection = new SOAPProtocolConnectionHTTP();

    public SOAPMessage call(SOAPMessage reqMessage, Object endpoint) throws SOAPException {
        if (reqMessage == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOAPMESSAGE_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        MessageAbstraction resMessage = this.callInternal(reqMessage, endpoint, false);
        return (SOAPMessage)resMessage;
    }

    public SOAPMessage get(Object endpoint) throws SOAPException {
        MessageAbstraction resMessage = this.callInternal(null, endpoint, false);
        return (SOAPMessage)resMessage;
    }

    public SOAPMessage callOneWay(SOAPMessage reqMessage, Object endpoint) throws SOAPException {
        if (reqMessage == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOAPMESSAGE_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        MessageAbstraction resMessage = this.callInternal(reqMessage, endpoint, true);
        return (SOAPMessage)resMessage;
    }

    private RemoteConnection getRemotingConnection(Object endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        String targetAddress = null;
        if (endpoint instanceof EndpointInfo) {
            targetAddress = ((EndpointInfo)endpoint).getTargetAddress();
        } else if (endpoint instanceof EndpointReference) {
            EndpointReference epr = (EndpointReference)endpoint;
            targetAddress = epr.getAddress().toString();
        } else {
            targetAddress = endpoint.toString();
        }
        return this.remotingConnection;
    }

    public void close() throws SOAPException {
        if (this.remotingConnection != null && this.remotingConnection instanceof HTTPRemotingConnection) {
            HTTPRemotingConnection conn = (HTTPRemotingConnection)this.remotingConnection;
            if (conn.isClosed()) {
                throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOAPCONNECTION_IS_ALREADY_CLOSED", (Object[])new Object[0]));
            }
            conn.setClosed(true);
        }
    }

    private MessageAbstraction callInternal(SOAPMessage reqMessage, Object endpoint, boolean oneway) throws SOAPException {
        try {
            this.remotingConnection = this.getRemotingConnection(endpoint);
            MessageAbstraction resMessage = this.remotingConnection.invoke((SOAPMessageImpl)reqMessage, endpoint, oneway);
            return resMessage;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SOAPException) {
                throw (SOAPException)cause;
            }
            throw new SOAPException((Throwable)ex);
        }
    }
}

