/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.wsf.spi.management.ServerConfig;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLRequestHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSDLRequestHandler.class);
    private static Logger log = Logger.getLogger(WSDLRequestHandler.class);
    private final URL wsdlLocation;
    private final String wsdlPublishLoc;
    private final ServerConfig config;

    public WSDLRequestHandler(URL wsdlLocationFromMetadata, String wsdlPublishLocationFromMetadata, ServerConfig config) {
        this.wsdlLocation = wsdlLocationFromMetadata;
        this.wsdlPublishLoc = wsdlPublishLocationFromMetadata;
        this.config = config;
    }

    public Document getDocumentForPath(URL reqURL, String resPath) throws IOException {
        String wsdlHost = reqURL.getHost();
        boolean rewriteUsingCalledURL = "jbossws.undefined.host".equals(this.config.getWebServiceHost());
        if (!rewriteUsingCalledURL) {
            wsdlHost = this.config.getWebServiceHost();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("WSDL request, using host: " + wsdlHost));
        }
        return this.getDocumentForPath(reqURL, wsdlHost, rewriteUsingCalledURL, resPath);
    }

    protected InputStream openStreamToWSDL() throws IOException {
        return this.wsdlLocation.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocumentForPath(URL reqURL, String wsdlHost, boolean rewriteUsingCalledURL, String resPath) throws IOException {
        Document wsdlDoc;
        if (this.wsdlLocation == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_WSDL_LOCATION", (Object[])new Object[0]));
        }
        if (resPath == null) {
            InputStream is = null;
            try {
                is = this.openStreamToWSDL();
                Element wsdlElement = DOMUtils.parse((InputStream)is);
                wsdlDoc = wsdlElement.getOwnerDocument();
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        File wsdlLocFile = new File(this.wsdlLocation.getPath());
        String impResourcePath = wsdlLocFile.getParent() + File.separatorChar + resPath;
        File impResourceFile = new File(impResourcePath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Importing resource file: " + impResourceFile.getCanonicalPath()));
        }
        String wsdlLocFilePath = wsdlLocFile.getParentFile().getCanonicalPath();
        String wsdlDataLoc = this.config.getServerDataDir().getCanonicalPath() + File.separatorChar + "wsdl";
        String resourceAbsPath = impResourceFile.getCanonicalPath();
        if (resourceAbsPath.indexOf(wsdlLocFilePath) >= 0 || resourceAbsPath.indexOf(wsdlDataLoc) >= 0 || this.wsdlPublishLoc != null && resourceAbsPath.indexOf(new File(new URL(this.wsdlPublishLoc).getPath()).getCanonicalPath()) >= 0) {
            Element wsdlElement = DOMUtils.parse((InputStream)impResourceFile.toURL().openStream());
            wsdlDoc = wsdlElement.getOwnerDocument();
        } else {
            throw new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ACCESS_IS_NOT_ALLOWED", (Object[])new Object[]{resourceAbsPath}));
        }
        this.modifyAddressReferences(reqURL, wsdlHost, rewriteUsingCalledURL, resPath, wsdlDoc.getDocumentElement());
        return wsdlDoc;
    }

    private void modifyAddressReferences(URL reqURL, String wsdlHost, boolean rewriteUsingCalledURL, String resPath, Element element) throws IOException {
        NodeList nlist = element.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            String orgLocation;
            Attr locationAttr;
            Node childNode = nlist.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getLocalName();
            if ("import".equals(nodeName) || "include".equals(nodeName)) {
                boolean isAbsolute;
                locationAttr = childElement.getAttributeNode("schemaLocation");
                if (locationAttr == null) {
                    locationAttr = childElement.getAttributeNode("location");
                }
                if (locationAttr == null) continue;
                orgLocation = locationAttr.getNodeValue();
                while (orgLocation.startsWith("./")) {
                    orgLocation = orgLocation.substring(2);
                }
                boolean bl = isAbsolute = orgLocation.startsWith("http://") || orgLocation.startsWith("https://");
                if (isAbsolute || orgLocation.startsWith(reqURL.getPath())) continue;
                String newResourcePath = orgLocation;
                if (resPath != null && resPath.indexOf("/") > 0) {
                    String resParent = resPath.substring(0, resPath.lastIndexOf("/"));
                    if (orgLocation.startsWith("../") && resParent != null) {
                        while (orgLocation.startsWith("../") && resParent != null) {
                            if (resParent.endsWith("..")) {
                                newResourcePath = resParent + "/" + orgLocation;
                                resParent = null;
                                continue;
                            }
                            if (resParent.indexOf("/") > 0) {
                                resParent = resParent.substring(0, resParent.lastIndexOf("/"));
                                orgLocation = orgLocation.substring(3);
                                newResourcePath = resParent + "/" + orgLocation;
                                continue;
                            }
                            newResourcePath = orgLocation = orgLocation.substring(3);
                            resParent = null;
                        }
                    } else {
                        newResourcePath = resParent + "/" + orgLocation;
                    }
                }
                String reqPath = reqURL.getPath();
                String completeHost = wsdlHost;
                String reqProtocol = reqURL.getProtocol();
                int reqPort = rewriteUsingCalledURL ? reqURL.getPort() : this.getPortForProtocol(reqProtocol);
                String hostAndPort = wsdlHost + (reqPort > 0 ? ":" + reqPort : "");
                completeHost = reqProtocol + "://" + hostAndPort;
                String newLocation = completeHost + reqPath + "?wsdl&resource=" + newResourcePath;
                locationAttr.setNodeValue(newLocation);
                log.trace((Object)("Mapping import from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            if ("address".equals(nodeName)) {
                String path;
                int port;
                boolean rewriteLocation;
                locationAttr = childElement.getAttributeNode("location");
                if (locationAttr == null || !WSDLRequestHandler.isHttp(orgLocation = locationAttr.getNodeValue())) continue;
                URL orgURL = new URL(orgLocation);
                String orgProtocol = orgURL.getProtocol();
                String host = orgURL.getHost();
                boolean bl = rewriteLocation = "jbossws.undefined.host".equals(host) || this.config.isModifySOAPAddress();
                if (!rewriteLocation) continue;
                boolean confidential = "https".equalsIgnoreCase(orgProtocol);
                String reqProtocol = reqURL.getProtocol();
                String newLocation = new URL(confidential ? "https" : reqProtocol, wsdlHost, port = rewriteUsingCalledURL ? reqURL.getPort() : (confidential ? this.getPortForProtocol("https") : this.getPortForProtocol(reqProtocol)), path = orgURL.getPath()).toString();
                if (newLocation.equals(orgLocation)) continue;
                locationAttr.setNodeValue(newLocation);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Mapping address from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            this.modifyAddressReferences(reqURL, wsdlHost, rewriteUsingCalledURL, resPath, childElement);
        }
    }

    private static boolean isHttp(String orgLocation) {
        try {
            String scheme = new URI(orgLocation).getScheme();
            if (scheme != null && scheme.startsWith("http")) {
                return true;
            }
            log.info((Object)("Skipping rewrite of non-http address: " + orgLocation));
            return false;
        }
        catch (URISyntaxException e) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"SKIPPING_REWRITE_OF_INVALID_ADDRESS", (Object[])new Object[]{orgLocation}), (Throwable)e);
            return false;
        }
    }

    private int getPortForProtocol(String protocol) {
        String lowerCasedProtocol = protocol.toLowerCase();
        if ("http".equals(lowerCasedProtocol)) {
            return this.config.getWebServicePort();
        }
        if ("https".equals(lowerCasedProtocol)) {
            return this.config.getWebServiceSecurePort();
        }
        return -1;
    }
}

