/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointResolver;

public class PortComponentResolver
implements EndpointResolver {
    private static final ResourceBundle bundle = BundleUtils.getBundle(PortComponentResolver.class);
    private static final Logger log = Logger.getLogger(PortComponentResolver.class);
    private String pcLink;

    public PortComponentResolver(String pcref) {
        this.pcLink = pcref;
    }

    public Endpoint query(Iterator<Endpoint> endpoints) {
        Endpoint endpoint = null;
        String pcName = this.pcLink;
        int hashIndex = this.pcLink.indexOf("#");
        if (hashIndex > 0) {
            pcName = this.pcLink.substring(hashIndex + 1);
        }
        while (endpoints.hasNext()) {
            Endpoint auxEndpoint = endpoints.next();
            ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)auxEndpoint.getAttachment(ServerEndpointMetaData.class);
            if (!pcName.equals(sepMetaData.getPortComponentName())) continue;
            if (endpoint != null) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"MULTIPLE_SERVICE_ENDOINTS_FOUND", (Object[])new Object[]{this.pcLink}));
                endpoint = null;
                break;
            }
            endpoint = auxEndpoint;
        }
        return endpoint;
    }
}

