/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client.serviceref;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxrpc.client.serviceref.NativeServiceObjectFactoryJAXRPC;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public final class NativeServiceReferenceableJAXRPC
implements Referenceable {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NativeServiceReferenceableJAXRPC.class);
    public static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";
    public static final String SECURITY_CONFIG = "SECURITY_CONFIG";
    public static final String PORT_COMPONENT_LINK = "PORT_COMPONENT_LINK";
    public static final String PORT_COMPONENT_LINK_SERVLET = "PORT_COMPONENT_LINK_SERVLET";
    private UnifiedServiceRefMetaData refMetaData;
    private UnifiedVirtualFile vfsRoot;

    public NativeServiceReferenceableJAXRPC(UnifiedServiceRefMetaData refMetaData) {
        this.refMetaData = refMetaData;
        this.vfsRoot = refMetaData.getVfsRoot();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference myRef = new Reference(NativeServiceReferenceableJAXRPC.class.getName(), NativeServiceObjectFactoryJAXRPC.class.getName(), null);
        myRef.add(new BinaryRefAddr(SERVICE_REF_META_DATA, this.marshallServiceRef()));
        if (this.getSecurityConfig() != null) {
            myRef.add(new BinaryRefAddr(SECURITY_CONFIG, this.marshallSecurityConfig()));
        }
        for (UnifiedPortComponentRefMetaData pcr : this.refMetaData.getPortComponentRefs()) {
            String pcLink = pcr.getPortComponentLink();
            if (pcLink == null) continue;
            myRef.add(new StringRefAddr(PORT_COMPONENT_LINK, pcLink));
            try {
                SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
                ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
                String host = config.getWebServiceHost();
                int port = config.getWebServicePort();
                String servletURL = "http://" + host + ":" + port + "/jbossws/pclink";
                myRef.add(new StringRefAddr(PORT_COMPONENT_LINK_SERVLET, servletURL));
            }
            catch (Exception ex) {
                throw new NamingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_PATH", (Object[])new Object[]{ex}));
            }
        }
        return myRef;
    }

    private byte[] marshallServiceRef() throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.refMetaData);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_MARSHALL_SERVICE_REF_META_DATA", (Object[])new Object[]{e.toString()}));
        }
        return baos.toByteArray();
    }

    private byte[] marshallSecurityConfig() throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            WSSecurityConfiguration securityConfig = WSSecurityConfigFactory.newInstance().createConfiguration(this.refMetaData.getVfsRoot(), "jboss-wsse-client.xml");
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(securityConfig);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_MARSHALL_SECURITY_CONFIG", (Object[])new Object[]{e.toString()}));
        }
        return baos.toByteArray();
    }

    private URL getSecurityConfig() {
        UnifiedVirtualFile vfConfig;
        URL securityConfigURL = null;
        try {
            vfConfig = this.vfsRoot.findChild("WEB-INF/jboss-wsse-client.xml");
            securityConfigURL = vfConfig.toURL();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            vfConfig = this.vfsRoot.findChild("META-INF/jboss-wsse-client.xml");
            securityConfigURL = vfConfig.toURL();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return securityConfigURL;
    }
}

