/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.io.Serializable;
import org.jboss.arquillian.test.spi.ExceptionProxy;

public final class TestResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Status status;
    private transient Throwable throwable;
    private ExceptionProxy exceptionProxy;
    private long start;
    private long end;

    public TestResult() {
        this(null);
    }

    public TestResult(Status status) {
        this(status, null);
    }

    public TestResult(Status status, Throwable throwable) {
        this.status = status;
        this.setThrowable(throwable);
        this.start = System.currentTimeMillis();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Throwable getThrowable() {
        if (this.throwable == null && this.exceptionProxy != null) {
            this.throwable = this.exceptionProxy.createException();
        }
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.exceptionProxy = ExceptionProxy.createForException(throwable);
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getStart() {
        return this.start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public long getEnd() {
        return this.end;
    }

    public ExceptionProxy getExceptionProxy() {
        return this.exceptionProxy;
    }

    public String toString() {
        long time = this.end > 0L ? this.end - this.start : System.currentTimeMillis() - this.start;
        return "TestResult[status=" + (Object)((Object)this.status) + ",time=" + time + "ms]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PASSED,
        FAILED,
        SKIPPED;

    }
}

