/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ClientMode;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.metrics.DefaultMetricCollector;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.metrics.NoopMetricCollector;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.protocol.ascii.AsciiMemcachedNodeImpl;
import net.spy.memcached.protocol.ascii.AsciiOperationFactory;
import net.spy.memcached.protocol.binary.BinaryMemcachedNodeImpl;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;

public class DefaultConnectionFactory
extends SpyObject
implements ConnectionFactory {
    public static final ClientMode DEFAULT_CLIENT_MODE = ClientMode.Unset;
    public static final FailureMode DEFAULT_FAILURE_MODE = FailureMode.Redistribute;
    public static final HashAlgorithm DEFAULT_HASH = DefaultHashAlgorithm.NATIVE_HASH;
    public static final int DEFAULT_OP_QUEUE_LEN = 16384;
    public static final long DEFAULT_OP_QUEUE_MAX_BLOCK_TIME = TimeUnit.SECONDS.toMillis(10L);
    public static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    public static final long DEFAULT_OPERATION_TIMEOUT = 2500L;
    public static final long DEFAULT_MAX_RECONNECT_DELAY = 30L;
    public static final int DEFAULT_MAX_TIMEOUTEXCEPTION_THRESHOLD = 998;
    public static final MetricType DEFAULT_METRIC_TYPE = MetricType.OFF;
    public static final long DEFAULT_AUTH_WAIT_TIME = 1000L;
    private ClientMode clientMode;
    protected final int opQueueLen;
    private final int readBufSize;
    private final HashAlgorithm hashAlg;
    private MetricCollector metrics;
    private ExecutorService executorService;
    private SSLContext sslContext;
    private String hostnameForTlsVerification;
    private boolean skipTlsHostnameVerification;

    public DefaultConnectionFactory(ClientMode clientMode, int qLen, int bufSize, HashAlgorithm hash) {
        this.clientMode = clientMode;
        this.opQueueLen = qLen;
        this.readBufSize = bufSize;
        this.hashAlg = hash;
        this.metrics = null;
    }

    public DefaultConnectionFactory(int qLen, int bufSize, HashAlgorithm hash) {
        this(DEFAULT_CLIENT_MODE, qLen, bufSize, hash);
    }

    public DefaultConnectionFactory(ClientMode clientMode, int qLen, int bufSize) {
        this(clientMode, qLen, bufSize, DEFAULT_HASH);
    }

    public DefaultConnectionFactory(int qLen, int bufSize) {
        this(DEFAULT_CLIENT_MODE, qLen, bufSize, DEFAULT_HASH);
    }

    public DefaultConnectionFactory(ClientMode clientMode) {
        this(clientMode, 16384, 16384);
    }

    public DefaultConnectionFactory() {
        this(DEFAULT_CLIENT_MODE, 16384, 16384);
    }

    @Override
    public ClientMode getClientMode() {
        return this.clientMode;
    }

    @Override
    public void setClientMode(ClientMode clientMode) {
        this.clientMode = clientMode;
    }

    @Override
    public long getDynamicModePollingInterval() {
        return 60000L;
    }

    @Override
    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        OperationFactory of = this.getOperationFactory();
        boolean doAuth = false;
        if (this.getAuthDescriptor() != null) {
            doAuth = true;
        }
        if (of instanceof AsciiOperationFactory) {
            return new AsciiMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), (Long)this.getOpQueueMaxBlockTime(), doAuth, this.getOperationTimeout(), this.getAuthWaitTime(), (ConnectionFactory)this);
        }
        if (of instanceof BinaryOperationFactory) {
            return new BinaryMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), (Long)this.getOpQueueMaxBlockTime(), doAuth, this.getOperationTimeout(), this.getAuthWaitTime(), (ConnectionFactory)this);
        }
        throw new IllegalStateException("Unhandled operation factory type " + of);
    }

    @Override
    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        return new MemcachedConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
    }

    @Override
    public FailureMode getFailureMode() {
        return DEFAULT_FAILURE_MODE;
    }

    @Override
    public BlockingQueue<Operation> createOperationQueue() {
        return new ArrayBlockingQueue<Operation>(this.getOpQueueLen());
    }

    @Override
    public BlockingQueue<Operation> createReadOperationQueue() {
        return new LinkedBlockingQueue<Operation>();
    }

    @Override
    public BlockingQueue<Operation> createWriteOperationQueue() {
        return new LinkedBlockingQueue<Operation>();
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new ArrayModNodeLocator(nodes, this.getHashAlg());
    }

    public int getOpQueueLen() {
        return this.opQueueLen;
    }

    @Override
    public long getOpQueueMaxBlockTime() {
        return DEFAULT_OP_QUEUE_MAX_BLOCK_TIME;
    }

    @Override
    public long getAuthWaitTime() {
        return 1000L;
    }

    @Override
    public ExecutorService getListenerExecutorService() {
        if (this.executorService == null) {
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "FutureNotifyListener");
                }
            };
            this.executorService = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        }
        return this.executorService;
    }

    @Override
    public boolean isDefaultExecutorService() {
        return true;
    }

    @Override
    public int getReadBufSize() {
        return this.readBufSize;
    }

    @Override
    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    @Override
    public OperationFactory getOperationFactory() {
        return new AsciiOperationFactory();
    }

    @Override
    public long getOperationTimeout() {
        return 2500L;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public Collection<ConnectionObserver> getInitialObservers() {
        return Collections.emptyList();
    }

    @Override
    public Transcoder<Object> getDefaultTranscoder() {
        return new SerializingTranscoder();
    }

    @Override
    public boolean useNagleAlgorithm() {
        return false;
    }

    @Override
    public boolean getKeepAlive() {
        return false;
    }

    @Override
    public boolean shouldOptimize() {
        return false;
    }

    @Override
    public long getMaxReconnectDelay() {
        return 30L;
    }

    @Override
    public AuthDescriptor getAuthDescriptor() {
        return null;
    }

    @Override
    public int getTimeoutExceptionThreshold() {
        return 998;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public String getHostnameForTlsVerification() {
        return this.hostnameForTlsVerification;
    }

    @Override
    public boolean skipTlsHostnameVerification() {
        return this.skipTlsHostnameVerification;
    }

    @Override
    public MetricType enableMetrics() {
        String metricType = System.getProperty("net.spy.metrics.type");
        return metricType == null ? DEFAULT_METRIC_TYPE : MetricType.valueOf(metricType.toUpperCase());
    }

    @Override
    public MetricCollector getMetricCollector() {
        if (this.metrics != null) {
            return this.metrics;
        }
        String enableMetrics = System.getProperty("net.spy.metrics.enable");
        if (this.enableMetrics().equals((Object)MetricType.OFF) || enableMetrics == "false") {
            this.getLogger().debug("Metric collection disabled.");
            this.metrics = new NoopMetricCollector();
        } else {
            this.getLogger().info("Metric collection enabled (Profile " + (Object)((Object)this.enableMetrics()) + ").");
            this.metrics = new DefaultMetricCollector();
        }
        return this.metrics;
    }

    protected String getName() {
        return "DefaultConnectionFactory";
    }

    public String toString() {
        return "Failure Mode: " + this.getFailureMode().name() + ", Hash Algorithm: " + ((DefaultHashAlgorithm)this.getHashAlg()).name() + " Max Reconnect Delay: " + this.getMaxReconnectDelay() + ", Max Op Timeout: " + this.getOperationTimeout() + ", Op Queue Length: " + this.getOpQueueLen() + ", Op Max Queue Block Time" + this.getOpQueueMaxBlockTime() + ", Max Timeout Exception Threshold: " + this.getTimeoutExceptionThreshold() + ", Read Buffer Size: " + this.getReadBufSize() + ", Transcoder: " + this.getDefaultTranscoder() + ", Operation Factory: " + this.getOperationFactory() + " isDaemon: " + this.isDaemon() + ", Optimized: " + this.shouldOptimize() + ", Using Nagle: " + this.useNagleAlgorithm() + ", KeepAlive: " + this.getKeepAlive() + ", SSLContext: " + this.getSSLContext() + ", ConnectionFactory: " + this.getName();
    }
}

