/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.Objects;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5308)
public class ScoredValue<V>
implements Comparable<ScoredValue<V>> {
    private static final Object NO_VALUE = new Object();
    private final Double score;
    private final MultimapObjectWrapper<V> value;

    public static <V> ScoredValue<V> of(double score, V value) {
        return new ScoredValue<V>(score, new MultimapObjectWrapper<V>(value));
    }

    public static <V> ScoredValue<V> of(double score) {
        return new ScoredValue<Object>(score, new MultimapObjectWrapper<Object>(NO_VALUE));
    }

    @ProtoFactory
    public ScoredValue(Double score, MultimapObjectWrapper<V> wrappedValue) {
        this.score = score;
        this.value = wrappedValue;
    }

    @ProtoField(value=1)
    public Double score() {
        return this.score;
    }

    @ProtoField(value=2)
    public MultimapObjectWrapper<V> wrappedValue() {
        return this.value;
    }

    public V getValue() {
        return this.value.get();
    }

    public int hashCode() {
        return Objects.hash(this.value, this.score);
    }

    public boolean equals(Object entry) {
        if (this == entry) {
            return true;
        }
        if (entry == null || this.getClass() != entry.getClass()) {
            return false;
        }
        ScoredValue other = (ScoredValue)entry;
        return this.value.equals(other.value) && this.score.equals(other.score);
    }

    public String toString() {
        return "ScoredValue{score=" + this.score + ", value=" + this.value.toString() + "}";
    }

    @Override
    public int compareTo(ScoredValue<V> other) {
        if (this == other) {
            return 0;
        }
        int compare = Double.compare(this.score, other.score);
        if (compare == 0) {
            if (other.getValue() == NO_VALUE || this.getValue() == NO_VALUE) {
                return 0;
            }
            return this.value.compareTo(other.wrappedValue());
        }
        return compare;
    }
}

