/* CSS3Parser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. CSS3Parser.java */
package org.htmlunit.cssparser.parser.javacc;

import java.util.LinkedList;
import java.util.Locale;

import org.htmlunit.cssparser.dom.CSSValueImpl;
import org.htmlunit.cssparser.dom.Property;
import org.htmlunit.cssparser.parser.AbstractCSSParser;
import org.htmlunit.cssparser.parser.CSSParseException;
import org.htmlunit.cssparser.parser.LexicalUnit;
import org.htmlunit.cssparser.parser.LexicalUnitImpl;
import org.htmlunit.cssparser.parser.LexicalUnit.LexicalUnitType;
import org.htmlunit.cssparser.parser.Locatable;
import org.htmlunit.cssparser.parser.Locator;
import org.htmlunit.cssparser.parser.condition.AttributeCondition;
import org.htmlunit.cssparser.parser.condition.BeginHyphenAttributeCondition;
import org.htmlunit.cssparser.parser.condition.ClassCondition;
import org.htmlunit.cssparser.parser.condition.Condition;
import org.htmlunit.cssparser.parser.condition.IdCondition;
import org.htmlunit.cssparser.parser.condition.LangCondition;
import org.htmlunit.cssparser.parser.condition.NotPseudoClassCondition;
import org.htmlunit.cssparser.parser.condition.OneOfAttributeCondition;
import org.htmlunit.cssparser.parser.condition.PrefixAttributeCondition;
import org.htmlunit.cssparser.parser.condition.PseudoClassCondition;
import org.htmlunit.cssparser.parser.condition.SubstringAttributeCondition;
import org.htmlunit.cssparser.parser.condition.SuffixAttributeCondition;
import org.htmlunit.cssparser.parser.media.MediaQuery;
import org.htmlunit.cssparser.parser.media.MediaQueryList;
import org.htmlunit.cssparser.parser.selector.ChildSelector;
import org.htmlunit.cssparser.parser.selector.DescendantSelector;
import org.htmlunit.cssparser.parser.selector.DirectAdjacentSelector;
import org.htmlunit.cssparser.parser.selector.ElementSelector;
import org.htmlunit.cssparser.parser.selector.GeneralAdjacentSelector;
import org.htmlunit.cssparser.parser.selector.PseudoElementSelector;
import org.htmlunit.cssparser.parser.selector.Selector;
import org.htmlunit.cssparser.parser.selector.SelectorList;
import org.htmlunit.cssparser.parser.selector.SelectorListImpl;
import org.htmlunit.cssparser.parser.selector.SimpleSelector;
import org.htmlunit.cssparser.util.ParserUtils;

/**
 * @author David Schweinsberg
 * @author waldbaer
 * @author Ahmed Ashour
 * @author Ronald Brill
 */
public class CSS3Parser extends AbstractCSSParser implements CSS3ParserConstants {

    public CSS3Parser() {
        this((CharStream) null);
    }

    @Override
    public String getParserVersion() {
        return "http://www.w3.org/Style/CSS/";
    }

    protected String getGrammarUri()
    {
        return "http://www.w3.org/TR/WD-css3-syntax-20030813";
    }

//
// stylesheet
//  : [ CHARSET_SYM STRING ';' ]?
//    [S|CDO|CDC]* [ import [S|CDO|CDC]* ]*
//    [ [ ruleset | media | page | font_face ] [S|CDO|CDC]* ]*
//  ;
//
  final public void styleSheet() throws ParseException {
    try {
handleStartDocument();
      styleSheetRuleList();
      jj_consume_token(0);
    } finally {
handleEndDocument();
    }
}

  final public void styleSheetRuleList() throws ParseException {boolean ruleFound = false;
    label_1:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:
      case CDO:
      case CDC:{
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        jj_consume_token(S);
        break;
        }
      case CDO:{
        jj_consume_token(CDO);
        break;
        }
      case CDC:{
        jj_consume_token(CDC);
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CHARSET_SYM:{
      charsetRule();
      label_2:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:
        case CDO:
        case CDC:{
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        case CDO:{
          jj_consume_token(CDO);
          break;
          }
        case CDC:{
          jj_consume_token(CDC);
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    label_3:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case ATKEYWORD:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IMPORT_SYM:{
          importRule(ruleFound);
          break;
          }
        case AND:
        case ONLY:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:
        case DOT:
        case COLON:
        case ASTERISK:
        case LSQUARE:
        case HASH:
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case ATKEYWORD:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case AND:
          case ONLY:
          case INHERIT:
          case NONE:
          case FROM:
          case IDENT:
          case DOT:
          case COLON:
          case ASTERISK:
          case LSQUARE:
          case HASH:{
            styleRule();
            break;
            }
          case MEDIA_SYM:{
            mediaRule();
            break;
            }
          case PAGE_SYM:{
            pageRule();
            break;
            }
          case FONT_FACE_SYM:{
            fontFaceRule();
            break;
            }
          case ATKEYWORD:{
            unknownAtRule();
            break;
            }
          default:
            jj_la1[5] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
ruleFound = true;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[7] = jj_gen;
ParseException e = generateParseException();
        invalidRule();
Token t = getNextToken();

                boolean charsetProcessed = false;
                if (t.kind == CHARSET_SYM) {
                    t = getNextToken();
                    if (t.kind == S) {
                        t = getNextToken();
                        if (t.kind == STRING) {
                            t = getNextToken();
                            if (t.kind == SEMICOLON) {
                                getNextToken();
                                charsetProcessed = true;
                            }
                        }
                    }
                    CSSParseException cpe = toCSSParseException("misplacedCharsetRule", e);
                    getErrorHandler().error(cpe);
                    getErrorHandler().warning(createSkipWarning("ignoringRule", cpe));
                }

                if (!charsetProcessed) {
                    if (t.kind == EOF) {
                        return;
                    }

                    CSSParseException cpe = toCSSParseException("invalidRule", e);
                    getErrorHandler().error(cpe);
                    getErrorHandler().warning(createSkipWarning("ignoringRule", cpe));
                    while (t.kind != RBRACE && t.kind != EOF ) {
                        t = getNextToken();
                    }
                    if (t.kind == EOF) {
                        return;
                    }
                }
      }
      label_4:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:
        case CDO:
        case CDC:{
          break;
          }
        default:
          jj_la1[8] = jj_gen;
          break label_4;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        case CDO:{
          jj_consume_token(CDO);
          break;
          }
        case CDC:{
          jj_consume_token(CDC);
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
}

  void invalidRule() throws ParseException {
  }

//
// This is used by ASTStyleSheet.insertRule to parse a single rule
//
  final public void styleSheetRuleSingle() throws ParseException {
    label_5:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_5;
      }
      jj_consume_token(S);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CHARSET_SYM:{
      charsetRule();
      break;
      }
    case IMPORT_SYM:{
      importRule(false);
      break;
      }
    case AND:
    case ONLY:
    case INHERIT:
    case NONE:
    case FROM:
    case IDENT:
    case DOT:
    case COLON:
    case ASTERISK:
    case LSQUARE:
    case HASH:{
      styleRule();
      break;
      }
    case MEDIA_SYM:{
      mediaRule();
      break;
      }
    case PAGE_SYM:{
      pageRule();
      break;
      }
    case FONT_FACE_SYM:{
      fontFaceRule();
      break;
      }
    case ATKEYWORD:{
      unknownAtRule();
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_6:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
      jj_consume_token(S);
    }
}

  final public void charsetRule() throws ParseException {Token t;
  Locator locator;
    try {
      jj_consume_token(CHARSET_SYM);
locator = createLocator(token);
      jj_consume_token(S);
      t = jj_consume_token(STRING);
      jj_consume_token(SEMICOLON);
handleCharset(t.toString(), locator);
    } catch (ParseException e) {
getErrorHandler().error(toCSSParseException("invalidCharsetRule", e));
    }
}

  final public void unknownAtRule() throws ParseException {String s;
    Locator locator;
    try {
      jj_consume_token(ATKEYWORD);
locator = createLocator(token);
            s = skip();
            handleIgnorableAtRule(s, locator);
    } catch (ParseException e) {
getErrorHandler().error(toCSSParseException("invalidUnknownRule", generateParseException()));
    }
}

//
// import
//  : IMPORT_SYM S*
//    [STRING|URI] S* [ medium [ COMMA S* medium]* ]? ';' S*
//  ;
//
  final public void importRule(final boolean nonImportRuleFoundBefore) throws ParseException {Token t;
    MediaQueryList ml = new MediaQueryList();
    Locator locator;
    try {
ParseException e = null;
            if (nonImportRuleFoundBefore)
            {
                e = generateParseException();
            }
      jj_consume_token(IMPORT_SYM);
locator = createLocator(token);
      label_7:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          break label_7;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING:{
        t = jj_consume_token(STRING);
        break;
        }
      case URI:{
        t = jj_consume_token(URI);
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_8:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[15] = jj_gen;
          break label_8;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NOT:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case LROUND:{
        mediaList(ml);
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
if (nonImportRuleFoundBefore)
            {
                getErrorHandler().error(toCSSParseException("invalidImportRuleIgnored2", e));
            }
            else
            {
                handleImportStyle(unescape(t.image, false), ml, null, locator);
            }
    } catch (CSSParseException e) {
getErrorHandler().error(e);
        error_skipAtRule();
    } catch (ParseException e) {
getErrorHandler().error(toCSSParseException("invalidImportRule", e));
        error_skipAtRule();
    }
}

//
// media
//  : MEDIA_SYM S* medium [ COMMA S* medium ]* '{' S* ruleset* '}' S*
//  ;
//
  final public void mediaRule() throws ParseException {boolean start = false;
    MediaQueryList ml = new MediaQueryList();
    Locator locator;
    try {
      jj_consume_token(MEDIA_SYM);
locator = createLocator(token);
      label_9:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          break label_9;
        }
        jj_consume_token(S);
      }
      mediaList(ml);
start = true;
            handleStartMedia(ml, locator);
      jj_consume_token(LBRACE);
      label_10:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case ATKEYWORD:{
        mediaRuleList();
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (CSSParseException e) {
getErrorHandler().error(e);
        error_skipblock("ignoringRule", e);
    } catch (ParseException e) {
CSSParseException cpe = toCSSParseException("invalidMediaRule", e);
        getErrorHandler().error(cpe);
        error_skipblock("ignoringRule", cpe);
    } finally {
if (start) {
            handleEndMedia(ml);
        }
    }
}

  final public void mediaList(MediaQueryList ml) throws ParseException {MediaQuery mq;
    try {
      mq = mediaQuery();
ml.setLocator(createLocator(token));
      label_11:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[20] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        label_12:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[21] = jj_gen;
            break label_12;
          }
          jj_consume_token(S);
        }
ml.add(mq);
        mq = mediaQuery();
      }
ml.add(mq);
    } catch (ParseException e) {
throw toCSSParseException("invalidMediaList", e);
    }
}

//
// media_query
//   : [ONLY | NOT]? S* media_type S* [ AND S* expression ]*
//   | expression [ AND S* expression ]*
//   ;
//
  final public MediaQuery mediaQuery() throws ParseException {String s;
    MediaQuery mq;
    Property p;
    boolean only = false;
    boolean not = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NOT:
    case ONLY:
    case INHERIT:
    case NONE:
    case FROM:
    case IDENT:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NOT:
      case ONLY:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ONLY:{
          jj_consume_token(ONLY);
only = true;
          break;
          }
        case NOT:{
          jj_consume_token(NOT);
not = true;
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_13:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[23] = jj_gen;
            break label_13;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      s = medium();
mq = new MediaQuery(s, only, not); mq.setLocator(createLocator(token));
      label_14:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case AND:{
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          break label_14;
        }
        jj_consume_token(AND);
        label_15:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[26] = jj_gen;
            break label_15;
          }
          jj_consume_token(S);
        }
        p = mediaExpression();
mq.addMediaProperty(p);
      }
      break;
      }
    case LROUND:{
      p = mediaExpression();
mq = new MediaQuery(null, only, not);
          mq.setLocator(createLocator(token));
          mq.addMediaProperty(p);
      label_16:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case AND:{
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          break label_16;
        }
        jj_consume_token(AND);
        label_17:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[28] = jj_gen;
            break label_17;
          }
          jj_consume_token(S);
        }
        p = mediaExpression();
mq.addMediaProperty(p);
      }
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return mq;
}

//
// expression
//   : '(' S* media_feature S* [ ':' S* expr ]? ')' S*
//   ;
//
  final public Property mediaExpression() throws ParseException {String p;
  LexicalUnit e = null;
  Property prop;
  Token t;
    jj_consume_token(LROUND);
    label_18:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_18;
      }
      jj_consume_token(S);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERIT:
    case NONE:
    case FROM:
    case IDENT:{
      t = identExcludingOnly();
      label_19:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
p = unescape(t.image, false);
      break;
      }
    case CUSTOM_PROPERTY_NAME:{
      t = jj_consume_token(CUSTOM_PROPERTY_NAME);
      label_20:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[32] = jj_gen;
          break label_20;
        }
        jj_consume_token(S);
      }
p = unescape(t.image, false);
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      label_21:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          break label_21;
        }
        jj_consume_token(S);
      }
      e = expr();
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    jj_consume_token(RROUND);
    label_22:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        break label_22;
      }
      jj_consume_token(S);
    }
if(e==null)
        {
          prop = new Property(p, null, false);
        }
        else
        {
          prop = new Property(p, new CSSValueImpl(e), false);
        }
        return prop;
}

  final public void mediaRuleList() throws ParseException {
    label_23:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:{
        styleRule();
        break;
        }
      case MEDIA_SYM:{
        mediaRule();
        break;
        }
      case PAGE_SYM:{
        pageRule();
        break;
        }
      case IMPORT_SYM:{
        importRule(true);
        break;
        }
      case ATKEYWORD:{
        unknownAtRule();
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_24:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          break label_24;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case ATKEYWORD:{
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_23;
      }
    }
}

//
// medium
//   : IDENT S*
//   ;
//
  final public String medium() throws ParseException {Token t;
    t = identExcludingOnly();
    label_25:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        break label_25;
      }
      jj_consume_token(S);
    }
return unescape(t.image, false);
}

//
// page
//  : PAGE_SYM S* pseudo_page? S*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void pageRule() throws ParseException {String sel = null;
    boolean start = false;
    Locator locator;
    try {
      jj_consume_token(PAGE_SYM);
locator = createLocator(token);
      label_26:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[41] = jj_gen;
          break label_26;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case COLON:{
        sel = pageSelectorList();
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_27:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[43] = jj_gen;
          break label_27;
        }
        jj_consume_token(S);
      }
start = true;
            handleStartPage(null, sel, locator);
      styleDeclaration();
      jj_consume_token(RBRACE);
    } catch (CSSParseException e) {
getErrorHandler().error(e);
        error_skipblock("ignoringRule", e);
    } catch (ParseException e) {
CSSParseException cpe = toCSSParseException("invalidPageRule", e);
        getErrorHandler().error(cpe);
        error_skipblock("ignoringRule", cpe);
    } finally {
if (start) {
            handleEndPage(null, sel);
        }
    }
}

//
// pageSelectorList
//   : [ pageSelector S* [ ',' pageSelector S* ]* ]?
//   ;
//
  final public String pageSelectorList() throws ParseException {String sel;
  LinkedList<String> selectors = new LinkedList<>();
    sel = pageSelector();
selectors.add(sel);
    label_28:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_28;
      }
      jj_consume_token(COMMA);
      label_29:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[45] = jj_gen;
          break label_29;
        }
        jj_consume_token(S);
      }
      sel = pageSelector();
selectors.add(sel);
    }
return String.join(", ", selectors);
}

//
// pageSelector
//   : pseudoPage+ | IDENT pseudoPage*
//   ;
//
  final public String pageSelector() throws ParseException {StringBuilder pseudos = new StringBuilder();
  String pseudo;
  Token ident;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      pseudo = pseudoPage();
pseudos.append(pseudo);
      break;
      }
    case AND:
    case ONLY:
    case INHERIT:
    case NONE:
    case FROM:
    case IDENT:{
      ident = ident();
pseudos.append(unescape(ident.image, false));
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_30:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        break label_30;
      }
      pseudo = pseudoPage();
pseudos.append(pseudo);
    }
    label_31:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        break label_31;
      }
      jj_consume_token(S);
    }
return pseudos.toString();
}

//
// pseudoPage
//   : ':' IDENT
//   ;
//
  final public String pseudoPage() throws ParseException {Token t;
    jj_consume_token(COLON);
    t = ident();
return ":" + normalizeAndValidatePagePseudoClass(t);
}

//
// font_face
//  : FONT_FACE_SYM S*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void fontFaceRule() throws ParseException {boolean start = false;
    Locator locator;
    try {
      jj_consume_token(FONT_FACE_SYM);
locator = createLocator(token);
      label_32:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[49] = jj_gen;
          break label_32;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_33:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[50] = jj_gen;
          break label_33;
        }
        jj_consume_token(S);
      }
start = true; handleStartFontFace(locator);
      styleDeclaration();
      jj_consume_token(RBRACE);
    } catch (ParseException e) {
throw toCSSParseException("invalidFontFaceRule", e);
    } finally {
if (start) {
            handleEndFontFace();
        }
    }
}

//
// operator
//  : '/' S* | COMMA S* | /* empty */
//  ;
//
  final public LexicalUnit operator(LexicalUnit prev) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SLASH:{
      jj_consume_token(SLASH);
      label_34:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
return new LexicalUnitImpl(prev, LexicalUnitType.OPERATOR_SLASH);
      }
    case COMMA:{
      jj_consume_token(COMMA);
      label_35:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          break label_35;
        }
        jj_consume_token(S);
      }
return LexicalUnitImpl.createComma(prev);
      }
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

//
// combinator
//  : PLUS S*
//  | GREATER S*
//  | S
//  ;
//
  final public char combinator() throws ParseException {char c = ' ';
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PLUS:{
      jj_consume_token(PLUS);
c='+';
      label_36:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[54] = jj_gen;
          break label_36;
        }
        jj_consume_token(S);
      }
      break;
      }
    case GREATER:{
      jj_consume_token(GREATER);
c='>';
      label_37:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_37;
        }
        jj_consume_token(S);
      }
      break;
      }
    case TILDE:{
      jj_consume_token(TILDE);
c='~';
      label_38:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[56] = jj_gen;
          break label_38;
        }
        jj_consume_token(S);
      }
      break;
      }
    case S:{
      jj_consume_token(S);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:
      case GREATER:
      case TILDE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PLUS:{
          jj_consume_token(PLUS);
c='+';
          break;
          }
        case GREATER:{
          jj_consume_token(GREATER);
c='>';
          break;
          }
        case TILDE:{
          jj_consume_token(TILDE);
c='~';
          break;
          }
        default:
          jj_la1[57] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_39:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[58] = jj_gen;
            break label_39;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return c;
}

//
// unary_operator
//  : '-' | PLUS
//  ;
//
  final public char unaryOperator() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
return '-';
      }
    case PLUS:{
      jj_consume_token(PLUS);
return '+';
      }
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

//
// ruleset
//  : selector [ COMMA S* selector ]*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void styleRule() throws ParseException {SelectorList selList = null;
    boolean start = false;
    Token t;
    try {
t = token;
      selList = selectorList();
      jj_consume_token(LBRACE);
      label_40:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[62] = jj_gen;
          break label_40;
        }
        jj_consume_token(S);
      }
start = true;
            handleStartSelector(selList, createLocator(t.next));
      styleDeclaration();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RBRACE:{
        jj_consume_token(RBRACE);
        break;
        }
      case 0:{
        jj_consume_token(0);
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (CSSParseException e) {
getErrorHandler().error(e);
        error_skipblock("ignoringRule", e);
    } catch (ParseException e) {
CSSParseException cpe = toCSSParseException("invalidStyleRule", e);
        getErrorHandler().error(cpe);
        error_skipblock("ignoringFollowingDeclarations", cpe);
    } finally {
if (start) {
            handleEndSelector(selList);
        }
    }
}

  final public SelectorList parseSelectorsInternal() throws ParseException {SelectorList selectors;
    label_41:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        break label_41;
      }
      jj_consume_token(S);
    }
    selectors = selectorList();
    jj_consume_token(0);
return selectors;
}

  final public SelectorList selectorList() throws ParseException {SelectorListImpl selList = new SelectorListImpl();
    Selector sel;
    sel = selector();
selList.setLocator(sel.getLocator());
    label_42:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        break label_42;
      }
      jj_consume_token(COMMA);
      label_43:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          break label_43;
        }
        jj_consume_token(S);
      }
selList.add(sel);
      sel = selector();
selList.setLocator(sel.getLocator());
    }
selList.add(sel);
        return selList;
}

//
// selector
//   : simple_selector_sequence [ combinator simple_selector_sequence ]*
//   ;
//
  final public Selector selector() throws ParseException {Selector sel;
    char comb;
    try {
      sel = simpleSelector(null, ' ');
      label_44:
      while (true) {
        if (jj_2_1(2)) {
        } else {
          break label_44;
        }
        comb = combinator();
        sel = simpleSelector(sel, comb);
      }
      label_45:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          break label_45;
        }
        jj_consume_token(S);
      }
return sel;    } catch (ParseException e) {
throw toCSSParseException("invalidSelector", e);
    }
}

//
// simple_selector
//  : element_name [ HASH | class | attrib | pseudo ]*
//  | [ HASH | class | attrib | pseudo ]+
//  ;
//
  final public Selector simpleSelector(Selector sel, char comb) throws ParseException {ElementSelector elemSel = null;
    SimpleSelector simpleSel = null;
    Condition c = null;
    SimpleSelector pseudoElementSel = null;
    Object o = null;
    try {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case ASTERISK:{
        elemSel = elementName();
        label_46:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DOT:
          case COLON:
          case LSQUARE:
          case HASH:{
            break;
            }
          default:
            jj_la1[68] = jj_gen;
            break label_46;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case HASH:{
            c = hash(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case DOT:{
            c = _class(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case LSQUARE:{
            c = attrib(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case COLON:{
            o = pseudo(null != pseudoElementSel);
if (o instanceof Condition)
                      {  elemSel.addCondition((Condition) o);
                      } else {
                        pseudoElementSel = (SimpleSelector) o;
                      }
            break;
            }
          default:
            jj_la1[69] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case DOT:
      case COLON:
      case LSQUARE:
      case HASH:{
elemSel = new ElementSelector(null, createLocator(token));
        label_47:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case HASH:{
            c = hash(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case DOT:{
            c = _class(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case LSQUARE:{
            c = attrib(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case COLON:{
            o = pseudo(null != pseudoElementSel);
if (o instanceof Condition)
                      { elemSel.addCondition((Condition) o);
                      } else {
                        pseudoElementSel = (SimpleSelector) o;
                      }
            break;
            }
          default:
            jj_la1[70] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DOT:
          case COLON:
          case LSQUARE:
          case HASH:{
            break;
            }
          default:
            jj_la1[71] = jj_gen;
            break label_47;
          }
        }
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
simpleSel = elemSel;
            if (sel == null) {
                sel = simpleSel;
            } else {
                switch (comb) {
                case ' ':
                    sel = new DescendantSelector(sel, simpleSel);
                    break;
                case '+':
                    sel = new DirectAdjacentSelector(sel, simpleSel);
                    break;
                case '>':
                    sel = new ChildSelector(sel, simpleSel);
                    break;
                case '~':
                    sel = new GeneralAdjacentSelector(sel, simpleSel);
                    break;
                }
            }
            if (pseudoElementSel != null)
            {
                sel = new DescendantSelector(sel, pseudoElementSel);
            }

            return sel;    } catch (ParseException e) {
throw toCSSParseException("invalidSimpleSelector", e);
    }
}

//
// class
//   : '.' IDENT
//   ;
//
  final public Condition _class(boolean pseudoElementFound) throws ParseException {Token t;
    Locator locator;
    ParseException pe = null;
    try {
if (pseudoElementFound) { pe = generateParseException(); }
      jj_consume_token(DOT);
locator = createLocator(token);
      t = ident();
if (pseudoElementFound) { throw pe; }
            return new ClassCondition(unescape(t.image, false), locator);    } catch (ParseException e) {
throw toCSSParseException("invalidClassSelector", e);
    }
}

//
// element_name
//   : IDENT | '*'
//   ;
//
  final public ElementSelector elementName() throws ParseException {Token t;
    try {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
return new ElementSelector(unescape(t.image, false), createLocator(t));
        }
      case ASTERISK:{
        jj_consume_token(ASTERISK);
return new ElementSelector(null, createLocator(token));
        }
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
throw toCSSParseException("invalidElementName", e);
    }
}

//
// attrib
//   : '[' S* IDENT S* [ [ '=' | INCLUDES | DASHMATCH | PREFIXMATCH | SUFFIXMATCH | SUBSTRINGMATCH ] S*
//     [ IDENT | STRING ] S* ]? ']'
//   ;
//
  final public Condition attrib(boolean pseudoElementFound) throws ParseException {Token t;
    String name = null;
    String value = null;
    Boolean insensitive = null;
    int type = 0;
    Locator locator;
    try {
      jj_consume_token(LSQUARE);
locator = createLocator(token);
      label_48:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[74] = jj_gen;
          break label_48;
        }
        jj_consume_token(S);
      }
if (pseudoElementFound) { throw generateParseException(); }
      t = ident();
name = unescape(t.image, false);
      label_49:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[75] = jj_gen;
          break label_49;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INCLUDES:
      case DASHMATCH:
      case PREFIXMATCH:
      case SUFFIXMATCH:
      case SUBSTRINGMATCH:
      case EQUALS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PREFIXMATCH:{
          jj_consume_token(PREFIXMATCH);
type = 4;
          break;
          }
        case SUFFIXMATCH:{
          jj_consume_token(SUFFIXMATCH);
type = 5;
          break;
          }
        case SUBSTRINGMATCH:{
          jj_consume_token(SUBSTRINGMATCH);
type = 6;
          break;
          }
        case EQUALS:{
          jj_consume_token(EQUALS);
type = 1;
          break;
          }
        case INCLUDES:{
          jj_consume_token(INCLUDES);
type = 2;
          break;
          }
        case DASHMATCH:{
          jj_consume_token(DASHMATCH);
type = 3;
          break;
          }
        default:
          jj_la1[76] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_50:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[77] = jj_gen;
            break label_50;
          }
          jj_consume_token(S);
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case AND:
        case ONLY:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:{
          t = ident();
value = unescape(t.image, false);
          break;
          }
        case STRING:{
          t = jj_consume_token(STRING);
value = unescape(t.image, false);
          break;
          }
        default:
          jj_la1[78] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_51:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[79] = jj_gen;
            break label_51;
          }
          jj_consume_token(S);
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case AND:
        case ONLY:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:{
          t = ident();
insensitive = handleCaseInSensitive(t);
          label_52:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[80] = jj_gen;
              break label_52;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        ;
      }
      jj_consume_token(RSQUARE);
Condition c = null;
            switch (type) {
            case 0:
                c = new AttributeCondition(name, null, insensitive);
                break;
            case 1:
                c = new AttributeCondition(name, value, insensitive);
                break;
            case 2:
                c = new OneOfAttributeCondition(name, value, insensitive);
                break;
            case 3:
                c = new BeginHyphenAttributeCondition(name, value, insensitive);
                break;
            case 4:
                c = new PrefixAttributeCondition(name, value, insensitive);
                break;
            case 5:
                c = new SuffixAttributeCondition(name, value, insensitive);
                break;
            case 6:
                c = new SubstringAttributeCondition(name, value, insensitive);
                break;
            }
            c.setLocator(locator);
            return c;    } catch (ParseException e) {
throw toCSSParseException("invalidAttrib", e);
    }
}

//
// pseudo
//  : ':' (':')?
//        [ IDENT
//          | FUNCTION_NOT S* selector() S* ')'
//          | FUNCTION_LANG S* IDENT S* ')'
//          | FUNCTION S* ((PLUS | MINUS | DIMENSION | NUMBER | STRING | IDENT)? S*)+ ')'
//        ]
//  ;
//
  final public Object pseudo(boolean pseudoElementFound) throws ParseException {Token t;
    String function;
    boolean doubleColon = false;
    SelectorList selectorList;
    Locator locator;
    try {
      jj_consume_token(COLON);
locator = createLocator(token);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
doubleColon = true;
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
String s = unescape(t.image, false);
                if (pseudoElementFound) { throw toCSSParseException("duplicatePseudo", new String[] { s }, locator); }
                if ("first-line".equals(s)
                    || "first-letter".equals(s)
                    || "before".equals(s)
                    || "after".equals(s))
                {
                    return new PseudoElementSelector(s, locator, doubleColon);                }
                return new PseudoClassCondition(s, locator, doubleColon);
        }
      case FUNCTION_NOT:{
        t = jj_consume_token(FUNCTION_NOT);
function = unescape(t.image, false);
        label_53:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[84] = jj_gen;
            break label_53;
          }
          jj_consume_token(S);
        }
        selectorList = selectorList();
        jj_consume_token(RROUND);
if (pseudoElementFound) { throw toCSSParseException("duplicatePseudo", new String[] { function + selectorList + ")" }, locator); }
                    return new NotPseudoClassCondition(selectorList, locator, doubleColon);
        }
      case FUNCTION_LANG:{
        t = jj_consume_token(FUNCTION_LANG);
function = unescape(t.image, false);
        label_54:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[85] = jj_gen;
            break label_54;
          }
          jj_consume_token(S);
        }
        t = ident();
String lang = unescape(t.image, false);
        label_55:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[86] = jj_gen;
            break label_55;
          }
          jj_consume_token(S);
        }
        jj_consume_token(RROUND);
if (pseudoElementFound) { throw toCSSParseException("duplicatePseudo", new String[] { "lang(" + lang + ")" }, locator); }
                    return new LangCondition(lang, locator);
        }
      case FUNCTION:{
        t = jj_consume_token(FUNCTION);
function = unescape(t.image, false); StringBuilder args = new StringBuilder();
        label_56:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[87] = jj_gen;
            break label_56;
          }
          jj_consume_token(S);
        }
        label_57:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case PLUS:{
            t = jj_consume_token(PLUS);
            break;
            }
          case MINUS:{
            t = jj_consume_token(MINUS);
            break;
            }
          case DIMENSION:{
            t = jj_consume_token(DIMENSION);
            break;
            }
          case NUMBER:{
            t = jj_consume_token(NUMBER);
            break;
            }
          case STRING:{
            t = jj_consume_token(STRING);
            break;
            }
          case AND:
          case ONLY:
          case INHERIT:
          case NONE:
          case FROM:
          case IDENT:{
            t = ident();
            break;
            }
          default:
            jj_la1[88] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
args.append(unescape(t.image, false));
          label_58:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[89] = jj_gen;
              break label_58;
            }
            t = jj_consume_token(S);
args.append(unescape(t.image, false));
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case AND:
          case ONLY:
          case NUMBER:
          case INHERIT:
          case NONE:
          case FROM:
          case IDENT:
          case STRING:
          case MINUS:
          case PLUS:
          case DIMENSION:{
            break;
            }
          default:
            jj_la1[90] = jj_gen;
            break label_57;
          }
        }
        jj_consume_token(RROUND);
if (pseudoElementFound) { throw toCSSParseException("duplicatePseudo", new String[] { function + args.toString().trim() + ")" }, locator); }
                    return new PseudoClassCondition(function + args.toString().trim() + ")", locator, doubleColon);
        }
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
throw toCSSParseException("invalidPseudo", e);
    }
}

  final public Condition hash(boolean pseudoElementFound) throws ParseException {Token t;
    ParseException pe = null;
    try {
if (pseudoElementFound) { pe = generateParseException(); }
      t = jj_consume_token(HASH);
if (pseudoElementFound) { throw pe; }
            return new IdCondition(unescape(t.image.substring(1), false), createLocator(t));    } catch (ParseException e) {
throw toCSSParseException("invalidHash", e);
    }
}

  final public void styleDeclaration() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AND:
    case ONLY:
    case INHERIT:
    case NONE:
    case FROM:
    case IDENT:
    case ASTERISK:
    case CUSTOM_PROPERTY_NAME:{
      declaration();
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      ;
    }
    label_59:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SEMICOLON:{
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        break label_59;
      }
      jj_consume_token(SEMICOLON);
      label_60:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[94] = jj_gen;
          break label_60;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case ASTERISK:
      case CUSTOM_PROPERTY_NAME:{
        declaration();
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        ;
      }
    }
}

//
// declaration
//   : property ':' S* expr prio?
//   |
//   ;
//
  final public void declaration() throws ParseException {String p;
  LexicalUnit e = null;
  Token t;
  boolean priority = false;
  Locator starHack = null;
  Locator locator = null;
    try {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASTERISK:{
        jj_consume_token(ASTERISK);
starHack = createLocator(token);
        break;
        }
      default:
        jj_la1[96] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
p = unescape(t.image, false); locator = createLocator(t);
        label_61:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[97] = jj_gen;
            break label_61;
          }
          jj_consume_token(S);
        }
        jj_consume_token(COLON);
        label_62:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[98] = jj_gen;
            break label_62;
          }
          jj_consume_token(S);
        }
        e = expr();
        break;
        }
      case CUSTOM_PROPERTY_NAME:{
        t = jj_consume_token(CUSTOM_PROPERTY_NAME);
        label_63:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[99] = jj_gen;
            break label_63;
          }
          jj_consume_token(S);
        }
p = unescape(t.image, false); locator = createLocator(t);
        jj_consume_token(COLON);
        label_64:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[100] = jj_gen;
            break label_64;
          }
          jj_consume_token(S);
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ONLY:
        case NUMBER:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:
        case STRING:
        case MINUS:
        case PLUS:
        case HASH:
        case EMS:
        case REM:
        case EXS:
        case CH:
        case VW:
        case VH:
        case VMIN:
        case VMAX:
        case LENGTH_PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case LENGTH_Q:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case ANGLE_TURN:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case RESOLUTION_DPI:
        case RESOLUTION_DPCM:
        case PERCENTAGE:
        case DIMENSION:
        case UNICODE_RANGE:
        case URI:
        case FUNCTION_CALC:
        case FUNCTION_VAR:
        case FUNCTION_RGB:
        case FUNCTION_HSL:
        case FUNCTION_HWB:
        case FUNCTION_LAB:
        case FUNCTION_LCH:
        case FUNCTION:
        case 122:{
          e = expr();
          break;
          }
        default:
          jj_la1[101] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IMPORTANT_SYM:{
        priority = prio();
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UNKNOWN:{
        t = jj_consume_token(UNKNOWN);
locator = createLocator(t);
            CSSParseException cpe = toCSSParseException("invalidDeclarationInvalidChar", new String[] {t.image}, locator);
            getErrorHandler().error(cpe);
            error_skipdecl();
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        ;
      }
if (starHack != null)
            {
                CSSParseException cpe = toCSSParseException("invalidDeclarationStarHack", new Object[0], starHack);
                getErrorHandler().error(cpe);
                return;
            }
            handleProperty(p, e, priority, locator);
    } catch (CSSParseException ex) {
getErrorHandler().error(ex);
        error_skipdecl();
    } catch (ParseException ex) {
CSSParseException cpe = toCSSParseException("invalidDeclaration", ex);
        getErrorHandler().error(cpe);
        error_skipdecl();
    }
}

//
// prio
//   : IMPORTANT_SYM S*
//   ;
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_65:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[105] = jj_gen;
        break label_65;
      }
      jj_consume_token(S);
    }
return true;
}

//
// expr
//   : term [ operator term ]*
//   ;
  final public LexicalUnit expr() throws ParseException {LexicalUnit head;
    LexicalUnit body;
    try {
      head = term(null);
body = head;
      label_66:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ONLY:
        case NUMBER:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:
        case STRING:
        case SLASH:
        case MINUS:
        case PLUS:
        case COMMA:
        case HASH:
        case EMS:
        case REM:
        case EXS:
        case CH:
        case VW:
        case VH:
        case VMIN:
        case VMAX:
        case LENGTH_PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case LENGTH_Q:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case ANGLE_TURN:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case RESOLUTION_DPI:
        case RESOLUTION_DPCM:
        case PERCENTAGE:
        case DIMENSION:
        case UNICODE_RANGE:
        case URI:
        case FUNCTION_CALC:
        case FUNCTION_VAR:
        case FUNCTION_RGB:
        case FUNCTION_HSL:
        case FUNCTION_HWB:
        case FUNCTION_LAB:
        case FUNCTION_LCH:
        case FUNCTION:
        case 122:{
          break;
          }
        default:
          jj_la1[106] = jj_gen;
          break label_66;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:
        case COMMA:{
          body = operator(body);
          break;
          }
        default:
          jj_la1[107] = jj_gen;
          ;
        }
        body = term(body);
      }
return head;    } catch (ParseException ex) {
throw toCSSParseException("invalidExpr", ex);
    }
}

//
// term
//  : unary_operator?
//    [ NUMBER | PERCENTAGE | LENGTH | EMS | REM | EXS | ANGLE | TIME | FREQ | function ]
//  | STRING | IDENT | URI | hexcolor | DIMENSION
//  S*
//  ;
//
  final public LexicalUnit term(LexicalUnit prev) throws ParseException {Token t;
  char op = ' ';
  LexicalUnit value = null;
  Locator locator = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MINUS:
    case PLUS:{
      op = unaryOperator();
      break;
      }
    default:
      jj_la1[108] = jj_gen;
      ;
    }
if (op != ' ') { locator = createLocator(token); }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NUMBER:
    case EMS:
    case REM:
    case EXS:
    case CH:
    case VW:
    case VH:
    case VMIN:
    case VMAX:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case LENGTH_Q:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case ANGLE_TURN:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case RESOLUTION_DPI:
    case RESOLUTION_DPCM:
    case PERCENTAGE:
    case FUNCTION_CALC:
    case FUNCTION_VAR:
    case FUNCTION_RGB:
    case FUNCTION_HSL:
    case FUNCTION_HWB:
    case FUNCTION_LAB:
    case FUNCTION_LCH:
    case FUNCTION:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        value = number(prev, op);
        break;
        }
      case EMS:
      case REM:
      case EXS:
      case CH:
      case VW:
      case VH:
      case VMIN:
      case VMAX:
      case LENGTH_PX:
      case LENGTH_CM:
      case LENGTH_MM:
      case LENGTH_IN:
      case LENGTH_PT:
      case LENGTH_PC:
      case LENGTH_Q:
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:
      case TIME_MS:
      case TIME_S:
      case FREQ_HZ:
      case FREQ_KHZ:
      case RESOLUTION_DPI:
      case RESOLUTION_DPCM:{
        value = dimension(prev, op);
        break;
        }
      case PERCENTAGE:{
        value = percentage(prev, op);
        break;
        }
      case FUNCTION:{
        value = function(prev);
        break;
        }
      case FUNCTION_RGB:{
        value = rgbColor(prev);
        break;
        }
      case FUNCTION_HSL:{
        value = hslColor(prev);
        break;
        }
      case FUNCTION_HWB:{
        value = hwbColor(prev);
        break;
        }
      case FUNCTION_LAB:{
        value = labColor(prev);
        break;
        }
      case FUNCTION_LCH:{
        value = lchColor(prev);
        break;
        }
      case FUNCTION_CALC:{
        value = calc(prev);
        break;
        }
      case FUNCTION_VAR:{
        value = var(prev);
        break;
        }
      default:
        jj_la1[109] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case STRING:{
      t = jj_consume_token(STRING);
value = LexicalUnitImpl.createString(prev, unescape(t.image, false));
      break;
      }
    case 122:{
      t = jj_consume_token(122);
value = LexicalUnitImpl.createIdent(prev, skipUnit().trim());
      break;
      }
    case ONLY:
    case NONE:
    case FROM:
    case IDENT:{
      t = identExcludingInherit();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
throw toCSSParseException("invalidExprColon", new String[]{ unescape(t.image, false) }, createLocator(t));
        }
      default:
        jj_la1[110] = jj_gen;
        ;
      }
value = LexicalUnitImpl.createIdent(prev, unescape(t.image, false));
      break;
      }
    case URI:{
      t = jj_consume_token(URI);
value = LexicalUnitImpl.createURI(prev, unescape(t.image, true));
      break;
      }
    case UNICODE_RANGE:{
      value = unicodeRange(prev);
      break;
      }
    case HASH:{
      value = hexcolor(prev);
      break;
      }
    case DIMENSION:{
      t = jj_consume_token(DIMENSION);
int n = getLastNumPos(t.image);
                value = LexicalUnitImpl.createDimension(
                    prev,
                    doubleValue(op, t.image.substring(0, n+1)),
                    t.image.substring(n+1));
      break;
      }
    case INHERIT:{
      t = jj_consume_token(INHERIT);
value = LexicalUnitImpl.createInherit(prev);
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (locator == null)
            {
                locator = createLocator(token);
            }
    label_67:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        break label_67;
      }
      jj_consume_token(S);
    }
if(value != null)
            {
              value.setLocator(locator);
            }
            return value;
}

//
// function
//   : FUNCTION S* ((EQUALS | COMMA | (unaryOperator? NUMBER) | STRING | IDENT | URI)? S*)+ ')' S*
//   ;
//
  final public LexicalUnit function(LexicalUnit prev) throws ParseException {Token t;
    LexicalUnit param = null;
    LexicalUnit body = null;
    String funct = "";
    t = jj_consume_token(FUNCTION);
funct = funct + unescape(t.image, false);
    label_68:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        break label_68;
      }
      jj_consume_token(S);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ONLY:
    case NUMBER:
    case INHERIT:
    case NONE:
    case FROM:
    case IDENT:
    case STRING:
    case MINUS:
    case PLUS:
    case HASH:
    case EMS:
    case REM:
    case EXS:
    case CH:
    case VW:
    case VH:
    case VMIN:
    case VMAX:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case LENGTH_Q:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case ANGLE_TURN:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case RESOLUTION_DPI:
    case RESOLUTION_DPCM:
    case PERCENTAGE:
    case DIMENSION:
    case UNICODE_RANGE:
    case URI:
    case FUNCTION_CALC:
    case FUNCTION_VAR:
    case FUNCTION_RGB:
    case FUNCTION_HSL:
    case FUNCTION_HWB:
    case FUNCTION_LAB:
    case FUNCTION_LCH:
    case FUNCTION:
    case 122:{
      param = term(null);
body = param;
      label_69:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ONLY:
        case NUMBER:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:
        case STRING:
        case MINUS:
        case EQUALS:
        case PLUS:
        case COMMA:
        case HASH:
        case EMS:
        case REM:
        case EXS:
        case CH:
        case VW:
        case VH:
        case VMIN:
        case VMAX:
        case LENGTH_PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case LENGTH_Q:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case ANGLE_TURN:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case RESOLUTION_DPI:
        case RESOLUTION_DPCM:
        case PERCENTAGE:
        case DIMENSION:
        case UNICODE_RANGE:
        case URI:
        case FUNCTION_CALC:
        case FUNCTION_VAR:
        case FUNCTION_RGB:
        case FUNCTION_HSL:
        case FUNCTION_HWB:
        case FUNCTION_LAB:
        case FUNCTION_LCH:
        case FUNCTION:
        case 122:{
          break;
          }
        default:
          jj_la1[114] = jj_gen;
          break label_69;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case EQUALS:
        case COMMA:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            t = jj_consume_token(COMMA);
body = LexicalUnitImpl.createComma(body);
            break;
            }
          case EQUALS:{
            t = jj_consume_token(EQUALS);
body = LexicalUnitImpl.createIdent(body, t.image);
            break;
            }
          default:
            jj_la1[115] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_70:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[116] = jj_gen;
              break label_70;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[117] = jj_gen;
          ;
        }
        body = term(body);
      }
      break;
      }
    default:
      jj_la1[118] = jj_gen;
      ;
    }
    jj_consume_token(RROUND);
return functionInternal(prev, funct, param);
}

//
// calc()
// https://www.w3.org/TR/css3-values/#calc-syntax
// <calc()> = calc( <calc-sum> )
//
  final public LexicalUnit calc(LexicalUnit prev) throws ParseException {Token t;
    LexicalUnit head = LexicalUnitImpl.createIdent(null, "");
    String funct = "";
    t = jj_consume_token(FUNCTION_CALC);
funct = unescape(t.image, false);
    label_71:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[119] = jj_gen;
        break label_71;
      }
      jj_consume_token(S);
    }
    calcSum(head);
    jj_consume_token(RROUND);
return functionInternal(prev, funct, head.getNextLexicalUnit());
}

//
// calcSum()
// <calc-sum> = <calc-product> [ [ '+' | '-' ] <calc-product> ]*
//
  final public LexicalUnit calcSum(LexicalUnit prev) throws ParseException {
    prev = calcProduct(prev);
    label_72:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        break;
        }
      default:
        jj_la1[120] = jj_gen;
        break label_72;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
prev = LexicalUnitImpl.createPlus(prev);
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
prev = LexicalUnitImpl.createMinus(prev);
        break;
        }
      default:
        jj_la1[121] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_73:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[122] = jj_gen;
          break label_73;
        }
        jj_consume_token(S);
      }
      prev = calcProduct(prev);
    }
if (prev != null)
        {
            prev.setLocator(createLocator(token));
        }
        return prev;
}

//
// calcProduct()
// <calc-product> = <calc-value> [ '*' <calc-value> | '/' <calc-number-value> ]*
//
  final public LexicalUnit calcProduct(LexicalUnit prev) throws ParseException {
    prev = calcValue(prev);
    label_74:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASTERISK:
      case SLASH:{
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        break label_74;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASTERISK:{
        jj_consume_token(ASTERISK);
prev = LexicalUnitImpl.createMultiply(prev);
        label_75:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[124] = jj_gen;
            break label_75;
          }
          jj_consume_token(S);
        }
        prev = calcValue(prev);
        break;
        }
      case SLASH:{
        jj_consume_token(SLASH);
prev = LexicalUnitImpl.createDivide(prev);
        label_76:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[125] = jj_gen;
            break label_76;
          }
          jj_consume_token(S);
        }
        prev = calcNumberValue(prev);
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if (prev != null)
        {
            prev.setLocator(createLocator(token));
        }
        return prev;
}

//
// calcValue()
// <calc-value> = <number> | <dimension> | <percentage> | ( <calc-sum> )
//
  final public LexicalUnit calcValue(LexicalUnit prev) throws ParseException {Token t;
    char op = ' ';
    LexicalUnit head = LexicalUnitImpl.createIdent(null, "");
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AND:
    case ONLY:
    case NUMBER:
    case INHERIT:
    case NONE:
    case FROM:
    case IDENT:
    case MINUS:
    case PLUS:
    case EMS:
    case REM:
    case EXS:
    case CH:
    case VW:
    case VH:
    case VMIN:
    case VMAX:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case LENGTH_Q:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case ANGLE_TURN:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case RESOLUTION_DPI:
    case RESOLUTION_DPCM:
    case PERCENTAGE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        prev = number(prev, op);
        break;
        }
      case EMS:
      case REM:
      case EXS:
      case CH:
      case VW:
      case VH:
      case VMIN:
      case VMAX:
      case LENGTH_PX:
      case LENGTH_CM:
      case LENGTH_MM:
      case LENGTH_IN:
      case LENGTH_PT:
      case LENGTH_PC:
      case LENGTH_Q:
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:
      case TIME_MS:
      case TIME_S:
      case FREQ_HZ:
      case FREQ_KHZ:
      case RESOLUTION_DPI:
      case RESOLUTION_DPCM:{
        prev = dimension(prev, op);
        break;
        }
      case PERCENTAGE:{
        prev = percentage(prev, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
prev = LexicalUnitImpl.createIdent(prev, unescape(t.image, false));
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case FUNCTION_VAR:{
      prev = var(prev);
      break;
      }
    case LROUND:
    case FUNCTION_CALC:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FUNCTION_CALC:{
        jj_consume_token(FUNCTION_CALC);
        break;
        }
      case LROUND:{
        jj_consume_token(LROUND);
        break;
        }
      default:
        jj_la1[129] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      calcSum(head);
      jj_consume_token(RROUND);
// use an empty function as block scope
                    prev = functionInternal(prev, "(", head.getNextLexicalUnit());
      break;
      }
    default:
      jj_la1[130] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_77:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        break label_77;
      }
      jj_consume_token(S);
    }
if (prev != null)
        {
            prev.setLocator(createLocator(token));
        }
        return prev;
}

//
// calcNumberSum()
// <calc-number-sum> = <calc-number-product> [ [ '+' | '-' ] <calc-number-product> ]*
//
  final public LexicalUnit calcNumberSum(LexicalUnit prev) throws ParseException {
    prev = calcNumberProduct(prev);
    label_78:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        break;
        }
      default:
        jj_la1[132] = jj_gen;
        break label_78;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
prev = LexicalUnitImpl.createPlus(prev);
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
prev = LexicalUnitImpl.createMinus(prev);
        break;
        }
      default:
        jj_la1[133] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_79:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[134] = jj_gen;
          break label_79;
        }
        jj_consume_token(S);
      }
      prev = calcNumberProduct(prev);
    }
if (prev != null)
        {
            prev.setLocator(createLocator(token));
        }
        return prev;
}

//
// calcNumberProduct()
// <calc-number-product> = <calc-number-value> [ '*' <calc-number-value> | '/' <calc-number-value> ]*
//
  final public LexicalUnit calcNumberProduct(LexicalUnit prev) throws ParseException {
    prev = calcNumberValue(prev);
    label_80:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASTERISK:
      case SLASH:{
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        break label_80;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASTERISK:{
        jj_consume_token(ASTERISK);
prev = LexicalUnitImpl.createMultiply(prev);
        label_81:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[136] = jj_gen;
            break label_81;
          }
          jj_consume_token(S);
        }
        prev = calcNumberValue(prev);
        break;
        }
      case SLASH:{
        jj_consume_token(SLASH);
prev = LexicalUnitImpl.createDivide(prev);
        label_82:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[137] = jj_gen;
            break label_82;
          }
          jj_consume_token(S);
        }
        prev = calcNumberValue(prev);
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if (prev != null)
        {
            prev.setLocator(createLocator(token));
        }
        return prev;
}

//
// calcNumberValue()
// <calc-number-value> = <number> | ( <calc-number-sum> )
//
  final public LexicalUnit calcNumberValue(LexicalUnit prev) throws ParseException {Token t;
    char op = ' ';
    String funct = "(";
    LexicalUnit head = LexicalUnitImpl.createIdent(null, "");
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AND:
    case ONLY:
    case NUMBER:
    case INHERIT:
    case NONE:
    case FROM:
    case IDENT:
    case MINUS:
    case PLUS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:
      case MINUS:
      case PLUS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[139] = jj_gen;
          ;
        }
        prev = number(prev, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
prev = LexicalUnitImpl.createIdent(prev, unescape(t.image, false));
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case FUNCTION_VAR:{
      prev = var(prev);
      break;
      }
    case LROUND:
    case FUNCTION_CALC:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FUNCTION_CALC:{
        t = jj_consume_token(FUNCTION_CALC);
funct = unescape(t.image, false);
        break;
        }
      case LROUND:{
        t = jj_consume_token(LROUND);
funct = unescape(t.image, false);
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      calcNumberSum(head);
      jj_consume_token(RROUND);
// use an empty function as block scope
                prev = functionInternal(prev, funct, head.getNextLexicalUnit());
      break;
      }
    default:
      jj_la1[142] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_83:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        break label_83;
      }
      jj_consume_token(S);
    }
if (prev != null)
        {
            prev.setLocator(createLocator(token));
        }
        return prev;
}

// var()
// https://developer.mozilla.org/en-US/docs/Web/CSS/var
// var( <custom-property-name> , <declaration-value>? )
//
  final public LexicalUnit var(LexicalUnit prev) throws ParseException {Token t;
    LexicalUnit current, propertyName;
    String funct = "";
    t = jj_consume_token(FUNCTION_VAR);
funct = unescape(t.image, false);
    label_84:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        break label_84;
      }
      jj_consume_token(S);
    }
    t = jj_consume_token(CUSTOM_PROPERTY_NAME);
current = LexicalUnitImpl.createIdent(prev, unescape(t.image, false)); propertyName = current;
    label_85:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        break label_85;
      }
      jj_consume_token(S);
    }
    label_86:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        break label_86;
      }
      jj_consume_token(COMMA);
current = LexicalUnitImpl.createComma(current);
      label_87:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[147] = jj_gen;
          break label_87;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ONLY:
      case NUMBER:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case STRING:
      case MINUS:
      case PLUS:
      case HASH:
      case EMS:
      case REM:
      case EXS:
      case CH:
      case VW:
      case VH:
      case VMIN:
      case VMAX:
      case LENGTH_PX:
      case LENGTH_CM:
      case LENGTH_MM:
      case LENGTH_IN:
      case LENGTH_PT:
      case LENGTH_PC:
      case LENGTH_Q:
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:
      case TIME_MS:
      case TIME_S:
      case FREQ_HZ:
      case FREQ_KHZ:
      case RESOLUTION_DPI:
      case RESOLUTION_DPCM:
      case PERCENTAGE:
      case DIMENSION:
      case UNICODE_RANGE:
      case URI:
      case FUNCTION_CALC:
      case FUNCTION_VAR:
      case FUNCTION_RGB:
      case FUNCTION_HSL:
      case FUNCTION_HWB:
      case FUNCTION_LAB:
      case FUNCTION_LCH:
      case FUNCTION:
      case 122:{
        // inline expr here because we need a differnt prev handling
                    current = term(current);
        label_88:
        while (true) {
          if (jj_2_2(2)) {
          } else {
            break label_88;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case SLASH:
          case COMMA:{
            current = operator(current);
            break;
            }
          default:
            jj_la1[148] = jj_gen;
            ;
          }
          current = term(current);
        }
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        ;
      }
    }
    jj_consume_token(RROUND);
return functionInternal(prev, funct, propertyName);
}

// rgb() / rgba()
//
  final public LexicalUnit rgbColor(LexicalUnit prev) throws ParseException {Token t;
    char op = ' ';
    LexicalUnit param = null;
    LexicalUnit next = null;
    String funct;
    t = jj_consume_token(FUNCTION_RGB);
funct = unescape(t.image.substring(0, t.image.length() - 1), false);
    label_89:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        break label_89;
      }
      jj_consume_token(S);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FROM:{
      jj_consume_token(FROM);
param = LexicalUnitImpl.createFrom(null);
next = param;
      label_90:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[151] = jj_gen;
          break label_90;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_RGB:{
        next = rgbColor(next);
        break;
        }
      case FUNCTION_HSL:{
        next = hslColor(next);
        break;
        }
      case FUNCTION_HWB:{
        next = hwbColor(next);
        break;
        }
      case FUNCTION_LAB:{
        next = labColor(next);
        break;
        }
      case FUNCTION_LCH:{
        next = lchColor(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[152] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_91:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[153] = jj_gen;
          break label_91;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[154] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_92:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[156] = jj_gen;
          break label_92;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_93:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[159] = jj_gen;
          break label_93;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[160] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_94:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[162] = jj_gen;
          break label_94;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case NUMBER:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case SLASH:
      case MINUS:
      case PLUS:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:{
          jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
          label_95:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[163] = jj_gen;
              break label_95;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[164] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[165] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case AND:
        case ONLY:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:{
          t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[166] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_96:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[167] = jj_gen;
            break label_96;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        ;
      }
      break;
      }
    case NUMBER:
    case NONE:
    case MINUS:
    case PLUS:
    case PERCENTAGE:
    case FUNCTION_CALC:
    case FUNCTION_VAR:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
param = LexicalUnitImpl.createNone(null);
        break;
        }
      case NUMBER:{
        param = number(null, op);
        break;
        }
      case PERCENTAGE:{
        param = percentage(null, op);
        break;
        }
      case FUNCTION_CALC:{
        param = calc(null);
        break;
        }
      case FUNCTION_VAR:{
        param = var(null);
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' '; next = param;
      label_97:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[171] = jj_gen;
          break label_97;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
next = LexicalUnitImpl.createComma(next);
        label_98:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[172] = jj_gen;
            break label_98;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[174] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_99:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          break label_99;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
next = LexicalUnitImpl.createComma(next);
        label_100:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[177] = jj_gen;
            break label_100;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[178] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[180] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_101:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[181] = jj_gen;
          break label_101;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:
      case NONE:
      case SLASH:
      case MINUS:
      case PLUS:
      case COMMA:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:
        case COMMA:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
next = LexicalUnitImpl.createComma(next);
            break;
            }
          case SLASH:{
            jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
            break;
            }
          default:
            jj_la1[182] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_102:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[183] = jj_gen;
              break label_102;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[184] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[185] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NONE:{
          jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
          break;
          }
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[186] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_103:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[187] = jj_gen;
            break label_103;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[188] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[189] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RROUND);
return rgbColorInternal(prev, funct, param);
}

// hsl() / hsla()
//
  final public LexicalUnit hslColor(LexicalUnit prev) throws ParseException {Token t;
    char op = ' ';
    LexicalUnit param = null;
    LexicalUnit next = null;
    String funct;
    t = jj_consume_token(FUNCTION_HSL);
funct = unescape(t.image.substring(0, t.image.length() - 1), false);
    label_104:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[190] = jj_gen;
        break label_104;
      }
      jj_consume_token(S);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FROM:{
      jj_consume_token(FROM);
param = LexicalUnitImpl.createFrom(null);
next = param;
      label_105:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[191] = jj_gen;
          break label_105;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_RGB:{
        next = rgbColor(next);
        break;
        }
      case FUNCTION_HSL:{
        next = hslColor(next);
        break;
        }
      case FUNCTION_HWB:{
        next = hwbColor(next);
        break;
        }
      case FUNCTION_LAB:{
        next = labColor(next);
        break;
        }
      case FUNCTION_LCH:{
        next = lchColor(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[192] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_106:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[193] = jj_gen;
          break label_106;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[194] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:{
        next = angle(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[195] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_107:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[196] = jj_gen;
          break label_107;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[197] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[198] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_108:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[199] = jj_gen;
          break label_108;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[200] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[201] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_109:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[202] = jj_gen;
          break label_109;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case NUMBER:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case SLASH:
      case MINUS:
      case PLUS:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:{
          jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
          label_110:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[203] = jj_gen;
              break label_110;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[204] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[205] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case AND:
        case ONLY:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:{
          t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[206] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_111:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[207] = jj_gen;
            break label_111;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[208] = jj_gen;
        ;
      }
      break;
      }
    case NUMBER:
    case NONE:
    case MINUS:
    case PLUS:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case ANGLE_TURN:
    case FUNCTION_CALC:
    case FUNCTION_VAR:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[209] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
param = LexicalUnitImpl.createNone(null);
        break;
        }
      case NUMBER:{
        param = number(null, op);
        break;
        }
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:{
        param = angle(null, op);
        break;
        }
      case FUNCTION_CALC:{
        param = calc(null);
        break;
        }
      case FUNCTION_VAR:{
        param = var(null);
        break;
        }
      default:
        jj_la1[210] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' '; next = param;
      label_112:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[211] = jj_gen;
          break label_112;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
next = LexicalUnitImpl.createComma(next);
        label_113:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[212] = jj_gen;
            break label_113;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[213] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[214] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[215] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_114:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[216] = jj_gen;
          break label_114;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
next = LexicalUnitImpl.createComma(next);
        label_115:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[217] = jj_gen;
            break label_115;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[218] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[219] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[220] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_116:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[221] = jj_gen;
          break label_116;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:
      case NONE:
      case SLASH:
      case MINUS:
      case PLUS:
      case COMMA:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:
        case COMMA:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
next = LexicalUnitImpl.createComma(next);
            break;
            }
          case SLASH:{
            jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
            break;
            }
          default:
            jj_la1[222] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_117:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[223] = jj_gen;
              break label_117;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[224] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[225] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NONE:{
          jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
          break;
          }
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[226] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_118:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[227] = jj_gen;
            break label_118;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[228] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[229] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RROUND);
return hslColorInternal(prev, funct, param);
}

// hwb()
//
  final public LexicalUnit hwbColor(LexicalUnit prev) throws ParseException {Token t;
    char op = ' ';
    LexicalUnit param = null;
    LexicalUnit next = null;
    String funct;
    t = jj_consume_token(FUNCTION_HWB);
funct = unescape(t.image.substring(0, t.image.length() - 1), false);
    label_119:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[230] = jj_gen;
        break label_119;
      }
      jj_consume_token(S);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FROM:{
      jj_consume_token(FROM);
param = LexicalUnitImpl.createFrom(null);
next = param;
      label_120:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[231] = jj_gen;
          break label_120;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_RGB:{
        next = rgbColor(next);
        break;
        }
      case FUNCTION_HSL:{
        next = hslColor(next);
        break;
        }
      case FUNCTION_HWB:{
        next = hwbColor(next);
        break;
        }
      case FUNCTION_LAB:{
        next = labColor(next);
        break;
        }
      case FUNCTION_LCH:{
        next = lchColor(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[232] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_121:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[233] = jj_gen;
          break label_121;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[234] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:{
        next = angle(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[235] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_122:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[236] = jj_gen;
          break label_122;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[237] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[238] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_123:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[239] = jj_gen;
          break label_123;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[240] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[241] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_124:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[242] = jj_gen;
          break label_124;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case NUMBER:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case SLASH:
      case MINUS:
      case PLUS:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:{
          jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
          label_125:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[243] = jj_gen;
              break label_125;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[244] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[245] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case AND:
        case ONLY:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:{
          t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[246] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_126:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[247] = jj_gen;
            break label_126;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[248] = jj_gen;
        ;
      }
      break;
      }
    case NUMBER:
    case NONE:
    case MINUS:
    case PLUS:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case ANGLE_TURN:
    case FUNCTION_CALC:
    case FUNCTION_VAR:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[249] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
param = LexicalUnitImpl.createNone(null);
        break;
        }
      case NUMBER:{
        param = number(null, op);
        break;
        }
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:{
        param = angle(null, op);
        break;
        }
      case FUNCTION_CALC:{
        param = calc(null);
        break;
        }
      case FUNCTION_VAR:{
        param = var(null);
        break;
        }
      default:
        jj_la1[250] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' '; next = param;
      label_127:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[251] = jj_gen;
          break label_127;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[252] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[253] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_128:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[254] = jj_gen;
          break label_128;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[255] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[256] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_129:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[257] = jj_gen;
          break label_129;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:
      case NONE:
      case SLASH:
      case MINUS:
      case PLUS:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:{
          jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
          label_130:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[258] = jj_gen;
              break label_130;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[259] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[260] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NONE:{
          jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
          break;
          }
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[261] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_131:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[262] = jj_gen;
            break label_131;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[263] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[264] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RROUND);
return hwbColorInternal(prev, funct, param);
}

// lab()
//
  final public LexicalUnit labColor(LexicalUnit prev) throws ParseException {Token t;
    char op = ' ';
    LexicalUnit param = null;
    LexicalUnit next = null;
    String funct;
    t = jj_consume_token(FUNCTION_LAB);
funct = unescape(t.image.substring(0, t.image.length() - 1), false);
    label_132:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[265] = jj_gen;
        break label_132;
      }
      jj_consume_token(S);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FROM:{
      jj_consume_token(FROM);
param = LexicalUnitImpl.createFrom(null);
next = param;
      label_133:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[266] = jj_gen;
          break label_133;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_RGB:{
        next = rgbColor(next);
        break;
        }
      case FUNCTION_HSL:{
        next = hslColor(next);
        break;
        }
      case FUNCTION_HWB:{
        next = hwbColor(next);
        break;
        }
      case FUNCTION_LAB:{
        next = labColor(next);
        break;
        }
      case FUNCTION_LCH:{
        next = lchColor(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[267] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_134:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[268] = jj_gen;
          break label_134;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[269] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[270] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_135:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[271] = jj_gen;
          break label_135;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[272] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[273] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_136:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[274] = jj_gen;
          break label_136;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[275] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[276] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_137:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[277] = jj_gen;
          break label_137;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case NUMBER:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case SLASH:
      case MINUS:
      case PLUS:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:{
          jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
          label_138:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[278] = jj_gen;
              break label_138;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[279] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[280] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case AND:
        case ONLY:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:{
          t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[281] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_139:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[282] = jj_gen;
            break label_139;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[283] = jj_gen;
        ;
      }
      break;
      }
    case NUMBER:
    case NONE:
    case MINUS:
    case PLUS:
    case PERCENTAGE:
    case FUNCTION_CALC:
    case FUNCTION_VAR:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[284] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
param = LexicalUnitImpl.createNone(null);
        break;
        }
      case NUMBER:{
        param = number(null, op);
        break;
        }
      case PERCENTAGE:{
        param = percentage(null, op);
        break;
        }
      case FUNCTION_CALC:{
        param = calc(null);
        break;
        }
      case FUNCTION_VAR:{
        param = var(null);
        break;
        }
      default:
        jj_la1[285] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' '; next = param;
      label_140:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[286] = jj_gen;
          break label_140;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[287] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[288] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_141:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[289] = jj_gen;
          break label_141;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[290] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[291] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_142:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[292] = jj_gen;
          break label_142;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:
      case NONE:
      case SLASH:
      case MINUS:
      case PLUS:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:{
          jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
          label_143:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[293] = jj_gen;
              break label_143;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[294] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[295] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NONE:{
          jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
          break;
          }
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[296] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_144:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[297] = jj_gen;
            break label_144;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[298] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[299] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RROUND);
return labColorInternal(prev, funct, param);
}

// lch()
//
  final public LexicalUnit lchColor(LexicalUnit prev) throws ParseException {Token t;
    char op = ' ';
    LexicalUnit param = null;
    LexicalUnit next = null;
    String funct;
    t = jj_consume_token(FUNCTION_LCH);
funct = unescape(t.image.substring(0, t.image.length() - 1), false);
    label_145:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case S:{
        break;
        }
      default:
        jj_la1[300] = jj_gen;
        break label_145;
      }
      jj_consume_token(S);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FROM:{
      jj_consume_token(FROM);
param = LexicalUnitImpl.createFrom(null);
next = param;
      label_146:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[301] = jj_gen;
          break label_146;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_RGB:{
        next = rgbColor(next);
        break;
        }
      case FUNCTION_HSL:{
        next = hslColor(next);
        break;
        }
      case FUNCTION_HWB:{
        next = hwbColor(next);
        break;
        }
      case FUNCTION_LAB:{
        next = labColor(next);
        break;
        }
      case FUNCTION_LCH:{
        next = lchColor(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[302] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_147:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[303] = jj_gen;
          break label_147;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[304] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[305] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_148:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[306] = jj_gen;
          break label_148;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[307] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_149:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[309] = jj_gen;
          break label_149;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[310] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:{
        next = angle(next, op);
        break;
        }
      case AND:
      case ONLY:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:{
        t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[311] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_150:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[312] = jj_gen;
          break label_150;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case ONLY:
      case NUMBER:
      case INHERIT:
      case NONE:
      case FROM:
      case IDENT:
      case SLASH:
      case MINUS:
      case PLUS:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:{
          jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
          label_151:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[313] = jj_gen;
              break label_151;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[314] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[315] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case AND:
        case ONLY:
        case INHERIT:
        case NONE:
        case FROM:
        case IDENT:{
          t = ident();
next = LexicalUnitImpl.createIdent(next, unescape(t.image, false));
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[316] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_152:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[317] = jj_gen;
            break label_152;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[318] = jj_gen;
        ;
      }
      break;
      }
    case NUMBER:
    case NONE:
    case MINUS:
    case PLUS:
    case PERCENTAGE:
    case FUNCTION_CALC:
    case FUNCTION_VAR:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[319] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
param = LexicalUnitImpl.createNone(null);
        break;
        }
      case NUMBER:{
        param = number(null, op);
        break;
        }
      case PERCENTAGE:{
        param = percentage(null, op);
        break;
        }
      case FUNCTION_CALC:{
        param = calc(null);
        break;
        }
      case FUNCTION_VAR:{
        param = var(null);
        break;
        }
      default:
        jj_la1[320] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' '; next = param;
      label_153:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[321] = jj_gen;
          break label_153;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[322] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case NUMBER:{
        next = number(next, op);
        break;
        }
      case PERCENTAGE:{
        next = percentage(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[323] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_154:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[324] = jj_gen;
          break label_154;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MINUS:
      case PLUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[325] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NONE:{
        jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
        break;
        }
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case ANGLE_TURN:{
        next = angle(next, op);
        break;
        }
      case FUNCTION_CALC:{
        next = calc(next);
        break;
        }
      case FUNCTION_VAR:{
        next = var(next);
        break;
        }
      default:
        jj_la1[326] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
op = ' ';
      label_155:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case S:{
          break;
          }
        default:
          jj_la1[327] = jj_gen;
          break label_155;
        }
        jj_consume_token(S);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:
      case NONE:
      case SLASH:
      case MINUS:
      case PLUS:
      case PERCENTAGE:
      case FUNCTION_CALC:
      case FUNCTION_VAR:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SLASH:{
          jj_consume_token(SLASH);
next = LexicalUnitImpl.createSlash(next);
          label_156:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case S:{
              break;
              }
            default:
              jj_la1[328] = jj_gen;
              break label_156;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[329] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MINUS:
        case PLUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[330] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NONE:{
          jj_consume_token(NONE);
next = LexicalUnitImpl.createNone(next);
          break;
          }
        case NUMBER:{
          next = number(next, op);
          break;
          }
        case PERCENTAGE:{
          next = percentage(next, op);
          break;
          }
        case FUNCTION_CALC:{
          next = calc(next);
          break;
          }
        case FUNCTION_VAR:{
          next = var(next);
          break;
          }
        default:
          jj_la1[331] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_157:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case S:{
            break;
            }
          default:
            jj_la1[332] = jj_gen;
            break label_157;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[333] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[334] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RROUND);
return lchColorInternal(prev, funct, param);
}

//
// Helper to process various keywords as IDENT
//
  final public Token ident() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IDENT:{
      t = jj_consume_token(IDENT);
return t;
      }
    case AND:
    case ONLY:
    case INHERIT:
    case NONE:
    case FROM:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INHERIT:{
        t = jj_consume_token(INHERIT);
        break;
        }
      case AND:{
        t = jj_consume_token(AND);
        break;
        }
      case ONLY:{
        t = jj_consume_token(ONLY);
        break;
        }
      case NONE:{
        t = jj_consume_token(NONE);
        break;
        }
      case FROM:{
        t = jj_consume_token(FROM);
        break;
        }
      default:
        jj_la1[335] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
Token ident = new Token(IDENT, unescape(t.image, false));
            ident.beginLine = t.beginLine;
            ident.beginColumn = t.endColumn;
            ident.endLine = t.beginLine;
            ident.endColumn = t.endColumn;
            ident.next = t.next;
            ident.specialToken = t.specialToken;
            return ident;
      }
    default:
      jj_la1[336] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Token identExcludingInherit() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IDENT:{
      t = jj_consume_token(IDENT);
return t;
      }
    case ONLY:
    case NONE:
    case FROM:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ONLY:{
        t = jj_consume_token(ONLY);
        break;
        }
      case NONE:{
        t = jj_consume_token(NONE);
        break;
        }
      case FROM:{
        t = jj_consume_token(FROM);
        break;
        }
      default:
        jj_la1[337] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
Token ident = new Token(IDENT, unescape(t.image, false));
            ident.beginLine = t.beginLine;
            ident.beginColumn = t.endColumn;
            ident.endLine = t.beginLine;
            ident.endColumn = t.endColumn;
            ident.next = t.next;
            ident.specialToken = t.specialToken;
            return ident;
      }
    default:
      jj_la1[338] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Token identExcludingOnly() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IDENT:{
      t = jj_consume_token(IDENT);
return t;
      }
    case INHERIT:
    case NONE:
    case FROM:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INHERIT:{
        t = jj_consume_token(INHERIT);
        break;
        }
      case NONE:{
        t = jj_consume_token(NONE);
        break;
        }
      case FROM:{
        t = jj_consume_token(FROM);
        break;
        }
      default:
        jj_la1[339] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
Token ident = new Token(IDENT, unescape(t.image, false));
            ident.beginLine = t.beginLine;
            ident.beginColumn = t.endColumn;
            ident.endLine = t.beginLine;
            ident.endColumn = t.endColumn;
            ident.next = t.next;
            ident.specialToken = t.specialToken;
            return ident;
      }
    default:
      jj_la1[340] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

//
// number()
//
  final public LexicalUnit number(LexicalUnit prev, char op) throws ParseException {Token t;
    LexicalUnit value = null;
    t = jj_consume_token(NUMBER);
try
        {
            value = LexicalUnitImpl.createNumber(prev, intValue(op, t.image));
        }
        catch (NumberFormatException e)
        {
            value = LexicalUnitImpl.createNumber(prev, doubleValue(op, t.image));
        }
        if (value != null)
        {
            value.setLocator(createLocator(token));
        }
        return value;
}

//
// percentage()
//
  final public LexicalUnit percentage(LexicalUnit prev, char op) throws ParseException {Token t;
    LexicalUnit value = null;
    t = jj_consume_token(PERCENTAGE);
value = LexicalUnitImpl.createPercentage(prev, doubleValue(op, t.image));
if (value != null)
        {
            value.setLocator(createLocator(token));
        }
        return value;
}

//
// dimension()
//
  final public LexicalUnit dimension(LexicalUnit prev, char op) throws ParseException {Token t;
    LexicalUnit value = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LENGTH_PX:{
      t = jj_consume_token(LENGTH_PX);
value = LexicalUnitImpl.createPixel(prev, doubleValue(op, t.image));
      break;
      }
    case LENGTH_CM:{
      t = jj_consume_token(LENGTH_CM);
value = LexicalUnitImpl.createCentimeter(prev, doubleValue(op, t.image));
      break;
      }
    case LENGTH_MM:{
      t = jj_consume_token(LENGTH_MM);
value = LexicalUnitImpl.createMillimeter(prev, doubleValue(op, t.image));
      break;
      }
    case LENGTH_IN:{
      t = jj_consume_token(LENGTH_IN);
value = LexicalUnitImpl.createInch(prev, doubleValue(op, t.image));
      break;
      }
    case LENGTH_PT:{
      t = jj_consume_token(LENGTH_PT);
value = LexicalUnitImpl.createPoint(prev, doubleValue(op, t.image));
      break;
      }
    case LENGTH_PC:{
      t = jj_consume_token(LENGTH_PC);
value = LexicalUnitImpl.createPica(prev, doubleValue(op, t.image));
      break;
      }
    case LENGTH_Q:{
      t = jj_consume_token(LENGTH_Q);
value = LexicalUnitImpl.createQuater(prev, doubleValue(op, t.image));
      break;
      }
    case EMS:{
      t = jj_consume_token(EMS);
value = LexicalUnitImpl.createEm(prev, doubleValue(op, t.image));
      break;
      }
    case REM:{
      t = jj_consume_token(REM);
value = LexicalUnitImpl.createRem(prev, doubleValue(op, t.image));
      break;
      }
    case EXS:{
      t = jj_consume_token(EXS);
value = LexicalUnitImpl.createEx(prev, doubleValue(op, t.image));
      break;
      }
    case CH:{
      t = jj_consume_token(CH);
value = LexicalUnitImpl.createCh(prev, doubleValue(op, t.image));
      break;
      }
    case VW:{
      t = jj_consume_token(VW);
value = LexicalUnitImpl.createVw(prev, doubleValue(op, t.image));
      break;
      }
    case VH:{
      t = jj_consume_token(VH);
value = LexicalUnitImpl.createVh(prev, doubleValue(op, t.image));
      break;
      }
    case VMIN:{
      t = jj_consume_token(VMIN);
value = LexicalUnitImpl.createVMin(prev, doubleValue(op, t.image));
      break;
      }
    case VMAX:{
      t = jj_consume_token(VMAX);
value = LexicalUnitImpl.createVMax(prev, doubleValue(op, t.image));
      break;
      }
    case ANGLE_DEG:{
      t = jj_consume_token(ANGLE_DEG);
value = LexicalUnitImpl.createDegree(prev, doubleValue(op, t.image));
      break;
      }
    case ANGLE_RAD:{
      t = jj_consume_token(ANGLE_RAD);
value = LexicalUnitImpl.createRadian(prev, doubleValue(op, t.image));
      break;
      }
    case ANGLE_GRAD:{
      t = jj_consume_token(ANGLE_GRAD);
value = LexicalUnitImpl.createGradian(prev, doubleValue(op, t.image));
      break;
      }
    case ANGLE_TURN:{
      t = jj_consume_token(ANGLE_TURN);
value = LexicalUnitImpl.createTurn(prev, doubleValue(op, t.image));
      break;
      }
    case TIME_MS:{
      t = jj_consume_token(TIME_MS);
value = LexicalUnitImpl.createMillisecond(prev, doubleValue(op, t.image));
      break;
      }
    case TIME_S:{
      t = jj_consume_token(TIME_S);
value = LexicalUnitImpl.createSecond(prev, doubleValue(op, t.image));
      break;
      }
    case FREQ_HZ:{
      t = jj_consume_token(FREQ_HZ);
value = LexicalUnitImpl.createHertz(prev, doubleValue(op, t.image));
      break;
      }
    case FREQ_KHZ:{
      t = jj_consume_token(FREQ_KHZ);
value = LexicalUnitImpl.createKiloHertz(prev, doubleValue(op, t.image));
      break;
      }
    case RESOLUTION_DPI:{
      t = jj_consume_token(RESOLUTION_DPI);
value = LexicalUnitImpl.createDimension(prev, doubleValue(op, t.image), "dpi");
      break;
      }
    case RESOLUTION_DPCM:{
      t = jj_consume_token(RESOLUTION_DPCM);
value = LexicalUnitImpl.createDimension(prev, doubleValue(op, t.image), "dpcm");
      break;
      }
    default:
      jj_la1[341] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (value != null)
        {
            value.setLocator(createLocator(token));
        }
        return value;
}

//
// angle()
//
  final public LexicalUnit angle(LexicalUnit prev, char op) throws ParseException {Token t;
    LexicalUnit value = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANGLE_DEG:{
      t = jj_consume_token(ANGLE_DEG);
value = LexicalUnitImpl.createDegree(prev, doubleValue(op, t.image));
      break;
      }
    case ANGLE_RAD:{
      t = jj_consume_token(ANGLE_RAD);
value = LexicalUnitImpl.createRadian(prev, doubleValue(op, t.image));
      break;
      }
    case ANGLE_GRAD:{
      t = jj_consume_token(ANGLE_GRAD);
value = LexicalUnitImpl.createGradian(prev, doubleValue(op, t.image));
      break;
      }
    case ANGLE_TURN:{
      t = jj_consume_token(ANGLE_TURN);
value = LexicalUnitImpl.createTurn(prev, doubleValue(op, t.image));
      break;
      }
    default:
      jj_la1[342] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (value != null)
        {
            value.setLocator(createLocator(token));
        }
        return value;
}

//
// unicodeRange
//
  final public LexicalUnit unicodeRange(LexicalUnit prev) throws ParseException {Token t;
    StringBuilder range = new StringBuilder();
    t = jj_consume_token(UNICODE_RANGE);
range.append(unescape(t.image, false));
return LexicalUnitImpl.createIdent(prev, range.toString().toUpperCase(Locale.ROOT));
}

//
// hexcolor
//   : HASH S*
//   ;
//
  final public LexicalUnit hexcolor(LexicalUnit prev) throws ParseException {Token t;
    t = jj_consume_token(HASH);
return hexColorInternal(prev, t);
}

  String skip() throws ParseException {StringBuilder sb = new StringBuilder();
    int nesting = 0;
    Token t = getToken(0);
    if (t.image != null) {
        sb.append(t.image);
    }

    do {
        t = getNextToken();
        if (t.kind == EOF) {
            break;
        }
        sb.append(t.image);
        appendUnit(t, sb);

        if (t.kind == LBRACE) {
            nesting++;
        }
        else if (t.kind == RBRACE) {
            nesting--;
        }
    }
    while ((t.kind != RBRACE && t.kind != SEMICOLON) || nesting > 0);

    return sb.toString();
  }

  String skipUnit() throws ParseException {StringBuilder sb = new StringBuilder();

    Token t = token;
    Token oldToken = null;
    while (t.kind != SEMICOLON && t.kind != RBRACE && t.kind != EOF ) {
        oldToken = t;
        sb.append(oldToken.image);
        appendUnit(t, sb);

        t = getNextToken();
    }
    if (t.kind != EOF) {
        token = oldToken;
    }

    return sb.toString();
  }

  void appendUnit(Token t, StringBuilder sb) throws ParseException {if (t.kind == EMS) {
      sb.append("em");
      return;
    }
    if (t.kind == REM) {
      sb.append("rem");
      return;
    }
    if (t.kind == EXS) {
      sb.append("ex");
      return;
    }
    if (t.kind == CH) {
      sb.append("ch");
      return;
    }
    if (t.kind == VW) {
      sb.append("vw");
      return;
    }
    if (t.kind == VH) {
      sb.append("vh");
      return;
    }
    if (t.kind == VMIN) {
      sb.append("vmin");
      return;
    }
    if (t.kind == VMAX) {
      sb.append("vmax");
      return;
    }
    if (t.kind == LENGTH_PX) {
      sb.append("px");
      return;
    }
    if (t.kind == LENGTH_CM) {
      sb.append("cm");
      return;
    }
    if (t.kind == LENGTH_MM) {
      sb.append("mm");
      return;
    }
    if (t.kind == LENGTH_IN) {
      sb.append("in");
      return;
    }
    if (t.kind == LENGTH_PT) {
      sb.append("pt");
      return;
    }
    if (t.kind == LENGTH_PC) {
      sb.append("pc");
      return;
    }
    if (t.kind == LENGTH_Q) {
      sb.append("Q");
      return;
    }
    if (t.kind == ANGLE_DEG) {
      sb.append("deg");
      return;
    }
    if (t.kind == ANGLE_RAD) {
      sb.append("rad");
      return;
    }
    if (t.kind == ANGLE_GRAD) {
      sb.append("grad");
      return;
    }
    if (t.kind == ANGLE_TURN) {
      sb.append("turn");
      return;
    }
    if (t.kind == TIME_MS) {
      sb.append("ms");
      return;
    }
    if (t.kind == TIME_S) {
      sb.append('s');
      return;
    }
    if (t.kind == FREQ_HZ) {
      sb.append("hz");
      return;
    }
    if (t.kind == FREQ_KHZ) {
      sb.append("khz");
      return;
    }
    if (t.kind == RESOLUTION_DPI) {
      sb.append("dpi");
      return;
    }
    if (t.kind == RESOLUTION_DPCM) {
      sb.append("dpcm");
      return;
    }
    if (t.kind == PERCENTAGE) {
      sb.append('%');
      return;
    }
  }

  void error_skipblock(String msgKey, CSSParseException e) throws ParseException {if (msgKey != null) {
        getErrorHandler().warning(createSkipWarning(msgKey, e));
    }

    Token t;
    int nesting = 0;
    do {
        t = getNextToken();
        if (t.kind == LBRACE) {
            nesting++;
        }
        else if (t.kind == RBRACE) {
            nesting--;
        }
    }
    while (t.kind != EOF && (t.kind != RBRACE || nesting > 0));
  }

  void error_skipdecl() throws ParseException {Token t = getToken(1);
    if (t.kind == LBRACE) {
        error_skipblock(null, null);
        return;
    }
    if (t.kind == RBRACE) {
        // next will be RBRACE so we are finished
        return;
    }

    Token oldToken = token;
    while (t.kind != SEMICOLON && t.kind != RBRACE && t.kind != EOF) {
        oldToken = t;
        t = getNextToken();
    }
    if (t.kind != EOF) {
        token = oldToken;
    }
  }

  void error_skipAtRule() throws ParseException {Token t = null;
    do {
        t = getNextToken();
    }
    while (t.kind != SEMICOLON && t.kind != EOF);
  }

  Boolean handleCaseInSensitive(Token t) throws ParseException {String s = unescape(t.image, false);
    if ("i".equalsIgnoreCase(s)) {
      return Boolean.TRUE;
    }
    if ("s".equalsIgnoreCase(s)) {
      return Boolean.FALSE;
    }

    throw toCSSParseException("invalidCaseInSensitivelyIdentifier", new String[] { s }, createLocator(t));
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_3R_227()
 {
    if (jj_scan_token(LSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_268()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_306()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3R_307()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) return true;
    }
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) return true;
    }
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3R_267()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_268()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_scan_token(FUNCTION_HWB)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) return true;
    }
    return false;
  }

  private boolean jj_3R_262()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_286()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_272()
 {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) return true;
    }
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_223()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_291()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_169()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) {
    jj_scanpos = xsp;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_scan_token(122)) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_3R_196()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_197()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_scan_token(URI)) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_scan_token(DIMENSION)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_158()) return true;
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_scan_token(FUNCTION_HSL)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    }
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_scan_token(FUNCTION_LCH)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) return true;
    }
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_scan_token(INHERIT)) return true;
    return false;
  }

  private boolean jj_3R_257()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_260()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) {
    jj_scanpos = xsp;
    if (jj_3R_285()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) return true;
    }
    return false;
  }

  private boolean jj_3R_280()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_254()) jj_scanpos = xsp;
    if (jj_scan_token(RROUND)) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_scan_token(FUNCTION_VAR)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CUSTOM_PROPERTY_NAME)) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    Token xsp;
    if (jj_3R_181()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_181()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_212()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_181()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_scan_token(LENGTH_PX)) return true;
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_3R_227()) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_scan_token(LENGTH_CM)) return true;
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_scan_token(LENGTH_MM)) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_scan_token(LENGTH_IN)) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_scan_token(LENGTH_PT)) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_scan_token(LENGTH_PC)) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_scan_token(LENGTH_Q)) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_scan_token(EMS)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_160()) jj_scanpos = xsp;
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_scan_token(EXS)) return true;
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_scan_token(FUNCTION_CALC)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_265()) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    if (jj_scan_token(CH)) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_scan_token(VW)) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_scan_token(VH)) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_scan_token(VMIN)) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_scan_token(VMAX)) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_scan_token(ANGLE_DEG)) return true;
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_scan_token(ANGLE_RAD)) return true;
    return false;
  }

  private boolean jj_3R_246()
 {
    if (jj_scan_token(ANGLE_GRAD)) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_scan_token(ANGLE_TURN)) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_scan_token(TIME_MS)) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_scan_token(FUNCTION_RGB)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) return true;
    }
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_scan_token(TIME_S)) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_scan_token(FREQ_HZ)) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(FREQ_KHZ)) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_scan_token(RESOLUTION_DPI)) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    if (jj_scan_token(RESOLUTION_DPCM)) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_255()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_scan_token(FUNCTION_LAB)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) return true;
    }
    return false;
  }

  private boolean jj_3R_258()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_299()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_301()) {
    jj_scanpos = xsp;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) {
    jj_scanpos = xsp;
    if (jj_3R_304()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_264()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_292()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    if (jj_scan_token(ANGLE_DEG)) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_scan_token(ANGLE_RAD)) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_scan_token(ANGLE_GRAD)) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_scan_token(ANGLE_TURN)) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    if (jj_3R_300()) return true;
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_scan_token(UNICODE_RANGE)) return true;
    return false;
  }

  private boolean jj_3R_296()
 {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) return true;
    }
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_scan_token(SLASH)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_180()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    }
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_scan_token(GREATER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_300()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(TILDE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_179()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_179()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_308()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_184()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) return true;
    }
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CSS3ParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[343];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x2,0x2,0x2,0x2,0x0,0xf50000,0xf50000,0xf50000,0x2,0x2,0x2,0xf50000,0x2,0x2,0x4000000,0x2,0xf60000,0x2,0x2,0xf50000,0x0,0x2,0x60000,0x2,0x60000,0x10000,0x2,0x10000,0x2,0xf60000,0x2,0x2,0x2,0xf00000,0x2,0x0,0x2,0xf50000,0x2,0xf50000,0x2,0x2,0xf50000,0x2,0x0,0x2,0xf50000,0x0,0x2,0x2,0x2,0x2,0x2,0x0,0x2,0x2,0x2,0x0,0x2,0x0,0x2,0x0,0x2,0x1,0x2,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0xf50000,0xf50000,0x2,0x2,0x0,0x2,0x4f50000,0x2,0x2,0xf50000,0x0,0x0,0x2,0x2,0x2,0x2,0x4fd0000,0x2,0x4fd0000,0xf50000,0xf50000,0x0,0x2,0xf50000,0x0,0x2,0x2,0x2,0x2,0x4fc0000,0xf50000,0x0,0x0,0x2,0x4fc0000,0x0,0x0,0x80000,0x0,0x4fc0000,0x2,0x2,0x4fc0000,0x0,0x2,0x0,0x4fc0000,0x2,0x0,0x0,0x2,0x0,0x2,0x2,0x0,0x0,0xfd0000,0x0,0xfd0000,0x2,0x0,0x0,0x2,0x0,0x2,0x2,0x0,0x0,0xfd0000,0x0,0xfd0000,0x2,0x2,0x2,0x0,0x2,0x0,0x4fc0000,0x2,0x2,0xf50000,0x2,0x0,0xfd0000,0x2,0x0,0xfd0000,0x2,0x0,0xfd0000,0x2,0x2,0x0,0x0,0xfd0000,0x2,0xfd0000,0x0,0x280000,0x2,0x2,0x0,0x0,0x280000,0x2,0x2,0x0,0x0,0x280000,0x2,0x0,0x2,0x0,0x0,0x280000,0x2,0x280000,0x680000,0x2,0x2,0xf50000,0x2,0x0,0xfd0000,0x2,0x0,0xf50000,0x2,0x0,0xf50000,0x2,0x2,0x0,0x0,0xfd0000,0x2,0xfd0000,0x0,0x280000,0x2,0x2,0x0,0x0,0x200000,0x2,0x2,0x0,0x0,0x200000,0x2,0x0,0x2,0x0,0x0,0x280000,0x2,0x280000,0x680000,0x2,0x2,0xf50000,0x2,0x0,0xfd0000,0x2,0x0,0xf50000,0x2,0x0,0xf50000,0x2,0x2,0x0,0x0,0xfd0000,0x2,0xfd0000,0x0,0x280000,0x2,0x0,0x200000,0x2,0x0,0x200000,0x2,0x2,0x0,0x0,0x280000,0x2,0x280000,0x680000,0x2,0x2,0xf50000,0x2,0x0,0xfd0000,0x2,0x0,0xfd0000,0x2,0x0,0xfd0000,0x2,0x2,0x0,0x0,0xfd0000,0x2,0xfd0000,0x0,0x280000,0x2,0x0,0x280000,0x2,0x0,0x280000,0x2,0x2,0x0,0x0,0x280000,0x2,0x280000,0x680000,0x2,0x2,0xf50000,0x2,0x0,0xfd0000,0x2,0x0,0xfd0000,0x2,0x0,0xf50000,0x2,0x2,0x0,0x0,0xfd0000,0x2,0xfd0000,0x0,0x280000,0x2,0x0,0x280000,0x2,0x0,0x200000,0x2,0x2,0x0,0x0,0x280000,0x2,0x280000,0x680000,0x750000,0xf50000,0x640000,0xe40000,0x700000,0xf00000,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x30000,0x30000,0x30000,0x30000,0x0,0x68000000,0x68000000,0x68000000,0x30000,0x30000,0x0,0x68000000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x68000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x68000000,0x0,0x68000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x28000000,0x28000000,0x28000000,0x28000000,0x68000000,0x40000000,0x0,0x0,0x7c0000,0x0,0x0,0x0,0x0,0x0,0x7c0000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x10000000,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0x0,0xc0000000,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0xc0000000,0x0,0x0,0xc0000000,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x2000,0x1d04,0x1f04,0x1f04,0x0,0x0,0x0,0x3f04,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf04,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf04,0x0,0xf04,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x70,0x0,0x70,0x70,0x11,0x0,0x0,0x0,0x80,0x0,0x0,0x104,0x104,0x104,0x104,0x104,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x11,0x0,0x11,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffff8111,0x0,0x4000,0x0,0x0,0xffff8191,0x80,0x11,0xffff8000,0x0,0xffff8100,0x0,0x0,0xffff8193,0x82,0x0,0x82,0xffff8111,0x0,0x11,0x11,0x0,0x0,0x0,0x0,0x0,0x11,0xffff8000,0x0,0xffff8011,0x0,0x11,0x11,0x0,0x0,0x0,0x0,0x0,0x11,0x11,0x0,0x11,0x0,0x0,0x0,0x80,0x0,0x80,0xffff8111,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x11,0x0,0x0,0x0,0x80,0x11,0x0,0x0,0x0,0x80,0x11,0x0,0x0,0x80,0x0,0x80,0x11,0x0,0x0,0x91,0x11,0x0,0x0,0x0,0x0,0x11,0xc0000000,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x11,0xc0000000,0x0,0x0,0x80,0x11,0x0,0x0,0x0,0x80,0x11,0x0,0x0,0x80,0x0,0x80,0x11,0x0,0x0,0x91,0xc0000011,0x0,0x0,0x0,0x0,0x11,0xc0000000,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x11,0xc0000000,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0xc0000011,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x11,0x0,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x11,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x0,0x0,0x11,0xc0000000,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x11,0x0,0x0,0x11,0x0,0x0,0x11,0xc0000000,0x0,0x0,0x0,0x11,0x0,0x0,0x11,0x11,0x0,0x0,0x0,0x0,0x0,0x0,0xffff8000,0xc0000000,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x1000000,0x0,0x0,0x0,0x1000000,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x1000000,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x200,0x806000,0x400000,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x4bf9bff,0x400000,0x0,0x2000000,0x0,0x4bf9bff,0x0,0x0,0xbf81ff,0x0,0x4bf9bff,0x0,0x0,0x4bf9bff,0x0,0x0,0x0,0x4bf9bff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ff,0x8000,0x181ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x18000,0x0,0x0,0x0,0x0,0x0,0x0,0x4bf9bff,0x0,0x0,0x3f0000,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x18100,0x0,0x0,0x3f0000,0x0,0x0,0x18003,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x0,0x18003,0x0,0x0,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x18003,0x0,0x0,0x3f0000,0x0,0x0,0x18003,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x0,0x18003,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x18003,0x0,0x0,0x3f0000,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x18100,0x0,0x0,0x3f0000,0x0,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x18003,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x0,0x18100,0x0,0x0,0x18100,0x0,0x0,0x18003,0x0,0x0,0x0,0x0,0x18100,0x0,0x18100,0x18100,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0x3,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with user supplied CharStream.
   * @param stream stream to init with
   */
  public CSS3Parser(final CharStream stream) {
	 token_source = new CSS3ParserTokenManager(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 343; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise.
   * @param stream stream to init with
   */
  public void ReInit(final CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 343; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public CSS3Parser(final CSS3ParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 343; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final CSS3ParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 343; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    final Token nt = jj_nt = token.next;
    final int ret;
    if (nt == null) {
      token.next = token_source.getNextToken();
      ret = jj_ntk = token.next.kind;
    }
    else
      ret = jj_ntk = nt.kind;
    return ret;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[123];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 343; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 123; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
