/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl;

import java.util.Arrays;
import java.util.Collection;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateMatchingGenericStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public interface RangePredicateMatchingStep<N extends RangePredicateOptionsStep<?>>
extends RangePredicateMatchingGenericStep<Object, N> {
    @Override
    default public N between(Object lowerBound, Object upperBound) {
        return this.between(lowerBound, upperBound, ValueModel.MAPPING);
    }

    @Deprecated(since="7.2")
    default public N between(Object lowerBoundValue, Object upperBoundValue, ValueConvert convert) {
        return this.between(Range.between((Object)lowerBoundValue, (Object)upperBoundValue), (Object)ValueConvert.toValueModel(convert));
    }

    default public N between(Object lowerBoundValue, Object upperBoundValue, ValueModel valueModel) {
        return this.within(Range.between((Object)lowerBoundValue, (Object)upperBoundValue), valueModel);
    }

    @Override
    default public N between(Object lowerBound, RangeBoundInclusion lowerBoundInclusion, Object upperBound, RangeBoundInclusion upperBoundInclusion) {
        return this.within((Range<?>)Range.between((Object)lowerBound, (RangeBoundInclusion)lowerBoundInclusion, (Object)upperBound, (RangeBoundInclusion)upperBoundInclusion));
    }

    @Override
    default public N atLeast(Object lowerBoundValue) {
        return this.atLeast(lowerBoundValue, ValueModel.MAPPING);
    }

    @Deprecated(since="7.2")
    default public N atLeast(Object lowerBoundValue, ValueConvert convert) {
        return this.within(Range.atLeast((Object)lowerBoundValue), ValueConvert.toValueModel(convert));
    }

    default public N atLeast(Object lowerBoundValue, ValueModel valueModel) {
        return this.within(Range.atLeast((Object)lowerBoundValue), valueModel);
    }

    @Override
    default public N greaterThan(Object lowerBoundValue) {
        return this.greaterThan(lowerBoundValue, ValueModel.MAPPING);
    }

    @Deprecated(since="7.2")
    default public N greaterThan(Object lowerBoundValue, ValueConvert convert) {
        return this.within(Range.greaterThan((Object)lowerBoundValue), ValueConvert.toValueModel(convert));
    }

    default public N greaterThan(Object lowerBoundValue, ValueModel valueModel) {
        return this.within(Range.greaterThan((Object)lowerBoundValue), valueModel);
    }

    @Override
    default public N atMost(Object upperBoundValue) {
        return this.atMost(upperBoundValue, ValueModel.MAPPING);
    }

    @Deprecated(since="7.2")
    default public N atMost(Object upperBoundValue, ValueConvert convert) {
        return this.within(Range.atMost((Object)upperBoundValue), ValueConvert.toValueModel(convert));
    }

    default public N atMost(Object upperBoundValue, ValueModel valueModel) {
        return this.within(Range.atMost((Object)upperBoundValue), valueModel);
    }

    @Override
    default public N lessThan(Object upperBoundValue) {
        return this.lessThan(upperBoundValue, ValueModel.MAPPING);
    }

    @Deprecated(since="7.2")
    default public N lessThan(Object upperBoundValue, ValueConvert convert) {
        return this.within(Range.lessThan((Object)upperBoundValue), ValueConvert.toValueModel(convert));
    }

    default public N lessThan(Object upperBoundValue, ValueModel valueModel) {
        return this.within(Range.lessThan((Object)upperBoundValue), valueModel);
    }

    @Deprecated(since="7.2")
    default public N range(Range<?> range) {
        return this.within(range, ValueModel.MAPPING);
    }

    @Deprecated(since="7.2")
    default public N range(Range<?> range, ValueConvert convert) {
        return this.within(range, convert);
    }

    @Override
    default public N within(Range<?> range) {
        return this.within(range, ValueModel.MAPPING);
    }

    @Deprecated(since="7.2")
    default public N within(Range<?> range, ValueConvert convert) {
        return this.within(range, ValueConvert.toValueModel(convert));
    }

    public N within(Range<?> var1, ValueModel var2);

    @Override
    default public N withinAny(Range<?> ... ranges) {
        return this.withinAny(Arrays.asList(ranges));
    }

    @Override
    default public N withinAny(Collection<? extends Range<?>> ranges) {
        return this.withinAny(ranges, ValueModel.MAPPING);
    }

    @Deprecated(since="7.2")
    default public N withinAny(Collection<? extends Range<?>> ranges, ValueConvert convert) {
        return this.withinAny(ranges, ValueConvert.toValueModel(convert));
    }

    @Override
    public N withinAny(Collection<? extends Range<?>> var1, ValueModel var2);
}

