/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple.ops;

import java.io.PrintStream;
import org.ejml.concurrency.EjmlConcurrency;
import org.ejml.data.Complex_F64;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixSparse;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.ConvertToDenseException;
import org.ejml.simple.ConvertToImaginaryException;
import org.ejml.simple.SimpleOperations;
import org.ejml.simple.SimpleSparseOperations;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.CommonOps_MT_DSCC;
import org.ejml.sparse.csc.MatrixFeatures_DSCC;
import org.ejml.sparse.csc.NormOps_DSCC;
import org.ejml.sparse.csc.mult.Workspace_MT_DSCC;
import pabeles.concurrency.GrowArray;

public class SimpleOperations_DSCC
implements SimpleSparseOperations<DMatrixSparseCSC, DMatrixRMaj> {
    public transient IGrowArray gw = new IGrowArray();
    public transient DGrowArray gx = new DGrowArray();
    public transient GrowArray<Workspace_MT_DSCC> workspaceMT = new GrowArray(Workspace_MT_DSCC::new);
    public transient GrowArray<DGrowArray> workspaceA = new GrowArray(DGrowArray::new);

    @Override
    public void set(DMatrixSparseCSC A, int row, int column, double value) {
        A.set(row, column, value);
    }

    @Override
    public void set(DMatrixSparseCSC A, int row, int column, double real, double imaginary) {
        throw new ConvertToImaginaryException();
    }

    @Override
    public double get(DMatrixSparseCSC A, int row, int column) {
        return A.get(row, column);
    }

    @Override
    public void get(DMatrixSparseCSC A, int row, int column, Complex_F64 value) {
        value.real = A.get(row, column);
        value.imaginary = 0.0;
    }

    @Override
    public double getReal(DMatrixSparseCSC A, int row, int column) {
        return A.get(row, column);
    }

    @Override
    public double getImaginary(DMatrixSparseCSC A, int row, int column) {
        return 0.0;
    }

    @Override
    public void fill(DMatrixSparseCSC A, double value) {
        if (value != 0.0) {
            throw new ConvertToDenseException();
        }
        A.zero();
    }

    @Override
    public void transpose(DMatrixSparseCSC input, DMatrixSparseCSC output) {
        CommonOps_DSCC.transpose((DMatrixSparseCSC)input, (DMatrixSparseCSC)output, (IGrowArray)this.gw);
    }

    @Override
    public void mult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        if (EjmlConcurrency.useConcurrent((MatrixSparse)A) || EjmlConcurrency.useConcurrent((MatrixSparse)B)) {
            CommonOps_MT_DSCC.mult((DMatrixSparseCSC)A, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output, this.workspaceMT);
        } else {
            CommonOps_DSCC.mult((DMatrixSparseCSC)A, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output);
        }
    }

    @Override
    public void multTransA(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        DMatrixSparseCSC At = new DMatrixSparseCSC(1, 1);
        CommonOps_DSCC.transpose((DMatrixSparseCSC)A, (DMatrixSparseCSC)At, (IGrowArray)this.gw);
        if (EjmlConcurrency.useConcurrent((MatrixSparse)A) || EjmlConcurrency.useConcurrent((MatrixSparse)B)) {
            CommonOps_MT_DSCC.mult((DMatrixSparseCSC)A, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output, this.workspaceMT);
        } else {
            CommonOps_DSCC.mult((DMatrixSparseCSC)At, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output, (IGrowArray)this.gw, (DGrowArray)this.gx);
        }
    }

    @Override
    public void extractDiag(DMatrixSparseCSC input, DMatrixRMaj output) {
        CommonOps_DSCC.extractDiag((DMatrixSparseCSC)input, (DMatrixRMaj)output);
    }

    @Override
    public void multTransA(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent((MatrixSparse)A) || EjmlConcurrency.useConcurrent((Matrix)B)) {
            CommonOps_MT_DSCC.multTransA((DMatrixSparseCSC)A, (DMatrixRMaj)B, (DMatrixRMaj)output, this.workspaceA);
        } else {
            CommonOps_DSCC.multTransA((DMatrixSparseCSC)A, (DMatrixRMaj)B, (DMatrixRMaj)output, null);
        }
    }

    @Override
    public void mult(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent((MatrixSparse)A)) {
            CommonOps_MT_DSCC.mult((DMatrixSparseCSC)A, (DMatrixRMaj)B, (DMatrixRMaj)output, this.workspaceA);
        } else {
            CommonOps_DSCC.mult((DMatrixSparseCSC)A, (DMatrixRMaj)B, (DMatrixRMaj)output);
        }
    }

    @Override
    public void kron(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        throw new RuntimeException("Unsupported for DSCC. Make a feature request if you need this!");
    }

    @Override
    public void plus(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        if (EjmlConcurrency.useConcurrent((MatrixSparse)A)) {
            CommonOps_MT_DSCC.add((double)1.0, (DMatrixSparseCSC)A, (double)1.0, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output, this.workspaceMT);
        } else {
            CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)A, (double)1.0, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output, null, null);
        }
    }

    @Override
    public void minus(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        if (EjmlConcurrency.useConcurrent((MatrixSparse)A)) {
            CommonOps_MT_DSCC.add((double)1.0, (DMatrixSparseCSC)A, (double)-1.0, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output, this.workspaceMT);
        } else {
            CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)A, (double)-1.0, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output, null, null);
        }
    }

    @Override
    public void minus(DMatrixSparseCSC A, double b, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void plus(DMatrixSparseCSC A, double b, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void plus(DMatrixSparseCSC A, double beta, DMatrixSparseCSC b, DMatrixSparseCSC output) {
        if (EjmlConcurrency.useConcurrent((MatrixSparse)A) || EjmlConcurrency.useConcurrent((MatrixSparse)b)) {
            CommonOps_MT_DSCC.add((double)1.0, (DMatrixSparseCSC)A, (double)beta, (DMatrixSparseCSC)b, (DMatrixSparseCSC)output, this.workspaceMT);
        } else {
            CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)A, (double)beta, (DMatrixSparseCSC)b, (DMatrixSparseCSC)output, (IGrowArray)this.gw, (DGrowArray)this.gx);
        }
    }

    @Override
    public void plus(double alpha, DMatrixSparseCSC A, double beta, DMatrixSparseCSC b, DMatrixSparseCSC output) {
        if (EjmlConcurrency.useConcurrent((MatrixSparse)A) || EjmlConcurrency.useConcurrent((MatrixSparse)b)) {
            CommonOps_MT_DSCC.add((double)alpha, (DMatrixSparseCSC)A, (double)beta, (DMatrixSparseCSC)b, (DMatrixSparseCSC)output, this.workspaceMT);
        } else {
            CommonOps_DSCC.add((double)alpha, (DMatrixSparseCSC)A, (double)beta, (DMatrixSparseCSC)b, (DMatrixSparseCSC)output, (IGrowArray)this.gw, (DGrowArray)this.gx);
        }
    }

    @Override
    public double dot(DMatrixSparseCSC A, DMatrixSparseCSC v) {
        return CommonOps_DSCC.dotInnerColumns((DMatrixSparseCSC)A, (int)0, (DMatrixSparseCSC)v, (int)0, (IGrowArray)this.gw, (DGrowArray)this.gx);
    }

    @Override
    public void scale(DMatrixSparseCSC A, double val, DMatrixSparseCSC output) {
        CommonOps_DSCC.scale((double)val, (DMatrixSparseCSC)A, (DMatrixSparseCSC)output);
    }

    @Override
    public void divide(DMatrixSparseCSC A, double val, DMatrixSparseCSC output) {
        CommonOps_DSCC.divide((DMatrixSparseCSC)A, (double)val, (DMatrixSparseCSC)output);
    }

    @Override
    public boolean invert(DMatrixSparseCSC A, DMatrixSparseCSC output) {
        return this.solve(A, output, CommonOps_DSCC.identity((int)A.numRows, (int)A.numCols));
    }

    @Override
    public void setIdentity(DMatrixSparseCSC A) {
        CommonOps_DSCC.setIdentity((DMatrixSparseCSC)A);
    }

    @Override
    public void pseudoInverse(DMatrixSparseCSC A, DMatrixSparseCSC output) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public boolean solve(DMatrixSparseCSC A, DMatrixSparseCSC X, DMatrixSparseCSC B) {
        return CommonOps_DSCC.solve((DMatrixSparseCSC)A, (DMatrixSparseCSC)X, (DMatrixSparseCSC)B);
    }

    @Override
    public boolean solve(DMatrixSparseCSC A, DMatrixRMaj X, DMatrixRMaj B) {
        return CommonOps_DSCC.solve((DMatrixSparseCSC)A, (DMatrixRMaj)X, (DMatrixRMaj)B);
    }

    @Override
    public void zero(DMatrixSparseCSC A) {
        A.zero();
    }

    @Override
    public double normF(DMatrixSparseCSC A) {
        return NormOps_DSCC.normF((DMatrixSparseCSC)A);
    }

    @Override
    public double conditionP2(DMatrixSparseCSC A) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public double determinant(DMatrixSparseCSC A) {
        return CommonOps_DSCC.det((DMatrixSparseCSC)A);
    }

    @Override
    public double trace(DMatrixSparseCSC A) {
        return CommonOps_DSCC.trace((DMatrixSparseCSC)A);
    }

    @Override
    public void setRow(DMatrixSparseCSC A, int row, int startColumn, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A.set(row, startColumn + i, values[i]);
        }
    }

    @Override
    public void setColumn(DMatrixSparseCSC A, int column, int startRow, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A.set(startRow + i, column, values[i]);
        }
    }

    @Override
    public double[] getRow(DMatrixSparseCSC A, int row, int col0, int col1) {
        double[] v = new double[col1 - col0];
        for (int col = col0; col < col1; ++col) {
            int rowIdx0 = A.col_idx[col];
            int rowIdx1 = A.col_idx[col + 1];
            for (int i = rowIdx0; i < rowIdx1; ++i) {
                if (row != A.nz_rows[i]) continue;
                v[col - col0] = A.nz_values[i];
            }
        }
        return v;
    }

    @Override
    public double[] getColumn(DMatrixSparseCSC A, int col, int row0, int row1) {
        double[] v = new double[row1 - row0];
        int rowIdx0 = A.col_idx[col];
        int rowIdx1 = A.col_idx[col + 1];
        for (int i = rowIdx0; i < rowIdx1; ++i) {
            int row = A.nz_rows[i];
            if (row < row0 || row >= row1) continue;
            v[row - row0] = A.nz_values[i];
        }
        return v;
    }

    @Override
    public void extract(DMatrixSparseCSC src, int srcY0, int srcY1, int srcX0, int srcX1, DMatrixSparseCSC dst, int dstY0, int dstX0) {
        CommonOps_DSCC.extract((DMatrixSparseCSC)src, (int)srcY0, (int)srcY1, (int)srcX0, (int)srcX1, (DMatrixSparseCSC)dst, (int)dstY0, (int)dstX0);
    }

    @Override
    public DMatrixSparseCSC diag(DMatrixSparseCSC A) {
        DMatrixSparseCSC output;
        if (MatrixFeatures_DSCC.isVector((DMatrixSparseCSC)A)) {
            int N = Math.max(A.numCols, A.numRows);
            output = new DMatrixSparseCSC(N, N);
            CommonOps_DSCC.diag((DMatrixSparseCSC)output, (double[])A.nz_values, (int)0, (int)N);
        } else {
            int N = Math.min(A.numCols, A.numRows);
            output = new DMatrixSparseCSC(N, 1);
            CommonOps_DSCC.extractDiag((DMatrixSparseCSC)A, (DMatrixSparseCSC)output);
        }
        return output;
    }

    @Override
    public boolean hasUncountable(DMatrixSparseCSC M) {
        return MatrixFeatures_DSCC.hasUncountable((DMatrixSparseCSC)M);
    }

    @Override
    public void changeSign(DMatrixSparseCSC a) {
        CommonOps_DSCC.changeSign((DMatrixSparseCSC)a, (DMatrixSparseCSC)a);
    }

    @Override
    public double elementMax(DMatrixSparseCSC A) {
        return CommonOps_DSCC.elementMax((DMatrixSparseCSC)A);
    }

    @Override
    public double elementMin(DMatrixSparseCSC A) {
        return CommonOps_DSCC.elementMin((DMatrixSparseCSC)A);
    }

    @Override
    public double elementMaxAbs(DMatrixSparseCSC A) {
        return CommonOps_DSCC.elementMaxAbs((DMatrixSparseCSC)A);
    }

    @Override
    public double elementMinAbs(DMatrixSparseCSC A) {
        return CommonOps_DSCC.elementMinAbs((DMatrixSparseCSC)A);
    }

    @Override
    public double elementSum(DMatrixSparseCSC A) {
        return CommonOps_DSCC.elementSum((DMatrixSparseCSC)A);
    }

    @Override
    public void elementMult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        CommonOps_DSCC.elementMult((DMatrixSparseCSC)A, (DMatrixSparseCSC)B, (DMatrixSparseCSC)output, null, null);
    }

    @Override
    public void elementDiv(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementPower(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementPower(DMatrixSparseCSC A, double b, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementExp(DMatrixSparseCSC A, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementLog(DMatrixSparseCSC A, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public boolean isIdentical(DMatrixSparseCSC A, DMatrixSparseCSC B, double tol) {
        return MatrixFeatures_DSCC.isEqualsSort((DMatrixSparseCSC)A, (DMatrixSparseCSC)B, (double)tol);
    }

    @Override
    public void print(PrintStream out, Matrix mat, String format) {
        MatrixIO.print((PrintStream)out, (DMatrixSparseCSC)((DMatrixSparseCSC)mat), (String)format);
    }

    @Override
    public void elementOp(DMatrixSparseCSC A, SimpleOperations.ElementOpReal op, DMatrixSparseCSC output) {
        output.copyStructure(A);
        for (int col = 0; col < A.numCols; ++col) {
            int idx0 = A.col_idx[col];
            int idx1 = A.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                int row = A.nz_rows[i];
                double value = A.nz_values[i];
                output.nz_values[i] = op.op(row, col, value);
            }
        }
    }

    @Override
    public void elementOp(DMatrixSparseCSC A, SimpleOperations.ElementOpComplex op, DMatrixSparseCSC output) {
        throw new ConvertToImaginaryException();
    }
}

