/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.coding;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.packager.rpm.coding.BZip2PayloadCoding;
import org.eclipse.packager.rpm.coding.GzipPayloadCoding;
import org.eclipse.packager.rpm.coding.LZMAPayloadCoding;
import org.eclipse.packager.rpm.coding.NullPayloadCoding;
import org.eclipse.packager.rpm.coding.PayloadCodingProvider;
import org.eclipse.packager.rpm.coding.XZPayloadCoding;
import org.eclipse.packager.rpm.coding.ZstdPayloadCoding;

public class DefaultPayloadCodingRegistry {
    private static final String GZIP = "gzip";
    private static final String BZIP2 = "bzip2";
    private static final String LZMA = "lzma";
    private static final String XZ = "xz";
    private static final String ZSTD = "zstd";
    private static final PayloadCodingProvider NULL_PAYLOAD_CODING = new NullPayloadCoding();
    private static final Map<String, PayloadCodingProvider> REGISTRY = new TreeMap<String, PayloadCodingProvider>();

    public static PayloadCodingProvider get(String coding) throws IOException {
        if (coding == null) {
            return NULL_PAYLOAD_CODING;
        }
        PayloadCodingProvider payloadCoding = REGISTRY.get(coding);
        if (payloadCoding == null) {
            throw new IOException(String.format("Unknown payload coding '%s'", coding));
        }
        return payloadCoding;
    }

    static {
        REGISTRY.put(GZIP, new GzipPayloadCoding());
        REGISTRY.put(BZIP2, new BZip2PayloadCoding());
        REGISTRY.put(LZMA, new LZMAPayloadCoding());
        REGISTRY.put(XZ, new XZPayloadCoding());
        REGISTRY.put(ZSTD, new ZstdPayloadCoding());
    }
}

